/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.response.ResultCode;
import com.jxdinfo.idp.dto.DocTypeDto;
import com.jxdinfo.idp.interf.DocTypeService;
import com.jxdinfo.idp.po.DocTypePo;
import com.jxdinfo.idp.scene.interf.SceneCoreService;
import com.jxdinfo.idp.vo.DocTypeVo;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/docTypeInfo"})
public class DocTypeController {
    @Autowired
    private DocTypeService docTypeService;
    @Autowired
    private SceneCoreService sceneCoreService;

    @PostMapping(value={"/searchResult"})
    public ApiResponse<Page<DocTypeVo>> searchResult(@RequestBody DocTypeDto docTypeDto) {
        Page page = new Page((long)docTypeDto.getCurrent(), (long)docTypeDto.getSize());
        Map result = this.docTypeService.searchResult(docTypeDto);
        long total = (Long)result.get("total");
        List records = (List)result.get("records");
        page.setTotal(total);
        page.setRecords(records);
        return ApiResponse.success((Object)page);
    }

    @GetMapping(value={"/queryDocTypeById"})
    public ApiResponse<DocTypeVo> queryDocTypeById(@RequestParam Long id) {
        return ApiResponse.success((Object)this.docTypeService.queryDocTypeById(id));
    }

    @GetMapping(value={"/queryDocTypeByIds"})
    public ApiResponse<List<DocTypePo>> queryDocTypeByIds(@RequestParam List<Long> ids) {
        return ApiResponse.success((Object)this.docTypeService.getDocTypeListByIds(ids));
    }

    @GetMapping(value={"/deleteDocTypeInfo"})
    public ApiResponse<Boolean> deleteDocTypeInfo(@RequestParam Long id) {
        boolean flag = this.sceneCoreService.hasRelevancy(id.longValue());
        if (flag) {
            return ApiResponse.fail((int)ResultCode.REQ_REJECT.getCode(), (String)"\u5f53\u524d\u6587\u6863\u7c7b\u578b\u6b63\u5728\u4f7f\u7528\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        this.sceneCoreService.deleteRelevancyByDocTypeId(id.longValue());
        this.docTypeService.updateDocTypeDeleteInfo(id);
        return ApiResponse.success();
    }

    @PostMapping(value={"/updateDocTypeInfo"})
    public ApiResponse<Boolean> updateDocTypeInfo(@RequestBody DocTypeDto docTypeDto) {
        this.docTypeService.updateDocTypeInfo(docTypeDto);
        return ApiResponse.success();
    }

    @PostMapping(value={"/addDocTypeInfo"})
    public ApiResponse<Boolean> addDocTypeInfo(@RequestBody DocTypeDto docTypeDto) {
        this.docTypeService.addDocTypeInfo(docTypeDto);
        return ApiResponse.success();
    }
}

