/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.controller;

import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.dto.QueryDocInfoDto;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.vo.DocInfoVo;
import com.jxdinfo.idp.vo.DocTemplateVo;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fileInfo"})
public class FileController {
    @Resource
    private DocService docService;

    @PostMapping(value={"/queryFileInfo"})
    public ApiResponse<Map<String, Object>> queryFileInfo(@RequestBody QueryDocInfoDto queryDocInfoDto) {
        return ApiResponse.success((Object)this.docService.queryFileInfo(queryDocInfoDto));
    }

    @PostMapping(value={"/queryFileByFold"})
    public ApiResponse<Map<String, Object>> queryFileByFold(@RequestBody QueryDocInfoDto queryDocInfoDto) {
        return ApiResponse.success((Object)this.docService.queryFileByFold(queryDocInfoDto));
    }

    @PostMapping(value={"/searchResult"})
    public ApiResponse<Map<String, Object>> searchResult(@RequestBody QueryDocInfoDto queryDocInfoDto) {
        return ApiResponse.success((Object)this.docService.searchResult(queryDocInfoDto));
    }

    @RequestMapping(value={"/updateFileInfo"})
    public ApiResponse<Boolean> updateFileInfo(@RequestBody List<Map<String, String>> list) {
        return ApiResponse.success((Object)this.docService.updateFileInfo(list));
    }

    @RequestMapping(value={"/deleteFileInfo"})
    public ApiResponse<Boolean> deleteFileInfo(@RequestParam Long id) {
        return ApiResponse.success((Object)this.docService.deleteFileInfo(id));
    }

    @RequestMapping(value={"/getDocTemplateList"})
    public ApiResponse<List<DocTemplateVo>> deleteFileInfo(@RequestParam String docId, @RequestParam String docName) {
        return ApiResponse.success((Object)this.docService.getDocTemplate(docId, docName));
    }

    @RequestMapping(value={"/getFileStream"})
    public ApiResponse<Map<String, Object>> getFileStream(@RequestParam String docId) {
        return ApiResponse.success((Object)this.docService.getFileStream(docId));
    }

    @GetMapping(value={"/getDocInfo"})
    public ApiResponse<DocInfoVo> getDocInfo(@RequestParam(value="docId") String docId) {
        return ApiResponse.success((Object)this.docService.getDocInfo(docId));
    }

    @GetMapping(value={"/getDocInfoWithMapper"})
    public ApiResponse<DocInfoVo> getDocInfoWithMapper(@RequestParam(value="docId") String docId) {
        return ApiResponse.success((Object)this.docService.getDocInfoWithMapper(docId));
    }

    @GetMapping(value={"/getDocTotal"})
    public ApiResponse<Long> getDocTotal() {
        return ApiResponse.success((Object)this.docService.getDocTotal());
    }
}

