/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.dm.server.mapper.DocTypeMapper;
import com.jxdinfo.idp.dm.server.mapper.NodeTypeFoldMapper;
import com.jxdinfo.idp.dto.DocTypeDto;
import com.jxdinfo.idp.dto.NodeDto;
import com.jxdinfo.idp.interf.NodeTypeFoldService;
import com.jxdinfo.idp.interf.NodeTypeRelevancyService;
import com.jxdinfo.idp.po.NodeTypePo;
import com.jxdinfo.idp.po.NodeTypeRelevancyPo;
import com.jxdinfo.idp.vo.DocTypeVo;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NodeTypeFoldServiceImpl
extends ServiceImpl<NodeTypeFoldMapper, NodeTypePo>
implements NodeTypeFoldService {
    @Autowired
    private NodeTypeRelevancyService nodeTypeRelevancyService;
    @Resource
    private NodeTypeFoldMapper nodeTypeFoldMapper;
    @Resource
    private DocTypeMapper docTypeMapper;

    public boolean updateNode(NodeDto nodeDto) {
        NodeTypePo nodeTypePo = (NodeTypePo)this.getById(nodeDto.getId());
        nodeTypePo.setName(nodeDto.getName());
        nodeTypePo.setPath(nodeDto.getPath());
        nodeTypePo.setDescription(nodeDto.getDescription());
        return this.updateById(nodeTypePo);
    }

    public boolean deleteNode(String id) {
        ArrayList<String> deleteIds = new ArrayList<String>();
        deleteIds.add(id);
        DocTypeDto docTypeDto = new DocTypeDto();
        docTypeDto.setPid(Long.valueOf(id));
        List<DocTypeVo> list = this.docTypeMapper.searchResult(docTypeDto);
        if (list != null && !list.isEmpty()) {
            return false;
        }
        ArrayList nodeTypePoList = new ArrayList();
        List nodeTypePos = this.nodeTypeRelevancyService.queryNodeIdByPid(nodeTypePoList, id);
        if (nodeTypePos != null && !nodeTypePos.isEmpty()) {
            for (NodeTypePo nodeTypePo : nodeTypePos) {
                docTypeDto.setPid(nodeTypePo.getId());
                List<DocTypeVo> listChild = this.docTypeMapper.searchResult(docTypeDto);
                if (listChild != null && !listChild.isEmpty()) {
                    return false;
                }
                deleteIds.add(String.valueOf(nodeTypePo.getId()));
            }
        }
        for (String nodeId : deleteIds) {
            this.removeById((Serializable)((Object)nodeId));
        }
        return true;
    }

    public NodeTypePo getNode(String id) {
        return (NodeTypePo)this.getById((Serializable)((Object)id));
    }

    public List<NodeTypePo> findAll() {
        QueryWrapper queryWrapper = new QueryWrapper();
        return this.nodeTypeFoldMapper.selectList((Wrapper)queryWrapper);
    }

    public boolean saveNode(NodeDto nodeDto) {
        if (nodeDto == null) {
            return false;
        }
        long id = SnowFlakeUtil.getFlowIdInstance().nextId();
        LocalDateTime now = LocalDateTime.now();
        NodeTypePo nodeTypePo = new NodeTypePo(nodeDto);
        nodeTypePo.setId(Long.valueOf(id));
        nodeTypePo.setFlag(Long.valueOf(id));
        nodeTypePo.setCreateTime(now);
        nodeTypePo.setDeleteFlag(Integer.valueOf(0));
        this.save(nodeTypePo);
        NodeTypeRelevancyPo nodeTypeRelevancyPo = new NodeTypeRelevancyPo();
        nodeTypeRelevancyPo.setCid(Long.valueOf(id));
        nodeTypeRelevancyPo.setPid(nodeDto.getPid());
        nodeTypeRelevancyPo.setDistance(nodeDto.getDistance());
        nodeTypeRelevancyPo.setCreateTime(now);
        this.nodeTypeRelevancyService.save((Object)nodeTypeRelevancyPo);
        return true;
    }
}

