/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.dm.server.mapper.DocTypeMapper;
import com.jxdinfo.idp.dm.server.util.DocUtil;
import com.jxdinfo.idp.dto.DocTypeDto;
import com.jxdinfo.idp.interf.DocTypeService;
import com.jxdinfo.idp.interf.NodeTypeRelevancyService;
import com.jxdinfo.idp.po.DocTypePo;
import com.jxdinfo.idp.po.NodeTypePo;
import com.jxdinfo.idp.vo.DocTypeVo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocTypeServiceImpl
extends ServiceImpl<DocTypeMapper, DocTypePo>
implements DocTypeService {
    @Resource
    private DocTypeMapper docTypeMapper;
    @Autowired
    private NodeTypeRelevancyService nodeTypeRelevancyService;

    public Map<String, Object> searchResult(DocTypeDto docTypeDto) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String docTypeName = DocUtil.queryString(docTypeDto.getDocTypeName());
        docTypeDto.setDocTypeName(docTypeName);
        List<DocTypeVo> docTypeInfoVos = this.docTypeMapper.searchResult(docTypeDto);
        ArrayList nodeTypePoList = new ArrayList();
        if (docTypeDto.getPid() != null) {
            List nodeTypePos = this.nodeTypeRelevancyService.queryNodeIdByPid(nodeTypePoList, docTypeDto.getPid().toString());
            for (NodeTypePo nodeTypePo : nodeTypePos) {
                docTypeDto.setPid(nodeTypePo.getId());
                docTypeInfoVos.addAll(this.docTypeMapper.searchResult(docTypeDto));
            }
        }
        int pageNum = docTypeDto.getCurrent();
        int pageSize = docTypeDto.getSize();
        int start = (pageNum - 1) * pageSize;
        Long total = docTypeInfoVos.size();
        result.put("records", docTypeInfoVos.stream().skip(start).limit(pageSize).collect(Collectors.toList()));
        result.put("total", total);
        return result;
    }

    public DocTypeVo queryDocTypeById(Long id) {
        DocTypeVo docTypeVo = this.docTypeMapper.queryDocTypeById(id);
        return docTypeVo;
    }

    public List<DocTypePo> getDocTypeListByIds(List<Long> ids) {
        return this.docTypeMapper.selectBatchIds(ids);
    }

    public List<DocTypeVo> getDocTypeList() {
        return this.docTypeMapper.getDocTypeList();
    }

    public int updateDocTypeInfo(DocTypeDto docTypeDto) {
        List formatList = docTypeDto.getFormat();
        String format = "";
        if (!formatList.isEmpty()) {
            for (int i = 0; i < formatList.size(); ++i) {
                format = format + (String)formatList.get(i) + ",";
            }
            format = format.substring(0, format.length() - 1);
        }
        return this.docTypeMapper.updateDocTypeInfo(docTypeDto.getId(), docTypeDto.getDocTypeName(), format);
    }

    public int updateDocTypeDeleteInfo(Long id) {
        return this.docTypeMapper.updateDocTypeDeleteInfo(id, "1", LocalDateTime.now());
    }

    public void addDocTypeInfo(DocTypeDto docTypeDto) {
        List formatList = docTypeDto.getFormat();
        String format = "";
        if (!formatList.isEmpty()) {
            for (int i = 0; i < formatList.size(); ++i) {
                format = format + (String)formatList.get(i) + ",";
            }
            format = format.substring(0, format.length() - 1);
        }
        Long id = SnowFlakeUtil.getFlowIdInstance().nextId();
        this.docTypeMapper.insertDocTypeInfo(id, docTypeDto.getDocTypeName(), format, docTypeDto.getPid(), docTypeDto.getCreator());
    }
}

