/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.service.impl;

import cn.hutool.core.thread.ThreadUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.util.AddressUtils;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.file.FileUtil;
import com.jxdinfo.idp.dm.server.enums.DocFormatEnum;
import com.jxdinfo.idp.dm.server.mapper.DocInfoMapper;
import com.jxdinfo.idp.dm.server.mapper.NodeFoldMapper;
import com.jxdinfo.idp.dm.server.schedule.ThreadPoolToPdf;
import com.jxdinfo.idp.dm.server.util.DocUtil;
import com.jxdinfo.idp.dto.DocInfoDto;
import com.jxdinfo.idp.dto.NodeDto;
import com.jxdinfo.idp.dto.UploadDto;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.interf.DocVersionService;
import com.jxdinfo.idp.interf.FileSliceUploadService;
import com.jxdinfo.idp.interf.FileSystemInterface;
import com.jxdinfo.idp.interf.NodeFoldService;
import com.jxdinfo.idp.interf.NodeRelevancyService;
import com.jxdinfo.idp.po.DocFilePo;
import com.jxdinfo.idp.po.DocVersion;
import com.jxdinfo.idp.po.FileInfoPo;
import com.jxdinfo.idp.po.NodePo;
import com.jxdinfo.idp.po.NodeRelevancyPo;
import com.jxdinfo.idp.vo.DocInfoVo;
import com.jxdinfo.idp.vo.FileInfoVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileSliceUploadServiceImpl
implements FileSliceUploadService {
    private static final Logger log = LoggerFactory.getLogger(FileSliceUploadServiceImpl.class);
    @Resource
    private DocService docService;
    @Resource
    private DocInfoMapper docInfoMapper;
    @Resource
    private NodeFoldMapper nodeFoldMapper;
    @Resource
    private FileSystemInterface fileSystemInterface;
    @Resource
    private NodeFoldService nodeService;
    @Resource
    private DocVersionService docVersionService;
    @Resource
    private NodeRelevancyService nodeRelevancyService;
    @Value(value="${docbase.savePath}")
    private String savePath;
    @Value(value="${docbase.breakdir}")
    private String breakdir;
    @Value(value="${docbase.pdfPath}")
    private String pdfPath;

    public JSONObject cheackDoc(UploadDto uploadDto) {
        JSONObject jsonObject = new JSONObject();
        return jsonObject;
    }

    public boolean submitDoc(Map<String, Object> requestBody) {
        List doclist = (List)requestBody.get("docInfo");
        List nodelist = (List)requestBody.get("node");
        String docId = requestBody.get("docId").toString();
        ArrayList<Long> docIds = new ArrayList<Long>();
        ArrayList<Long> nodeIds = new ArrayList<Long>();
        if (doclist != null && !doclist.isEmpty()) {
            for (Map map : doclist) {
                docIds.add(Long.valueOf(String.valueOf(map.get("id"))));
            }
        }
        if (nodelist != null && !nodelist.isEmpty()) {
            for (Map map : nodelist) {
                nodeIds.add(Long.valueOf(String.valueOf(map.get("id"))));
            }
        }
        if (!docIds.isEmpty()) {
            this.docService.updateFileInfo(doclist);
            this.saveDocVersion(docIds, docId);
        }
        if (!nodeIds.isEmpty()) {
            this.nodeFoldMapper.updateNode(nodeIds);
        }
        return true;
    }

    private void saveDocVersion(List<Long> docIds, String docId) {
        if (StringUtils.isNotBlank((CharSequence)docId)) {
            ArrayList<DocVersion> list = new ArrayList<DocVersion>();
            ArrayList<Long> fileIdList = new ArrayList<Long>();
            fileIdList.add(Long.valueOf(docId));
            QueryWrapper versionQueryWrapper = new QueryWrapper();
            versionQueryWrapper.eq((Object)"doc_id", (Object)docId);
            DocVersion docVersion = (DocVersion)this.docVersionService.getOne((Wrapper)versionQueryWrapper);
            if (docVersion != null) {
                this.getDocVersionList(docIds, docVersion, list, fileIdList);
                this.docVersionService.removeById((Object)docVersion);
                this.docVersionService.saveBatch(list);
            } else {
                DocVersion docVersion1 = this.getDocVersion(Long.valueOf(docId), null, 1);
                list.add(docVersion1);
                this.getDocVersionList(docIds, docVersion1, list, fileIdList);
                this.docVersionService.saveBatch(list);
            }
            this.docService.removeByIds(fileIdList);
        }
    }

    private void getDocVersionList(List<Long> docIds, DocVersion docVersion, List<DocVersion> list, List<Long> fileIdList) {
        for (int i = 0; i < docIds.size(); ++i) {
            if (i == docIds.size() - 1) {
                list.add(this.getDocVersion(docIds.get(i), docVersion, 0));
                continue;
            }
            fileIdList.add(docIds.get(i));
            list.add(this.getDocVersion(docIds.get(i), docVersion, 1));
        }
    }

    private DocVersion getDocVersion(Long docId, DocVersion docVersion, int deleteFlag) {
        LocalDateTime now = LocalDateTime.now();
        DocVersion docVersion1 = new DocVersion();
        docVersion1.setDocId(docId);
        if (docVersion == null) {
            long nextId = SnowFlakeUtil.getFlowIdInstance().nextId();
            docVersion1.setVersionReference(Long.valueOf(nextId));
            docVersion1.setVersionNumber(0);
        } else {
            docVersion1.setVersionReference(docVersion.getVersionReference());
            docVersion1.setVersionNumber(docVersion.getVersionNumber() + 1);
            docVersion.setVersionNumber(docVersion1.getVersionNumber());
        }
        docVersion1.setDeleteFlag(Integer.valueOf(deleteFlag));
        docVersion1.setCreateTime(now);
        return docVersion1;
    }

    public JSONObject cheackMd5(UploadDto uploadDto) {
        JSONObject jsonObject = new JSONObject();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"md5", (Object)uploadDto.getMd5());
        List list = this.fileSystemInterface.list((Wrapper)queryWrapper);
        if (list != null && !list.isEmpty()) {
            String fileId = String.valueOf(((DocFilePo)list.get(0)).getId());
            Map<String, Object> b = this.fastUpload(fileId, uploadDto.getPid(), uploadDto.getFileName(), uploadDto.getFsType());
            jsonObject.put("fileId", b.get("fileId"));
            jsonObject.put("file", b.get("file"));
            jsonObject.put("skipUpload", b.get("flag"));
        }
        return jsonObject;
    }

    public JSONObject saveChunck(MultipartFile file, String chunkNumber, String md5, Long currentChunkSize, String totalChunks) {
        try {
            JSONObject jsonObject = new JSONObject();
            String ip = AddressUtils.getLocalHostExactAddress().getHostAddress();
            File chunckFile = new File(this.breakdir + File.separator + md5 + AddressUtils.getLocalHostExactAddress().getHostAddress() + File.separator + chunkNumber);
            FileUtil.createFilePath((File)chunckFile);
            if (!chunckFile.exists() || chunckFile.length() != currentChunkSize.longValue()) {
                FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)chunckFile);
            }
            String[] list = new File(this.breakdir + File.separator + md5 + AddressUtils.getLocalHostExactAddress().getHostAddress()).list();
            jsonObject.put("uploaded", (Object)list);
            if (StringUtils.equals((CharSequence)chunkNumber, (CharSequence)totalChunks)) {
                jsonObject.put("needMerge", (Object)true);
            }
            return jsonObject;
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5206\u7247\u8fc7\u7a0b\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u4fdd\u5b58\u5206\u7247\u8fc7\u7a0b\u5f02\u5e38", (Throwable)e);
        }
    }

    public JSONObject upload(UploadDto uploadDto) {
        try {
            File tempFile;
            JSONObject jsonObject = new JSONObject();
            String md5 = uploadDto.getMd5();
            String fileName = uploadDto.getFileName();
            Long pid = uploadDto.getPid();
            String fsType = uploadDto.getFsType();
            int isFold = uploadDto.getIsFold();
            File f = new File(this.breakdir + File.separator + md5 + File.separator);
            ArrayList<Object> fileList = new ArrayList<Object>(Arrays.asList((Object[])Objects.requireNonNull(new File(this.breakdir + File.separator + md5 + File.separator).listFiles())));
            fileList.sort((Comparator<Object>)new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    if (Integer.parseInt(o1.getName()) < Integer.parseInt(o2.getName())) {
                        return -1;
                    }
                    return 1;
                }
            });
            String suffix = uploadDto.getFormat();
            String random = UUID.randomUUID().toString().replace("-", "");
            List<String> zipformat = DocFormatEnum.getFormatList();
            File outputFile = zipformat.contains(suffix) ? new File(this.breakdir + File.separator + random + "." + suffix) : new File(this.savePath + File.separator + random + "." + suffix);
            FileUtil.createFilePath((File)outputFile);
            FileChannel outChannel = new FileOutputStream(outputFile).getChannel();
            for (File file : fileList) {
                FileChannel inChannel = new FileInputStream(file).getChannel();
                try {
                    inChannel.transferTo(0L, inChannel.size(), outChannel);
                }
                catch (Exception e) {
                    log.error("\u5408\u5e76\u5206\u7247\u5f02\u5e38", (Throwable)e);
                    throw new BusinessException("\u5408\u5e76\u5206\u7247\u5f02\u5e38", (Throwable)e);
                }
                finally {
                    inChannel.close();
                    file.delete();
                }
            }
            if (zipformat.contains(suffix)) {
                List<DocInfoVo> docInfoVos = this.uploadZipFile(pid, outputFile.getPath(), isFold, suffix);
                jsonObject.put("file", docInfoVos);
                return jsonObject;
            }
            File outputPdfFile = DocUtil.getPdfPath(suffix);
            String string = FileUtil.getDocFormat((File)outputFile);
            DocFilePo docFilePo = new DocFilePo(null, fileName, outputFile.getPath(), null, outputFile.getPath(), Long.valueOf(outputFile.length()), md5);
            if (outputPdfFile != null) {
                docFilePo.setPdfPath(outputPdfFile.getPath());
            } else {
                docFilePo.setPdfPath(outputFile.getPath());
            }
            if ("pdf".equals(suffix)) {
                docFilePo.setContrastPath(this.pdfPath + File.separator + random + ".docx");
            }
            this.fileSystemInterface.save((Object)docFilePo);
            FileInfoPo fileInfoPo = new FileInfoPo(docFilePo.getId(), fileName, string, pid, fsType, 111, docFilePo.getId(), 0);
            fileInfoPo.setDeleteFlag(Integer.valueOf(2));
            if (outputPdfFile != null) {
                fileInfoPo.setDocConvert(Integer.valueOf(2));
            } else {
                fileInfoPo.setDocConvert(Integer.valueOf(0));
            }
            this.docService.save((Object)fileInfoPo);
            if (outputPdfFile != null) {
                ThreadUtil.execute(() -> DocUtil.toPdfThread(fileInfoPo.getId(), outputFile, outputPdfFile));
            }
            if ((tempFile = new File(this.breakdir + File.separator + md5)).isDirectory() && tempFile.exists()) {
                tempFile.delete();
            }
            jsonObject.put("fileId", (Object)docFilePo.getId());
            jsonObject.put("filePath", (Object)docFilePo.getFilePath());
            jsonObject.put("file", (Object)fileInfoPo);
            return jsonObject;
        }
        catch (Exception e) {
            log.error("\u5206\u7247\u5408\u5e76\u8fc7\u7a0b\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u5206\u7247\u5408\u5e76\u8fc7\u7a0b\u5f02\u5e38", (Throwable)e);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    private Map<String, Object> fastUpload(String fileId, Long pid, String fileName, String fsType) {
        FileInfoVo fileInfoVo = this.docInfoMapper.getFileInfo(fileId);
        FileInfoPo fileInfoPo = new FileInfoPo(fileInfoVo);
        DocFilePo docFilePo = (DocFilePo)this.fileSystemInterface.getById((Serializable)((Object)fileId));
        LocalDateTime now = LocalDateTime.now();
        docFilePo.setId(null);
        docFilePo.setFileName(fileName);
        docFilePo.setCreateTime(now);
        boolean save = this.fileSystemInterface.save((Object)docFilePo);
        fileInfoPo.setId(docFilePo.getId());
        fileInfoPo.setLogo(docFilePo.getId());
        fileInfoPo.setPid(pid);
        fileInfoPo.setName(fileName);
        fileInfoPo.setCreateTime(now);
        fileInfoPo.setDeleteFlag(Integer.valueOf(2));
        fileInfoPo.setFsType(fsType);
        boolean save1 = this.docService.save((Object)fileInfoPo);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileId", docFilePo.getId());
        map.put("file", fileInfoPo);
        if (save && save1) {
            map.put("flag", true);
        } else {
            map.put("flag", false);
        }
        return map;
    }

    @Transactional(rollbackFor={Exception.class})
    public JSONObject cleanUploadedFile(Map<String, List<Long>> idList) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)10000);
        ArrayList<Long> docList = new ArrayList<Long>();
        ArrayList<Long> nodeList = new ArrayList<Long>();
        if (idList == null) {
            List<DocFilePo> docFiles = this.docInfoMapper.getDocFiles(null, 2);
            List<NodePo> nodes = this.nodeFoldMapper.getNodes(null, 2);
            if (ObjectUtils.isEmpty(docFiles) && ObjectUtils.isEmpty(nodes)) {
                return null;
            }
            for (DocFilePo docFilePo : docFiles) {
                docList.add(docFilePo.getId());
            }
            for (NodePo nodePo : nodes) {
                nodeList.add(nodePo.getId());
            }
        } else {
            docList.addAll((Collection)idList.get("docIds"));
            nodeList.addAll((Collection)idList.get("nodeIds"));
        }
        if (!docList.isEmpty()) {
            this.docInfoMapper.cleanDoc(docList);
        }
        if (!nodeList.isEmpty()) {
            this.nodeFoldMapper.cleanNode(nodeList);
        }
        jsonObject.put("msg", (Object)"\u5220\u9664\u6210\u529f");
        return jsonObject;
    }

    private List<DocInfoVo> uploadZipFile(Long pid, String filePath, int isFold, String suffix) {
        ArrayList<String> zipFoldList = new ArrayList<String>();
        List<DocInfoVo> docInfoVos = null;
        try {
            String nodePidPath = ((NodePo)this.nodeService.getById((Serializable)pid)).getPath();
            ArrayList<NodeDto> nodeDtoList = new ArrayList<NodeDto>();
            ArrayList<DocInfoDto> docInfoDtoList = new ArrayList<DocInfoDto>();
            HashMap<Long, NodeDto> nodeCidMap = new HashMap<Long, NodeDto>();
            if ("zip".equals(suffix)) {
                DocUtil.unzipFile(filePath, this.breakdir, nodePidPath, nodeDtoList, docInfoDtoList, zipFoldList, 2);
            } else if ("tar".equals(suffix)) {
                DocUtil.untarFile(filePath, this.breakdir, nodePidPath, nodeDtoList, docInfoDtoList, zipFoldList, 2);
            }
            log.info("========================\u6587\u4ef6\u89e3\u538b\u6210\u529f\uff01=================================");
            DocUtil.buildNodeAndDoc(nodeDtoList, docInfoDtoList, nodeCidMap);
            log.info("========================\u76ee\u5f55\u5173\u7cfb\u5339\u914d\u6210\u529f\uff01=================================");
            DocUtil.copyFileToSavePath(docInfoDtoList);
            log.info("========================\u6587\u6863\u8f6c\u79fb\u6210\u529f\uff01=================================");
            docInfoVos = this.packByZipDoc(isFold, nodeDtoList, docInfoDtoList, pid, nodeCidMap);
            log.info("========================\u6587\u6863\u6301\u4e45\u5316\u6210\u529f\uff01=================================");
            ThreadPoolToPdf.ThreadPool(docInfoDtoList);
        }
        catch (Exception e) {
            throw new BusinessException("\u6587\u4ef6\u89e3\u538b\u8fc7\u7a0b\u5f02\u5e38", (Throwable)e);
        }
        return docInfoVos;
    }

    private List<DocInfoVo> packByZipDoc(int isFold, List<NodeDto> nodeDtoList, List<DocInfoDto> docInfoDtoList, Long pid, Map<Long, NodeDto> nodeCidMap) {
        ArrayList<NodePo> nodeList = new ArrayList<NodePo>();
        ArrayList<NodeRelevancyPo> nodeRelevancyVo = new ArrayList<NodeRelevancyPo>();
        ArrayList<FileInfoPo> fileInfoPoList = new ArrayList<FileInfoPo>();
        ArrayList<DocFilePo> docFilePoList = new ArrayList<DocFilePo>();
        ArrayList<DocInfoVo> docInfoVos = new ArrayList<DocInfoVo>();
        DocUtil.buildSortObjectList(pid, nodeDtoList, nodeRelevancyVo, nodeList, docInfoDtoList, fileInfoPoList, docFilePoList, docInfoVos);
        for (int i = 0; i < nodeRelevancyVo.size(); ++i) {
            if (!nodeRelevancyVo.get(i).getPid().equals(pid)) continue;
            NodeDto nodeDto = nodeCidMap.get(nodeRelevancyVo.get(i).getCid());
            docInfoVos.add(new DocInfoVo(nodeDto));
        }
        this.getChildrenDocInfoVos(docInfoVos, docInfoDtoList, nodeRelevancyVo, nodeCidMap);
        DocUtil.saveDocAndNode(isFold, pid, nodeCidMap, nodeList, nodeDtoList, fileInfoPoList, docFilePoList);
        return docInfoVos;
    }

    private List<DocInfoVo> getChildrenDocInfoVos(List<DocInfoVo> docInfoVos, List<DocInfoDto> docInfoDtoList, List<NodeRelevancyPo> nodeRelevancyPoList, Map<Long, NodeDto> nodeMap) {
        for (DocInfoVo docInfoVo : docInfoVos) {
            if (!"folder".equals(docInfoVo.getFormat())) continue;
            ArrayList<DocInfoVo> docInfoVos1 = new ArrayList<DocInfoVo>();
            for (DocInfoDto docInfoDto : docInfoDtoList) {
                if (!docInfoVo.getId().equals(docInfoDto.getPid())) continue;
                docInfoVos1.add(new DocInfoVo(docInfoDto));
            }
            for (NodeRelevancyPo nodeRelevancyPo : nodeRelevancyPoList) {
                if (!nodeRelevancyPo.getPid().equals(docInfoVo.getId())) continue;
                NodeDto nodeDto = nodeMap.get(nodeRelevancyPo.getCid());
                docInfoVos1.add(new DocInfoVo(nodeDto));
            }
            docInfoVo.setDocInfoVoList(docInfoVos1);
            this.getChildrenDocInfoVos(docInfoVos1, docInfoDtoList, nodeRelevancyPoList, nodeMap);
        }
        return docInfoVos;
    }
}

