/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.dm.server.mapper.DocInfoMapper;
import com.jxdinfo.idp.dm.server.util.DocUtil;
import com.jxdinfo.idp.dto.QueryDocInfoDto;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.interf.DocTypeService;
import com.jxdinfo.idp.interf.FileSystemInterface;
import com.jxdinfo.idp.interf.NodeFoldService;
import com.jxdinfo.idp.interf.NodeRelevancyService;
import com.jxdinfo.idp.po.DocFilePo;
import com.jxdinfo.idp.po.FileInfoPo;
import com.jxdinfo.idp.po.NodePo;
import com.jxdinfo.idp.vo.DocInfoVo;
import com.jxdinfo.idp.vo.DocTemplateVo;
import com.jxdinfo.idp.vo.FileInfoVo;
import com.jxdinfo.idp.vo.NodeVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DocServiceImpl
extends ServiceImpl<DocInfoMapper, FileInfoPo>
implements DocService {
    @Resource
    private DocInfoMapper docInfoMapper;
    @Resource
    private FileSystemInterface fileSystemInterface;
    @Resource
    private NodeFoldService nodeService;
    @Resource
    private NodeRelevancyService nodeRelevancyService;
    @Resource
    private DocTypeService docTypeService;
    @Value(value="${docbase.savePath}")
    private String savePath;

    public Map<String, Object> queryFileInfo(QueryDocInfoDto queryDocInfoDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Page page = queryDocInfoDto.getPage(DocInfoVo.class);
        List<DocInfoVo> docInfoVos = this.docInfoMapper.queryFileInfo((Page<DocInfoVo>)page, queryDocInfoDto);
        int total = this.docInfoMapper.queryFileAndFoldCount(queryDocInfoDto);
        int foldCount = this.docInfoMapper.queryFoldCount(queryDocInfoDto);
        int fileCount = this.docInfoMapper.queryFileCount(queryDocInfoDto);
        map.put("data", docInfoVos);
        map.put("count", docInfoVos.size());
        map.put("total", total);
        map.put("foldCount", foldCount);
        map.put("fileCount", fileCount);
        return map;
    }

    public Map<String, Object> queryFileByFold(QueryDocInfoDto queryDocInfoDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap docTypePos = new HashMap();
        HashMap docFilePos = new HashMap();
        Long pid = queryDocInfoDto.getPid();
        List fsType = queryDocInfoDto.getFsType();
        Page page = queryDocInfoDto.getPage(FileInfoPo.class);
        NodePo nodePo = (NodePo)this.nodeService.getById((Serializable)pid);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (fsType != null && !fsType.isEmpty()) {
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"pid", (Object)pid)).in((Object)"fs_type", (Collection)fsType)).orderByDesc((Object)"create_time");
        } else {
            ((QueryWrapper)queryWrapper.eq((Object)"pid", (Object)pid)).orderByDesc((Object)"create_time");
        }
        Page page1 = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        long count = this.count((Wrapper)queryWrapper);
        List records = page1.getRecords();
        List docFileList = this.fileSystemInterface.list();
        List docTypeList = this.docTypeService.getDocTypeList();
        docTypeList.forEach(docTypeVo -> docTypePos.put(String.valueOf(docTypeVo.getId()), docTypeVo.getDocTypeName()));
        docFileList.forEach(docFilePo -> docFilePos.put(docFilePo.getId(), docFilePo.getPdfPath()));
        List fileInfoVoList = new FileInfoVo().getFileInfoVoList(records);
        fileInfoVoList.forEach(fileInfoVo -> {
            fileInfoVo.setFoldName(nodePo.getName());
            fileInfoVo.setFsType((String)docTypePos.get(fileInfoVo.getFsType()));
            fileInfoVo.setPdfPath((String)docFilePos.get(fileInfoVo.getId()));
        });
        map.put("data", fileInfoVoList);
        map.put("count", fileInfoVoList.size());
        map.put("total", count);
        return map;
    }

    public Map<String, Object> searchResult(QueryDocInfoDto queryDocInfoDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<DocInfoVo> docInfoVoResult = this.getDocInfoVo(queryDocInfoDto);
        List<Object> collect = null;
        collect = StringUtils.isBlank((CharSequence)queryDocInfoDto.getDocName()) ? docInfoVoResult.stream().filter(docInfoVo -> !docInfoVo.getFormat().equals("folder")).collect(Collectors.toList()) : docInfoVoResult;
        map.put("total", collect.size());
        map.put("data", collect);
        return map;
    }

    private List<DocInfoVo> getDocInfoVo(QueryDocInfoDto queryDocInfoDto) {
        ArrayList<DocInfoVo> docInfoVoResult = new ArrayList<DocInfoVo>();
        List nodePos = this.nodeRelevancyService.queryNodeIdByPid(queryDocInfoDto.getPid());
        for (NodeVo nodeVo : nodePos) {
            queryDocInfoDto.setPid(nodeVo.getId());
            docInfoVoResult.addAll(this.docInfoMapper.searchResult(queryDocInfoDto));
        }
        return docInfoVoResult;
    }

    public List<DocTemplateVo> getDocTemplate(String docId, String docName) {
        List<Object> list = new ArrayList<DocTemplateVo>();
        if (StringUtils.isBlank((CharSequence)docId)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"delete_flag", (Object)0);
            if (StringUtils.isNotBlank((CharSequence)docName)) {
                queryWrapper.like((Object)"name", (Object)docName);
            }
            list = this.list((Wrapper)queryWrapper).stream().map(DocTemplateVo::new).collect(Collectors.toList());
        } else {
            list.add(new DocTemplateVo((FileInfoPo)this.getById((Serializable)((Object)docId))));
        }
        return list;
    }

    public DocTemplateVo getDocTemplateById(String docId) {
        return new DocTemplateVo((FileInfoPo)this.getById((Serializable)((Object)docId)));
    }

    public boolean updateFileInfo(List<Map<String, String>> list) {
        ArrayList<FileInfoPo> fileInfoPoArrayList = new ArrayList<FileInfoPo>();
        ArrayList<DocFilePo> docFilePoArrayList = new ArrayList<DocFilePo>();
        for (Map<String, String> map : list) {
            DocFilePo docFilePo = (DocFilePo)this.fileSystemInterface.getById((Serializable)Long.valueOf(String.valueOf(map.get("id"))));
            FileInfoVo fileInfoVo = this.docInfoMapper.getFileInfo(String.valueOf(map.get("id")));
            FileInfoPo fileInfoPo = new FileInfoPo(fileInfoVo);
            fileInfoPo.setFsType(String.valueOf(map.get("fsType")));
            if (StringUtils.isNotBlank((CharSequence)map.get("docName"))) {
                fileInfoPo.setName(map.get("docName"));
                docFilePo.setFileName(map.get("docName"));
            }
            fileInfoPo.setCreateTime(docFilePo.getCreateTime());
            fileInfoPo.setDeleteFlag(Integer.valueOf(0));
            fileInfoPo.setDeleteTime(null);
            docFilePoArrayList.add(docFilePo);
            fileInfoPoArrayList.add(fileInfoPo);
        }
        this.fileSystemInterface.updateBatchById(docFilePoArrayList);
        this.docInfoMapper.updateDocFile(fileInfoPoArrayList);
        return true;
    }

    public boolean deleteFileInfo(String id) {
        return this.removeById((Serializable)((Object)id));
    }

    public Map<String, Object> getFileStream(String docId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FileInfoPo fileInfoPo = this.docInfoMapper.getFileInfoPoWithMapper(Long.parseLong(docId));
        if (fileInfoPo == null) {
            this.log.error(docId + ":\u6587\u4ef6\u4e0d\u5b58\u5728");
            return map;
        }
        map.put("docName", fileInfoPo.getName());
        map.put("format", fileInfoPo.getFormat());
        DocFilePo docFilePo = (DocFilePo)this.fileSystemInterface.getById((Serializable)((Object)docId));
        if (docFilePo == null) {
            return null;
        }
        File file = new File(docFilePo.getFilePath());
        if (!file.exists()) {
            this.log.error(docId + "\u6587\u4ef6\u5730\u5740\u4e0d\u5b58\u5728");
            return map;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] buffer = new byte[fileInputStream.available()];
            fileInputStream.read(buffer);
            map.put("fileStream", buffer);
        }
        catch (IOException e) {
            throw new BusinessException("\u83b7\u53d6" + fileInfoPo.getName() + "\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
        }
        return map;
    }

    public DocInfoVo getDocInfo(String docId) {
        if (StringUtils.isNotBlank((CharSequence)docId)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"id", (Object)docId);
            FileInfoPo fileInfoPo = (FileInfoPo)this.docInfoMapper.selectOne((Wrapper)queryWrapper);
            DocFilePo docFilePo = (DocFilePo)this.fileSystemInterface.getById((Serializable)((Object)docId));
            DocInfoVo docInfoVo = new DocInfoVo();
            docInfoVo.setId(fileInfoPo.getId());
            docInfoVo.setName(fileInfoPo.getName());
            docInfoVo.setPid(fileInfoPo.getPid());
            docInfoVo.setFormat(fileInfoPo.getFormat());
            docInfoVo.setDocConvert(fileInfoPo.getDocConvert().intValue());
            docInfoVo.setFilePath(docFilePo.getFilePath());
            docInfoVo.setPdfPath(docFilePo.getPdfPath());
            docInfoVo.setFileSize(String.valueOf(docFilePo.getFileSize()));
            return docInfoVo;
        }
        return null;
    }

    public DocInfoVo getDocInfoWithMapper(String docId) {
        if (StringUtils.isNotBlank((CharSequence)docId)) {
            FileInfoPo fileInfoPo = this.docInfoMapper.getFileInfoPoWithMapper(Long.parseLong(docId));
            DocFilePo docFilePo = (DocFilePo)this.fileSystemInterface.getById((Serializable)((Object)docId));
            DocInfoVo docInfoVo = new DocInfoVo();
            docInfoVo.setId(fileInfoPo.getId());
            docInfoVo.setName(fileInfoPo.getName());
            docInfoVo.setPid(fileInfoPo.getPid());
            docInfoVo.setFormat(fileInfoPo.getFormat());
            docInfoVo.setFilePath(docFilePo.getFilePath());
            docInfoVo.setPdfPath(docFilePo.getPdfPath());
            docInfoVo.setDocConvert(fileInfoPo.getDocConvert().intValue());
            docInfoVo.setFileSize(String.valueOf(docFilePo.getFileSize()));
            return docInfoVo;
        }
        return null;
    }

    public Long getDocTotal() {
        return this.count();
    }

    public Map<String, List<Long>> getFoldAndFileOfId(Long pid) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        ArrayList fileIdList = new ArrayList();
        ArrayList foldeIdList = new ArrayList();
        QueryDocInfoDto queryDocInfoDto = new QueryDocInfoDto();
        queryDocInfoDto.setPid(pid);
        List<DocInfoVo> docInfoVoList = this.getDocInfoVo(queryDocInfoDto);
        docInfoVoList.forEach(docInfoVo -> {
            if (docInfoVo.getFormat().equals("folder") && !DocUtil.checkInitFold(docInfoVo.getId())) {
                foldeIdList.add(docInfoVo.getId());
            } else {
                fileIdList.add(docInfoVo.getId());
            }
        });
        map.put("fileIdList", fileIdList);
        map.put("foldeIdList", foldeIdList);
        return map;
    }

    public FileInfoPo getFileInfoPoWithMapper(Long id) {
        return this.docInfoMapper.getFileInfoPoWithMapper(id);
    }

    public boolean updateFileInfoWithMapper(FileInfoPo fileInfoPo) {
        return this.docInfoMapper.updateFileInfoPoWithMapper(fileInfoPo);
    }
}

