/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.dm.server.mapper.DocTypeMapper;
import com.jxdinfo.idp.dm.server.mapper.NodeTypeRelevancyMapper;
import com.jxdinfo.idp.dto.NodeTypeDto;
import com.jxdinfo.idp.interf.NodeTypeRelevancyService;
import com.jxdinfo.idp.po.NodeTypePo;
import com.jxdinfo.idp.po.NodeTypeRelevancyPo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class NodeTypeRelevancyServiceImpl
extends ServiceImpl<NodeTypeRelevancyMapper, NodeTypeRelevancyPo>
implements NodeTypeRelevancyService {
    @Resource
    private NodeTypeRelevancyMapper nodeTypeRelevancyMapper;
    @Resource
    private DocTypeMapper docTypeMapper;

    public List<NodeTypeDto> queryTypeNodeTree(String pid) {
        String localPid = this.getPid(pid);
        List<NodeTypePo> nodePos = this.nodeTypeRelevancyMapper.queryNode(localPid);
        ArrayList<NodeTypeDto> nodeTypeDtoList = new ArrayList<NodeTypeDto>();
        if (nodePos != null && !nodePos.isEmpty()) {
            for (NodeTypePo nodeTypePo : nodePos) {
                NodeTypeDto nodeTypeDto = new NodeTypeDto();
                nodeTypeDto.setId(nodeTypePo.getId());
                nodeTypeDto.setName(nodeTypePo.getName());
                nodeTypeDto.setPath(nodeTypePo.getPath());
                nodeTypeDto.setFlag(nodeTypePo.getFlag());
                nodeTypeDto.setDescription(nodeTypePo.getDescription());
                nodeTypeDto.setDistance(nodeTypePo.getDistance());
                nodeTypeDto.setDocTypeFLag("0");
                nodeTypeDto.setFormat("folder");
                nodeTypeDto = this.getNodeFoldTypeChildren(nodeTypeDto);
                nodeTypeDto.setEnabled(Integer.valueOf(0));
                nodeTypeDtoList.add(nodeTypeDto);
            }
        }
        return nodeTypeDtoList;
    }

    public List<NodeTypePo> queryDirectTypeNodeTree(String pid) {
        String localPid = this.getPid(pid);
        List<NodeTypePo> nodePos = this.nodeTypeRelevancyMapper.queryNode(localPid);
        ArrayList<NodeTypePo> nodePoList = new ArrayList<NodeTypePo>();
        if (nodePos != null && !nodePos.isEmpty()) {
            for (NodeTypePo nodeTypePo : nodePos) {
                nodeTypePo = this.getNodeFoldChildren(nodeTypePo);
                nodePoList.add(nodeTypePo);
            }
        }
        return nodePoList;
    }

    private String getPid(String pid) {
        if (StringUtils.isEmpty((Object)pid)) {
            pid = "111";
        }
        return pid;
    }

    public List<NodeTypeDto> queryTypeNode(String pid) {
        String localPid = this.getPid(pid);
        List<NodeTypePo> nodePos = this.nodeTypeRelevancyMapper.queryNode(localPid);
        ArrayList<NodeTypeDto> nodeTypeDtoList = new ArrayList<NodeTypeDto>();
        for (NodeTypePo nodeTypePo : nodePos) {
            List<NodeTypeDto> childNodeTypeDtos = this.nodeTypeRelevancyMapper.queryDocTypeAndNode(nodeTypePo.getId().toString());
            if (childNodeTypeDtos.isEmpty()) continue;
            for (NodeTypeDto nodeTypeDto : childNodeTypeDtos) {
                if (!"1".equals(nodeTypeDto.getDocTypeFLag())) continue;
                nodeTypeDtoList.add(nodeTypeDto);
            }
        }
        return nodeTypeDtoList;
    }

    public List<NodeTypePo> queryNodeIdByPid(List<NodeTypePo> nodePoList, String pid) {
        List<NodeTypePo> nodePos = this.nodeTypeRelevancyMapper.queryNode(pid);
        if (!nodePos.isEmpty()) {
            for (NodeTypePo nodeTypePo : nodePos) {
                nodePoList.add(nodeTypePo);
                this.queryNodeIdByPid(nodePoList, String.valueOf(nodeTypePo.getId()));
            }
        }
        return nodePoList;
    }

    public NodeTypePo getNodeFoldChildren(NodeTypePo nodeTypePo) {
        List<NodeTypePo> childNodePos = this.nodeTypeRelevancyMapper.queryNode(nodeTypePo.getId().toString());
        if (!childNodePos.isEmpty()) {
            nodeTypePo.setChildrenNode(childNodePos);
            for (NodeTypePo nodeTypePoNext : childNodePos) {
                this.getNodeFoldChildren(nodeTypePoNext);
            }
        }
        return nodeTypePo;
    }

    public NodeTypeDto getNodeFoldTypeChildren(NodeTypeDto nodeTypeDto) {
        if ("1".equals(nodeTypeDto.getDocTypeFLag())) {
            return nodeTypeDto;
        }
        List<NodeTypeDto> childNodeTypeDtos = this.nodeTypeRelevancyMapper.queryDocTypeAndNode(nodeTypeDto.getId().toString());
        if (!childNodeTypeDtos.isEmpty()) {
            for (NodeTypeDto neDto : childNodeTypeDtos) {
                neDto.setEnabled(Integer.valueOf(0));
            }
            nodeTypeDto.setChildrenNode(childNodeTypeDtos);
            for (NodeTypeDto nodeTypeDtoNext : childNodeTypeDtos) {
                this.getNodeFoldTypeChildren(nodeTypeDtoNext);
            }
        }
        return nodeTypeDto;
    }
}

