/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.dm.server.mapper.NodeRelevancyMapper;
import com.jxdinfo.idp.dm.server.util.DocUtil;
import com.jxdinfo.idp.dto.NodeDto;
import com.jxdinfo.idp.interf.NodeRelevancyService;
import com.jxdinfo.idp.po.NodeRelevancyPo;
import com.jxdinfo.idp.vo.NodeVo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NodeRelevancyServiceImpl
extends ServiceImpl<NodeRelevancyMapper, NodeRelevancyPo>
implements NodeRelevancyService {
    @Resource
    private NodeRelevancyMapper nodeRelevancyMapper;

    public List<NodeVo> queryNode(Long pid) {
        DocUtil.checkNodeRoot(pid);
        List<NodeVo> allNodeFold = this.nodeRelevancyMapper.queryNodeVo();
        ArrayList<NodeVo> firstNodeFold = new ArrayList<NodeVo>();
        ArrayList<NodeVo> resultNodeFold = new ArrayList<NodeVo>();
        NodeVo nodeRoot = null;
        for (NodeVo nodeVo : allNodeFold) {
            if (nodeVo.getId() == 1L) {
                nodeRoot = new NodeVo(nodeVo);
            }
            if (nodeVo.getPid() != 1L || nodeVo.getDistance() != 1) continue;
            firstNodeFold.add(nodeVo);
        }
        List<NodeVo> nodeFoldChildrenVo = this.getNodeFoldChildrenVo(firstNodeFold, allNodeFold);
        nodeRoot.setChildrenNode(nodeFoldChildrenVo);
        resultNodeFold.add(nodeRoot);
        return resultNodeFold;
    }

    private List<NodeVo> getNodeFoldChildrenVo(List<NodeVo> firstNodeList, List<NodeVo> allNodeFold) {
        for (NodeVo nodeChild : firstNodeList) {
            ArrayList<NodeVo> nodeVoChild = new ArrayList<NodeVo>();
            Long cid = nodeChild.getCid();
            for (NodeVo nodeFold : allNodeFold) {
                if (!nodeFold.getPid().equals(cid) || nodeFold.getDistance() != 1) continue;
                nodeVoChild.add(nodeFold);
            }
            nodeChild.setChildrenNode(nodeVoChild);
            this.getNodeFoldChildrenVo(nodeVoChild, allNodeFold);
        }
        return firstNodeList;
    }

    public List<NodeVo> queryNodeIdByPid(Long pid) {
        return this.nodeRelevancyMapper.queryNode(pid);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<NodeRelevancyPo> insertNode(NodeDto nodeDto) {
        if (nodeDto.getPid() == null) {
            return null;
        }
        ArrayList<NodeRelevancyPo> nodeRelevancyPoArrayList = new ArrayList<NodeRelevancyPo>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(NodeRelevancyPo::getCid, (Object)nodeDto.getPid());
        List list = this.list((Wrapper)queryWrapper);
        for (NodeRelevancyPo nodeRelevancyPo : list) {
            nodeRelevancyPoArrayList.add(new NodeRelevancyPo(nodeRelevancyPo.getPid(), nodeDto.getId(), nodeRelevancyPo.getDistance() + 1));
        }
        nodeRelevancyPoArrayList.add(new NodeRelevancyPo(nodeDto.getId(), nodeDto.getId(), 0));
        return nodeRelevancyPoArrayList;
    }

    public List<NodeRelevancyPo> getRelevancyByNodeDto(NodeDto nodeDto) {
        return null;
    }
}

