/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.idp.common.enums.doc.AcceptFileType;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.file.FileUtil;
import com.jxdinfo.idp.common.util.file.LibreOfficePDFConvert;
import com.jxdinfo.idp.dm.server.enums.DocFormatEnum;
import com.jxdinfo.idp.dm.server.mapper.NodeFoldMapper;
import com.jxdinfo.idp.dto.DocInfoDto;
import com.jxdinfo.idp.dto.NodeDto;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.interf.FileSystemInterface;
import com.jxdinfo.idp.interf.NodeFoldService;
import com.jxdinfo.idp.interf.NodeRelevancyService;
import com.jxdinfo.idp.po.DocFilePo;
import com.jxdinfo.idp.po.FileInfoPo;
import com.jxdinfo.idp.po.NodePo;
import com.jxdinfo.idp.po.NodeRelevancyPo;
import com.jxdinfo.idp.vo.DocInfoVo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.PostConstruct;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jodconverter.office.OfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DocUtil {
    private static final Logger log = LoggerFactory.getLogger(DocUtil.class);
    @Autowired
    private FileSystemInterface fileSystemInterfaces;
    @Autowired
    private NodeRelevancyService nodeRelevancyServices;
    @Autowired
    private NodeFoldService nodeFoldServices;
    @Autowired
    private NodeFoldMapper nodeFoldMappers;
    @Autowired
    private DocService docServices;
    @Value(value="${docbase.pdfPath}")
    private String pdfPaths;
    @Value(value="${docbase.savePath}")
    private String savePaths;
    @Value(value="${docbase.initFold}")
    private String initFolds;
    @Value(value="${docbase.initFoldName}")
    private String initFoldNames;
    private static FileSystemInterface fileSystemInterface;
    private static NodeRelevancyService nodeRelevancyService;
    private static NodeFoldService nodeFoldService;
    private static NodeFoldMapper nodeFoldMapper;
    private static DocService docService;
    private static String pdfPath;
    private static String savePath;
    private static String initFold;
    private static String initFoldName;

    @PostConstruct
    public void staticInit() {
        fileSystemInterface = this.fileSystemInterfaces;
        nodeRelevancyService = this.nodeRelevancyServices;
        nodeFoldService = this.nodeFoldServices;
        nodeFoldMapper = this.nodeFoldMappers;
        docService = this.docServices;
        pdfPath = this.pdfPaths;
        savePath = this.savePaths;
        initFold = this.initFolds;
        initFoldName = this.initFoldNames;
        DocUtil.checkNodeRoot(1L);
        DocUtil.checkNodeinitFold();
        log.info("==========\u521d\u59cb\u5316\u6210\u529f===========");
    }

    public static void toPdfThread(Long docId, File docFile, File pdfFile) {
        log.info("==========\u8fdb\u5165\u6587\u4ef6\u8f6c\u6362===========");
        long time1 = System.currentTimeMillis();
        FileInfoPo fileInfoPo = docService.getFileInfoPoWithMapper(docId);
        try {
            if (docFile != null && pdfFile != null) {
                LibreOfficePDFConvert.doDocToFdpLibre((File)docFile, (File)pdfFile);
                fileInfoPo.setDocConvert(Integer.valueOf(0));
            } else {
                fileInfoPo.setDocConvert(Integer.valueOf(1));
            }
        }
        catch (OfficeException e) {
            fileInfoPo.setDocConvert(Integer.valueOf(1));
            log.error("======================pdf\u8f6c\u6362\u5f02\u5e38========================");
            throw new RuntimeException(e);
        }
        finally {
            docService.updateFileInfoWithMapper(fileInfoPo);
            long time2 = System.currentTimeMillis();
            log.info("==========\u6587\u4ef6\u8f6c\u6362\u6210\u529f\uff0c\u8017\u65f6\uff1a" + (time2 - time1) + "\u6beb\u79d2===========");
        }
    }

    public static DocFilePo checkMd5(String md5) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"md5", (Object)md5);
        List list = fileSystemInterface.list((Wrapper)queryWrapper);
        if (list != null && !list.isEmpty()) {
            return (DocFilePo)list.get(0);
        }
        return null;
    }

    public static File getPdfPath(String format) {
        format = format.replace(".", "");
        String random = UUID.randomUUID().toString().replace("-", "");
        if (AcceptFileType.XLS.getType().equals(format)) {
            return new File(pdfPath + File.separator + random + ".xlsx");
        }
        if (AcceptFileType.getAcceptFileType((String)format).getConvertFlag().booleanValue()) {
            return new File(pdfPath + File.separator + random + ".pdf");
        }
        return null;
    }

    public static List<NodeDto> buildNodeDtoList(List<NodeDto> nodeDtoList, String foldName, String foldPath, String nodePidPath, int deleteFlag) {
        long nodeId = SnowFlakeUtil.getFlowIdInstance().nextId();
        NodeDto nodeDto = new NodeDto(Long.valueOf(nodeId), foldName, foldPath);
        nodeDto.setNodePath(nodeDto.getPath());
        String fileName = nodeDto.getPath().substring(savePath.length());
        nodeDto.setPath((nodePidPath + "/" + fileName).replace("\\", "/"));
        nodeDto.setDeleteFlag(deleteFlag);
        nodeDtoList.add(nodeDto);
        return nodeDtoList;
    }

    public static List<DocInfoDto> buildDocInfoDtoList(List<DocInfoDto> docInfoDtoList, File file, int deleteFlag) {
        String docFormat = FileUtil.getDocFormat((File)file);
        long docId = SnowFlakeUtil.getFlowIdInstance().nextId();
        DocInfoDto docInfoDto = new DocInfoDto();
        docInfoDto.setId(Long.valueOf(docId));
        docInfoDto.setDocName(FileUtil.getNoSuffixOfFileName((String)file.getName()));
        docInfoDto.setFileSize(file.length());
        docInfoDto.setFilePath(file.getPath());
        docInfoDto.setFormat(docFormat);
        docInfoDto.setMd5(FileUtil.getMD5((String)file.getPath()));
        docInfoDto.setDeleteFlag(Integer.valueOf(deleteFlag));
        File pdfPath1 = DocUtil.getPdfPath(docInfoDto.getFormat());
        if (pdfPath1 == null) {
            docInfoDto.setPdfPath(file.getPath());
            docInfoDto.setIsToPdf(1);
            docInfoDto.setDocConvert(0);
        } else {
            docInfoDto.setPdfPath(pdfPath1.getPath());
            docInfoDto.setDocConvert(2);
        }
        docInfoDto.setFileSize(file.length());
        docInfoDtoList.add(docInfoDto);
        return docInfoDtoList;
    }

    public static void buildNodeAndDoc(List<NodeDto> nodeDtoList, List<DocInfoDto> docInfoDtoList, Map<Long, NodeDto> nodeCidMap) {
        String path;
        int i;
        for (i = 0; i < nodeDtoList.size(); ++i) {
            nodeCidMap.put(nodeDtoList.get(i).getId(), nodeDtoList.get(i));
            path = nodeDtoList.get(i).getPath();
            for (int j = 0; j < nodeDtoList.size(); ++j) {
                String path1 = nodeDtoList.get(j).getPath();
                String chPath = path1.substring(0, path1.lastIndexOf(47));
                if (!path.equals(chPath)) continue;
                nodeDtoList.get(j).setPid(nodeDtoList.get(i).getId());
            }
        }
        for (i = 0; i < docInfoDtoList.size(); ++i) {
            path = docInfoDtoList.get(i).getFilePath();
            String fileNodePath = path.substring(0, path.lastIndexOf(File.separator));
            for (int j = 0; j < nodeDtoList.size(); ++j) {
                String nodePath = nodeDtoList.get(j).getNodePath();
                if (!nodePath.equals(fileNodePath)) continue;
                docInfoDtoList.get(i).setPid(nodeDtoList.get(j).getId());
            }
        }
    }

    public static void checkNodeRoot(Long pid) {
        if ((ObjectUtils.isEmpty((Object)pid) || pid == 1L) && nodeFoldService.getById((Serializable)Long.valueOf(1L)) == null) {
            NodePo nodePo = new NodePo();
            nodePo.setId(Long.valueOf(1L));
            nodePo.setName("\u5168\u90e8\u6587\u4ef6");
            nodePo.setPath("/\u5168\u90e8\u6587\u4ef6");
            nodeFoldService.save((Object)nodePo);
            NodeRelevancyPo nodeRelevancyPo = new NodeRelevancyPo();
            nodeRelevancyPo.setPid(Long.valueOf(1L));
            nodeRelevancyPo.setCid(Long.valueOf(1L));
            nodeRelevancyPo.setDistance(0);
            nodeRelevancyService.save((Object)nodeRelevancyPo);
            log.info("============================\u521d\u59cb\u5316\u6839\u76ee\u5f55\u6210\u529finitFold" + nodePo.getId() + "=======================");
        }
    }

    public static void checkNodeinitFold() {
        if (StringUtils.isNotBlank((CharSequence)initFold)) {
            long foldId = Long.parseLong(initFold);
            ArrayList<Long> longs = new ArrayList<Long>();
            longs.add(foldId);
            List<NodePo> nodes = nodeFoldMapper.getNodes(longs, 1);
            if (nodes == null || nodes.isEmpty()) {
                ArrayList<NodeRelevancyPo> nodeRelevancyPos = new ArrayList<NodeRelevancyPo>();
                NodePo nodePo = new NodePo(Long.valueOf(foldId), initFoldName, "/\u5168\u90e8\u6587\u4ef6/" + initFoldName);
                nodePo.setDeleteFlag(Integer.valueOf(1));
                nodeFoldService.save((Object)nodePo);
                nodeRelevancyPos.add(new NodeRelevancyPo(Long.valueOf(foldId), Long.valueOf(foldId), 0));
                nodeRelevancyPos.add(new NodeRelevancyPo(Long.valueOf(1L), Long.valueOf(foldId), 1));
                nodeRelevancyService.saveBatch(nodeRelevancyPos);
                log.info("============================\u521d\u59cb\u5316\u76ee\u5f55\u6210\u529finitFold:" + initFold + "=======================");
            }
        } else {
            log.error("============================\u521d\u59cb\u5316\u76ee\u5f55\u5931\u8d25\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6initFold====================");
        }
    }

    public static boolean checkInitFold(Long foldId) {
        return Long.parseLong(initFold) == foldId;
    }

    public static void buildSortObjectList(Long pid, List<NodeDto> nodeDtoList, List<NodeRelevancyPo> nodeRelevancyVo, List<NodePo> nodeList, List<DocInfoDto> docInfoDtoList, List<FileInfoPo> fileInfoPoList, List<DocFilePo> docFilePoList, List<DocInfoVo> docInfoVos) {
        for (NodeDto nodeDto : nodeDtoList) {
            if (ObjectUtils.isEmpty((Object)nodeDto.getPid())) {
                nodeDto.setPid(pid);
                boolean b = nodeFoldService.checkNodeName(pid, nodeDto.getName());
                if (b) {
                    nodeDto.setName(nodeDto.getName() + "(" + System.currentTimeMillis() + ")");
                }
            }
            NodePo nodePo = new NodePo(nodeDto);
            nodeList.add(nodePo);
            if (nodeRelevancyVo == null) continue;
            nodeRelevancyVo.add(new NodeRelevancyPo(nodeDto));
        }
        for (DocInfoDto docInfoDto : docInfoDtoList) {
            if (ObjectUtils.isEmpty((Object)docInfoDto.getPid())) {
                docInfoDto.setPid(pid);
            }
            fileInfoPoList.add(new FileInfoPo(docInfoDto));
            docFilePoList.add(new DocFilePo(docInfoDto));
            if (docInfoVos == null || !pid.equals(docInfoDto.getPid())) continue;
            docInfoVos.add(new DocInfoVo(docInfoDto));
        }
    }

    public static void copyFileToSavePath(List<DocInfoDto> docInfoDtoList) {
        for (DocInfoDto docInfoDto : docInfoDtoList) {
            String filePath = docInfoDto.getFilePath();
            File file = new File(filePath);
            DocFilePo docFilePo = DocUtil.checkMd5(FileUtil.getMD5((String)file.getPath()));
            if (docFilePo != null) {
                docInfoDto.setFilePath(docFilePo.getFilePath());
                docInfoDto.setPdfPath(docFilePo.getPdfPath());
                docInfoDto.setIsToPdf(1);
                continue;
            }
            String path = savePath + File.separator + FileUtil.createRandomFileName((String)file.getName());
            File saveFile = new File(path);
            String Suffix = FileUtil.getNoPointSuffix((String)file.getName());
            if (!file.exists() || DocFormatEnum.getFormatList().contains(Suffix)) {
                docInfoDto.setIsToPdf(1);
                continue;
            }
            FileUtil.createFilePath((File)saveFile);
            try {
                Files.copy(Paths.get(filePath, new String[0]), Paths.get(path, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                docInfoDto.setFilePath(path);
                if (docInfoDto.getIsToPdf() != 1) continue;
                docInfoDto.setPdfPath(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void unzipFile(String zipFilePath, String savePath, String nodePidPath, List<NodeDto> nodeDtoList, List<DocInfoDto> docInfoDtoList, List<String> zipFoldList, int deleteFlag) throws IOException {
        File destDir = new File(savePath);
        FileUtil.createFoldPath((File)destDir);
        List fileTypeList = AcceptFileType.getFileTypeList();
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(Paths.get(zipFilePath, new String[0]), new OpenOption[0]), Charset.forName("GBK"));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                String fileName = zipEntry.getName();
                File newFile = new File(destDir.getPath() + File.separator + fileName);
                zipFoldList.add(newFile.getPath());
                String suffix = FileUtil.getNoPointSuffix((String)fileName);
                if (zipEntry.isDirectory()) {
                    FileUtil.createFoldPath((File)newFile);
                    DocUtil.buildNodeDtoList(nodeDtoList, newFile.getName(), newFile.getPath(), nodePidPath, deleteFlag);
                } else {
                    FileUtil.createFilePath((File)newFile);
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int length;
                        while ((length = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, length);
                        }
                    }
                    if (DocFormatEnum.ZIP.getFormat().equals(suffix)) {
                        DocUtil.unzipFile(newFile.getPath(), newFile.getParent(), nodePidPath, nodeDtoList, docInfoDtoList, zipFoldList, deleteFlag);
                    } else if (fileTypeList.contains(suffix)) {
                        DocUtil.buildDocInfoDtoList(docInfoDtoList, newFile, deleteFlag);
                    }
                }
                zipEntry = zis.getNextEntry();
            }
        }
    }

    public static void untarFile(String zipFilePath, String savePath, String nodePidPath, List<NodeDto> nodeDtoList, List<DocInfoDto> docInfoDtoList, List<String> zipFoldList, int deleteFlag) throws IOException {
        File destDir = new File(savePath);
        FileUtil.createFoldPath((File)destDir);
        List fileTypeList = AcceptFileType.getFileTypeList();
        byte[] buffer = new byte[1024];
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream(Files.newInputStream(Paths.get(zipFilePath, new String[0]), new OpenOption[0]));){
            TarArchiveEntry tarEntry = tarIn.getNextTarEntry();
            while (tarEntry != null) {
                String fileName = tarEntry.getName();
                File newFile = new File(destDir.getPath() + File.separator + fileName);
                zipFoldList.add(newFile.getPath());
                String substring = FileUtil.getNoPointSuffix((String)fileName);
                if (tarEntry.isDirectory()) {
                    FileUtil.createFoldPath((File)newFile);
                    DocUtil.buildNodeDtoList(nodeDtoList, newFile.getName(), newFile.getPath(), nodePidPath, deleteFlag);
                } else {
                    FileUtil.createFilePath((File)newFile);
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int length;
                        while ((length = tarIn.read(buffer)) > 0) {
                            fos.write(buffer, 0, length);
                        }
                    }
                    if (DocFormatEnum.TAR.getFormat().equals(substring)) {
                        DocUtil.untarFile(newFile.getPath(), newFile.getParent(), nodePidPath, nodeDtoList, docInfoDtoList, zipFoldList, deleteFlag);
                    } else if (fileTypeList.contains(substring)) {
                        DocUtil.buildDocInfoDtoList(docInfoDtoList, newFile, 2);
                    }
                }
                tarEntry = tarIn.getNextTarEntry();
            }
        }
    }

    public static String queryString(String temp) {
        if (temp == null || temp == "") {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(temp.trim());
        StringBuilder tempBuilder = new StringBuilder();
        tempBuilder.append(temp.trim());
        int j = 0;
        for (int i = 0; i < b.length(); ++i) {
            char x = b.charAt(i);
            if (x != '%' && x != '_') continue;
            tempBuilder.insert(i + j, '\\');
            ++j;
        }
        return tempBuilder.toString();
    }

    public static void saveDocAndNode(int isFold, Long pid, Map<Long, NodeDto> nodeCidMap, List<NodePo> nodeList, List<NodeDto> nodeDtoList, List<FileInfoPo> fileInfoPoList, List<DocFilePo> docFilePoList) {
        if (isFold == 1) {
            for (FileInfoPo fileInfoPo : fileInfoPoList) {
                fileInfoPo.setPid(pid);
            }
        } else {
            nodeFoldService.saveBatch(nodeList);
            for (NodeDto nodeDto : nodeDtoList) {
                if (!nodeDto.getPid().equals(pid)) continue;
                nodeRelevancyService.insertNode(nodeDto);
                DocUtil.saveNodeRelevancy(nodeDto.getId(), nodeDtoList, nodeCidMap);
            }
        }
        docService.saveBatch(fileInfoPoList);
        fileSystemInterface.saveBatch(docFilePoList);
    }

    private static void saveNodeRelevancy(Long pid, List<NodeDto> nodeDtoList, Map<Long, NodeDto> nodeCidMap) {
        for (NodeDto nodeDto : nodeDtoList) {
            NodeDto nodeDto1;
            if (!nodeDto.getPid().equals(pid) || (nodeDto1 = nodeCidMap.get(nodeDto.getId())) == null) continue;
            nodeRelevancyService.insertNode(nodeDto1);
            DocUtil.saveNodeRelevancy(nodeDto1.getId(), nodeDtoList, nodeCidMap);
        }
    }

    public static void removeDocAndNode(Long pid) {
        Map foldAndFile = docService.getFoldAndFileOfId(pid);
        List fileIdList = (List)foldAndFile.get("fileIdList");
        List foldeIdList = (List)foldAndFile.get("foldeIdList");
        docService.removeByIds((Collection)fileIdList);
        nodeFoldService.removeByIds((Collection)foldeIdList);
    }
}

