/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.schedule;

import com.jxdinfo.idp.interf.FileSliceUploadService;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TimeTasks {
    private static final Logger log = LoggerFactory.getLogger(TimeTasks.class);
    @Resource
    private FileSliceUploadService fileSliceUploadService;
    @Value(value="${docbase.breakdir}")
    private String breakdir;

    @Scheduled(cron="0 0 12 * * *")
    public void cleanInvalidFile() {
        log.info("=========\u6e05\u9664\u5e9f\u5f03\u6587\u4ef6============");
        long time1 = System.currentTimeMillis();
        this.fileSliceUploadService.cleanUploadedFile(null);
        long time2 = System.currentTimeMillis();
        log.info("\u6e05\u9664\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (time2 - time1) + "\u6beb\u79d2");
    }

    @Scheduled(cron="0 0 12 * * *")
    public void clearDirectory() {
        log.info("=========\u6e05\u7a7a\u4e34\u65f6\u76ee\u5f55============");
        long time1 = System.currentTimeMillis();
        try {
            Path dir = Paths.get(this.breakdir, new String[0]);
            if (Files.exists(dir, new LinkOption[0])) {
                Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long time2 = System.currentTimeMillis();
        log.info("\u6e05\u9664\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (time2 - time1) + "\u6beb\u79d2");
    }
}

