/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.doc.NodeUtil;
import com.jxdinfo.idp.dm.server.mapper.NodeFoldMapper;
import com.jxdinfo.idp.dm.server.mapper.NodeRelevancyMapper;
import com.jxdinfo.idp.dm.server.util.DocUtil;
import com.jxdinfo.idp.dto.NodeDto;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.interf.NodeFoldService;
import com.jxdinfo.idp.interf.NodeRelevancyService;
import com.jxdinfo.idp.po.NodePo;
import com.jxdinfo.idp.vo.NodeVo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NodeFoldServiceImpl
extends ServiceImpl<NodeFoldMapper, NodePo>
implements NodeFoldService {
    @Resource
    private NodeRelevancyService nodeRelevancyService;
    @Resource
    private NodeRelevancyMapper nodeRelevancyMapper;
    @Resource
    private NodeFoldMapper nodeFoldMapper;
    @Resource
    private DocService docService;
    @Value(value="${docbase.initFold}")
    private String initFold;

    public boolean updateNode(NodeDto nodeDto) {
        ArrayList<NodePo> nodePos = new ArrayList<NodePo>();
        NodePo nodePo = (NodePo)NodeUtil.getByIdBaseMapper((BaseMapper)this.nodeFoldMapper, (Long)nodeDto.getId());
        nodePo.setName(nodeDto.getName());
        nodePo.setDescription(nodeDto.getDescription());
        String path = nodePo.getPath();
        int pathLength = path.length();
        int indexOf = path.lastIndexOf(47);
        String nodePath = path.substring(0, indexOf + 1) + nodeDto.getName();
        nodePo.setPath(nodePath);
        nodePos.add(nodePo);
        List nodeVos = this.nodeRelevancyService.queryNodeIdByPid(nodeDto.getId());
        List collect = nodeVos.stream().map(NodeVo::getId).filter(id -> !Objects.equals(id, nodePo.getId())).collect(Collectors.toList());
        if (collect.isEmpty()) {
            NodeUtil.updateNodeBaseMapper((BaseMapper)this.nodeFoldMapper, nodePos);
            return true;
        }
        List nodePos1 = this.listByIds(collect);
        for (NodePo po : nodePos1) {
            po.setPath(nodePath + "/" + po.getPath().substring(pathLength + 1));
            nodePos.add(po);
        }
        NodeUtil.updateNodeBaseMapper((BaseMapper)this.nodeFoldMapper, nodePos);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteNode(Long id) {
        if (DocUtil.checkInitFold(id)) {
            return false;
        }
        Map foldAndFile = this.docService.getFoldAndFileOfId(id);
        List fileIdList = (List)foldAndFile.get("fileIdList");
        List foldeIdList = (List)foldAndFile.get("foldeIdList");
        foldeIdList.add(id);
        this.docService.removeByIds((Collection)fileIdList);
        NodeUtil.deleteNodeBaseMapper((BaseMapper)this.nodeFoldMapper, (List)foldeIdList);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveNode(NodeDto nodeDto) {
        DocUtil.checkNodeRoot(nodeDto.getPid());
        this.checkNodeName(nodeDto.getPid(), nodeDto.getName());
        LocalDateTime now = LocalDateTime.now();
        NodePo nodePo = new NodePo(nodeDto);
        long id = SnowFlakeUtil.getFlowIdInstance().nextId();
        nodePo.setId(Long.valueOf(id));
        nodePo.setCreateTime(now);
        nodePo.setDeleteFlag(Integer.valueOf(0));
        nodeDto.setId(Long.valueOf(id));
        nodeDto.setCreateTime(now);
        List nodeRelevancyPos = this.nodeRelevancyService.insertNode(nodeDto);
        NodeUtil.saveNodeBaseMapper((BaseMapper)this.nodeFoldMapper, (Object)nodePo);
        NodeUtil.saveRelevancyBaseMapper((BaseMapper)this.nodeRelevancyMapper, (List)nodeRelevancyPos);
        return true;
    }

    public boolean checkNodeName(Long pid, String nodeName) {
        int count = this.nodeFoldMapper.getNodeName(pid, nodeName);
        return count > 0;
    }

    public Long getinitFold() {
        return Long.parseLong(this.initFold);
    }

    @Transactional(rollbackFor={Exception.class})
    public void moveNode(List<Long> nodeIdList, Long pid) {
        String pathNew = ((NodePo)NodeUtil.getByIdBaseMapper((BaseMapper)this.nodeFoldMapper, (Long)pid)).getPath();
        ArrayList<NodePo> nodePoAllList = new ArrayList<NodePo>();
        ArrayList<NodeDto> nodeDtoList = new ArrayList<NodeDto>();
        for (Long id : nodeIdList) {
            NodePo nodePo = (NodePo)NodeUtil.getByIdBaseMapper((BaseMapper)this.nodeFoldMapper, (Long)id);
            String path = nodePo.getPath();
            int index = path.lastIndexOf(47) + 1;
            List nodeVos = this.nodeRelevancyService.queryNodeIdByPid(id);
            for (NodeVo nodeVo : nodeVos) {
                nodeVo.setPath(pathNew + "/" + nodeVo.getPath().substring(index));
                nodePoAllList.add(new NodePo(nodeVo));
                if (Objects.equals(nodeVo.getId(), id)) {
                    nodeVo.setPid(pid);
                }
                nodeDtoList.add(new NodeDto(nodeVo));
            }
        }
        NodeUtil.updateNodeBaseMapper((BaseMapper)this.nodeFoldMapper, nodePoAllList);
        List list = this.listByIds(nodeIdList);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"cid", nodeIdList);
        this.nodeRelevancyMapper.delete((Wrapper)queryWrapper);
        for (NodeDto nodeDto : nodeDtoList) {
            List nodeRelevancyPos = this.nodeRelevancyService.insertNode(nodeDto);
            NodeUtil.saveRelevancyBaseMapper((BaseMapper)this.nodeRelevancyMapper, (List)nodeRelevancyPos);
        }
    }
}

