/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.enums.doc.AcceptFileType;
import com.jxdinfo.idp.common.util.doc.FileUtil;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.dm.server.enums.DocFormatEnum;
import com.jxdinfo.idp.dm.server.enums.ExtractWay;
import com.jxdinfo.idp.dm.server.mapper.DocExtractMapper;
import com.jxdinfo.idp.dm.server.schedule.ThreadPoolToPdf;
import com.jxdinfo.idp.dm.server.util.DocUtil;
import com.jxdinfo.idp.dto.DocExtractDto;
import com.jxdinfo.idp.dto.DocInfoDto;
import com.jxdinfo.idp.dto.NodeDto;
import com.jxdinfo.idp.interf.DocExtractService;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.interf.FileSystemInterface;
import com.jxdinfo.idp.interf.NodeFoldService;
import com.jxdinfo.idp.po.DocExtractPo;
import com.jxdinfo.idp.po.DocFilePo;
import com.jxdinfo.idp.po.FileInfoPo;
import com.jxdinfo.idp.po.NodePo;
import com.jxdinfo.idp.vo.ExtractVo;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DocExtractServiceImpl
extends ServiceImpl<DocExtractMapper, DocExtractPo>
implements DocExtractService {
    private static final Logger log = LoggerFactory.getLogger(DocExtractServiceImpl.class);
    @Resource
    private DocService docService;
    @Resource
    private FileSystemInterface fileSystemInterface;
    @Resource
    private DocExtractMapper docExtractMapper;
    @Resource
    private DocInfoIoService docInfoIoService;
    @Resource
    private NodeFoldService nodeFoldService;
    @Value(value="${docbase.savePath}")
    private String savePath;

    public List<ExtractVo> getExtractWay() {
        return ExtractWay.getExtractWay();
    }

    public boolean saveDocExtract(DocExtractPo docExtractPo) {
        LocalDateTime now = LocalDateTime.now();
        docExtractPo.setCreateTime(now);
        return this.save(docExtractPo);
    }

    public boolean deleteBacthById(List<Long> id) {
        return this.removeByIds(id);
    }

    public boolean updateDocExtract(DocExtractDto docExtractDto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id", (Object)docExtractDto.getId());
        DocExtractPo docExtractPo = (DocExtractPo)this.getOne((Wrapper)queryWrapper);
        docExtractPo.getDocInfoDto(docExtractDto);
        return this.updateById(docExtractPo);
    }

    public Map<String, Object> getDocExtractList(DocExtractDto docExtractDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        QueryWrapper queryWrapper = new QueryWrapper();
        Page page = new Page((long)docExtractDto.getCurrent(), (long)docExtractDto.getSize());
        if (StringUtils.isNotBlank((CharSequence)docExtractDto.getTaskName())) {
            queryWrapper.like((Object)"task_name", (Object)docExtractDto.getTaskName());
        }
        if (docExtractDto.getExecutWay() != null) {
            queryWrapper.eq((Object)"execut_way", (Object)docExtractDto.getExecutWay());
        }
        this.page((IPage)page, (Wrapper)queryWrapper);
        long count = this.count((Wrapper)queryWrapper);
        map.put("data", page.getRecords());
        map.put("total", count);
        return map;
    }

    public DocExtractPo getDocExtract(String id) {
        return this.docExtractMapper.getDocExtractPo(id);
    }

    public boolean docExtractHandle(DocExtractPo docExtractPo) throws IOException {
        int isStru = docExtractPo.getIsStru();
        Long pid = docExtractPo.getPid();
        String importPath = docExtractPo.getImportPath();
        String synWay = docExtractPo.getSynWay();
        int synWayCode = this.handleSynWay(synWay);
        String importWay = docExtractPo.getImportWay();
        File dir = new File(importPath);
        if (!dir.exists()) {
            log.error("Could not find directory: " + importPath);
            return false;
        }
        Object[] files = dir.listFiles();
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            this.chooseHandleSynWay(synWayCode, isStru, (File[])files, pid);
        }
        return true;
    }

    private void chooseHandleSynWay(int synWayCode, int isStru, File[] files, Long pid) throws IOException {
        String nodePidPath = ((NodePo)this.nodeFoldService.getById((Serializable)pid)).getPath();
        ArrayList<NodeDto> nodeDtoList = new ArrayList<NodeDto>();
        ArrayList<DocInfoDto> docInfoDtoList = new ArrayList<DocInfoDto>();
        HashMap<Long, NodeDto> nodeCidMap = new HashMap<Long, NodeDto>();
        ArrayList<NodePo> nodeList = new ArrayList<NodePo>();
        ArrayList<FileInfoPo> fileInfoPoList = new ArrayList<FileInfoPo>();
        ArrayList<DocFilePo> docFilePoList = new ArrayList<DocFilePo>();
        ArrayList<String> zipFoldList = new ArrayList<String>();
        if (synWayCode == 0) {
            this.synDocAndNode(isStru, files, pid, nodePidPath, nodeCidMap, nodeDtoList, docInfoDtoList, nodeList, fileInfoPoList, docFilePoList, zipFoldList);
        } else if (synWayCode == 1) {
            DocUtil.removeDocAndNode(pid);
            this.synDocAndNode(isStru, files, pid, nodePidPath, nodeCidMap, nodeDtoList, docInfoDtoList, nodeList, fileInfoPoList, docFilePoList, zipFoldList);
        } else if (synWayCode == 2) {
            DocUtil.removeDocAndNode(pid);
        }
        FileUtil.deleteDirectoryBatch(zipFoldList);
    }

    private void synDocAndNode(int isStru, File[] files, Long pid, String nodePidPath, Map<Long, NodeDto> nodeCidMap, List<NodeDto> nodeDtoList, List<DocInfoDto> docInfoDtoList, List<NodePo> nodeList, List<FileInfoPo> fileInfoPoList, List<DocFilePo> docFilePoList, List<String> zipFoldList) throws IOException {
        this.synDocAdd(files, pid, nodePidPath, nodeDtoList, docInfoDtoList, zipFoldList);
        DocUtil.buildNodeAndDoc(nodeDtoList, docInfoDtoList, nodeCidMap);
        DocUtil.copyFileToSavePath(docInfoDtoList);
        DocUtil.buildSortObjectList(pid, nodeDtoList, null, nodeList, docInfoDtoList, fileInfoPoList, docFilePoList, null);
        DocUtil.saveDocAndNode(isStru, pid, nodeCidMap, nodeList, nodeDtoList, fileInfoPoList, docFilePoList);
        ThreadPoolToPdf.ThreadPool(docInfoDtoList);
    }

    private void synDocAdd(File[] files, Long pid, String nodePidPath, List<NodeDto> nodeDtoList, List<DocInfoDto> docInfoDtoList, List<String> zipFoldList) throws IOException {
        List fileTypeList = AcceptFileType.getFileTypeList();
        for (File file : files) {
            if (file.isDirectory()) {
                DocUtil.buildNodeDtoList(nodeDtoList, file.getName(), file.getPath(), nodePidPath, 0);
                Object[] subFiles = file.listFiles();
                if (!ArrayUtils.isNotEmpty((Object[])subFiles)) continue;
                assert (subFiles != null);
                this.synDocAdd((File[])subFiles, pid, nodePidPath, nodeDtoList, docInfoDtoList, zipFoldList);
                continue;
            }
            if (fileTypeList.contains(FileUtil.getNoPointSuffix((String)file.getName()))) {
                DocUtil.buildDocInfoDtoList(docInfoDtoList, file, 0);
                continue;
            }
            if (DocFormatEnum.ZIP.getFormat().equals(FileUtil.getNoPointSuffix((String)file.getName()))) {
                DocUtil.unzipFile(file.getPath(), file.getParent(), nodePidPath, nodeDtoList, docInfoDtoList, zipFoldList, 0);
                continue;
            }
            if (!DocFormatEnum.TAR.getFormat().equals(FileUtil.getNoPointSuffix((String)file.getName()))) continue;
            DocUtil.unzipFile(file.getPath(), file.getParent(), nodePidPath, nodeDtoList, docInfoDtoList, zipFoldList, 0);
        }
    }

    private int handleSynWay(String synWay) {
        Object[] split = synWay.split(",");
        Arrays.sort(split);
        Object[] synWay1 = new String[]{"0"};
        Object[] synWay2 = new String[]{"1"};
        Object[] synWay3 = new String[]{"2"};
        Object[] synWay4 = new String[]{"0", "1"};
        Object[] synWay5 = new String[]{"0", "2"};
        Object[] synWay6 = new String[]{"1", "2"};
        Object[] synWay7 = new String[]{"0", "1", "2"};
        if (Arrays.equals(split, synWay1)) {
            return 0;
        }
        if (Arrays.equals(split, synWay2)) {
            return 1;
        }
        if (Arrays.equals(split, synWay3)) {
            return 2;
        }
        if (Arrays.equals(split, synWay4)) {
            return 1;
        }
        if (Arrays.equals(split, synWay5)) {
            return 1;
        }
        if (Arrays.equals(split, synWay6)) {
            return 1;
        }
        if (Arrays.equals(split, synWay7)) {
            return 1;
        }
        return 5;
    }
}

