/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.util;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.vo.DocInfoVo;
import java.io.File;
import java.util.Base64;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class UniverServiceUtil {
    private static final Logger log = LoggerFactory.getLogger(UniverServiceUtil.class);
    private static DocService docService = (DocService)SpringContextHolder.getBean(DocService.class);
    private static Environment environment = (Environment)SpringContextHolder.getBean(Environment.class);
    private static String univerapi = environment.getProperty("docbase.univerapi");

    private static String upload(Long id) {
        DocInfoVo docInfo = docService.getDocInfo(String.valueOf(id));
        String filePath = docInfo.getFilePath();
        File file = new File(filePath);
        HttpRequest request = HttpRequest.post((String)(univerapi + "/universer-api/stream/file/upload?size=" + file.length() + "&flate=" + false));
        request.form("file", file);
        HttpResponse response = request.execute();
        JSONObject jsonObject = new JSONObject(response.body());
        System.out.println("jsonObject:" + jsonObject);
        return jsonObject.get("FileId").toString();
    }

    private static String importFile(String fileID) {
        HttpRequest request = HttpRequest.post((String)(univerapi + "/universer-api/exchange/2/import"));
        request.form("outputType", (Object)2);
        request.form("fileID", (Object)fileID);
        HttpResponse response = request.execute();
        JSONObject jsonObject = new JSONObject(response.body());
        String taskId = jsonObject.get("taskID").toString();
        return taskId;
    }

    private static String exchange(String taskID) {
        boolean isOk = true;
        String jsonID = "";
        while (isOk) {
            try {
                Thread.sleep(1000L);
                HttpRequest request = HttpRequest.get((String)(univerapi + "/universer-api/exchange/task/" + taskID));
                HttpResponse response = request.execute();
                String body = response.body();
                JSONObject jsonObject = new JSONObject(response.body());
                String status = jsonObject.get("status").toString();
                if ("done".equals(status)) {
                    jsonID = jsonObject.getJSONObject("import").get("jsonID").toString();
                    log.info("=========================univer\u670d\u52a1\u8f6c\u6362\u5b8c\u6210==============================");
                    isOk = false;
                    continue;
                }
                if ("failed".equals(status)) {
                    log.info("=========================univer\u670d\u52a1\u8f6c\u6362\u5931\u8d25==============================");
                    isOk = false;
                    continue;
                }
                log.info("=========================univer\u670d\u52a1\u8f6c\u6362\u4e2d==============================");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return jsonID;
    }

    private static String signUrl(String jsonID) {
        HttpRequest request = HttpRequest.get((String)(univerapi + "/universer-api/file/" + jsonID + "/sign-url"));
        HttpResponse response = request.execute();
        JSONObject jsonObject = new JSONObject(response.body());
        String url = jsonObject.get("url").toString();
        return url;
    }

    private static String getJson(String url) {
        String json = null;
        try {
            url = url.replace("192.168.29.131:19000", "192.168.14.59:19000");
            HttpRequest request = HttpRequest.get((String)url);
            HttpResponse response = request.execute();
            System.out.println("response:" + response.body());
            JSONObject jsonObject = new JSONObject(response.body());
            json = response.body();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return json;
    }

    public static String getDocJson(Long id) {
        String fileID = UniverServiceUtil.upload(id);
        String taskID = UniverServiceUtil.importFile(fileID);
        String jsonID = UniverServiceUtil.exchange(taskID);
        if ("".equals(jsonID)) {
            return "";
        }
        String url = UniverServiceUtil.signUrl(jsonID);
        System.out.println("url:" + url);
        String json = UniverServiceUtil.getJson(url);
        return json;
    }

    public static void decodeEyPrefixedValues(JSONObject jsonObject) {
        jsonObject.keySet().forEach(key -> {
            Object value = jsonObject.get(key);
            if (value instanceof String && ((String)value).startsWith("ey")) {
                try {
                    byte[] decodedBytes = Base64.getDecoder().decode((String)value);
                    String decodedValue = new String(decodedBytes);
                    jsonObject.put(key, (Object)decodedValue);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Invalid Base64 encoding for key: " + key);
                }
            } else if (value instanceof JSONObject) {
                UniverServiceUtil.decodeEyPrefixedValues((JSONObject)value);
            } else if (value instanceof JSONArray) {
                log.info("=========================JSONArray=========================");
            }
        });
    }
}

