/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dm.server.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.dm.server.mapper.NodeFoldMapper;
import com.jxdinfo.idp.dm.server.util.DocUtil;
import com.jxdinfo.idp.dto.NodeDto;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.interf.NodeFoldService;
import com.jxdinfo.idp.interf.NodeRelevancyService;
import com.jxdinfo.idp.po.NodePo;
import com.jxdinfo.idp.vo.NodeVo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NodeFoldServiceImpl
extends ServiceImpl<NodeFoldMapper, NodePo>
implements NodeFoldService {
    @Resource
    private NodeRelevancyService nodeRelevancyService;
    @Resource
    private NodeFoldMapper nodeFoldMapper;
    @Resource
    private DocService docService;
    @Value(value="${docbase.initFold}")
    private String initFold;

    public boolean updateNode(NodeDto nodeDto) {
        ArrayList<NodePo> nodePos = new ArrayList<NodePo>();
        NodePo nodePo = (NodePo)this.getById(nodeDto.getId());
        nodePo.setName(nodeDto.getName());
        nodePo.setDescription(nodeDto.getDescription());
        String path = nodePo.getPath();
        int pathLength = path.length();
        int indexOf = path.lastIndexOf(47);
        String nodePath = path.substring(0, indexOf + 1) + nodeDto.getName();
        nodePo.setPath(nodePath);
        nodePos.add(nodePo);
        List nodeVos = this.nodeRelevancyService.queryNodeIdByPid(nodeDto.getId());
        List collect = nodeVos.stream().map(NodeVo::getId).filter(id -> !Objects.equals(id, nodePo.getId())).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return this.updateBatchById(nodePos);
        }
        List nodePos1 = this.listByIds(collect);
        for (NodePo po : nodePos1) {
            po.setPath(nodePath + "/" + po.getPath().substring(pathLength + 1));
            nodePos.add(po);
        }
        return this.updateBatchById(nodePos);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteNode(Long id) {
        if (DocUtil.checkInitFold(id)) {
            return false;
        }
        Map foldAndFile = this.docService.getFoldAndFileOfId(id);
        List fileIdList = (List)foldAndFile.get("fileIdList");
        List foldeIdList = (List)foldAndFile.get("foldeIdList");
        foldeIdList.add(id);
        this.docService.removeByIds((Collection)fileIdList);
        return this.removeByIds(foldeIdList);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveNode(NodeDto nodeDto) {
        DocUtil.checkNodeRoot(nodeDto.getPid());
        this.checkNodeName(nodeDto.getPid(), nodeDto.getName());
        LocalDateTime now = LocalDateTime.now();
        NodePo nodePo = new NodePo(nodeDto);
        nodePo.setCreateTime(now);
        nodePo.setDeleteFlag(Integer.valueOf(0));
        this.save(nodePo);
        nodeDto.setId(nodePo.getId());
        nodeDto.setCreateTime(now);
        this.nodeRelevancyService.insertNode(nodeDto);
        return true;
    }

    public boolean checkNodeName(Long pid, String nodeName) {
        int count = this.nodeFoldMapper.getNodeName(pid, nodeName);
        return count > 0;
    }

    public Long getinitFold() {
        return Long.parseLong(this.initFold);
    }
}

