/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dio.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class MergeDocumentUtil {
    public static void mergeWord(List<File> inputFiles, File outputFile) {
        try (XWPFDocument doc = new XWPFDocument();
             FileOutputStream out = new FileOutputStream(outputFile);){
            for (File file : inputFiles) {
                FileInputStream fis = new FileInputStream(file);
                XWPFDocument tempDoc = new XWPFDocument((InputStream)fis);
                for (XWPFParagraph p : tempDoc.getParagraphs()) {
                    XWPFParagraph newParagraph = doc.createParagraph();
                    newParagraph.createRun().setText(p.getText());
                }
                for (XWPFTable table : tempDoc.getTables()) {
                    XWPFTable newTable = doc.createTable(table.getNumberOfRows(), table.getRow(0).getTableCells().size());
                    for (int r = 0; r < table.getNumberOfRows(); ++r) {
                        XWPFTableRow newRow = newTable.getRow(r);
                        if (newRow == null) {
                            newRow = newTable.createRow();
                        }
                        for (int c = 0; c < table.getRow(r).getTableCells().size(); ++c) {
                            XWPFTableCell newCell = newRow.getCell(c);
                            if (newCell == null) {
                                newCell = newRow.createCell();
                            }
                            XWPFParagraph para = !newCell.getParagraphs().isEmpty() ? (XWPFParagraph)newCell.getParagraphs().get(0) : newCell.getXWPFDocument().createParagraph();
                            for (XWPFRun run : ((XWPFParagraph)table.getRow(r).getCell(c).getParagraphs().get(0)).getRuns()) {
                                para.createRun().setText(run.getText(0));
                            }
                        }
                    }
                }
                fis.close();
                tempDoc.close();
            }
            doc.write((OutputStream)out);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void mergeExcel(List<File> inputFiles, File outputFile) {
        try (XSSFWorkbook outputWorkbook = new XSSFWorkbook();
             FileOutputStream fileOut = new FileOutputStream(outputFile);){
            for (File file : inputFiles) {
                FileInputStream fis = new FileInputStream(file);
                Workbook workbook = WorkbookFactory.create((InputStream)fis);
                int sheetIndex = 0;
                for (Sheet sheet : workbook) {
                    Sheet newSheet = outputWorkbook.createSheet(workbook.getSheetName(sheetIndex) + "_" + (inputFiles.size() > 1 ? file.getName().split("\\.")[0] : ""));
                    for (Row row : sheet) {
                        Row newRow = newSheet.createRow(row.getRowNum());
                        block31: for (Cell cell : row) {
                            Cell newCell = newRow.createCell(cell.getColumnIndex(), cell.getCellType());
                            switch (cell.getCellType()) {
                                case STRING: {
                                    newCell.setCellValue(cell.getStringCellValue());
                                    continue block31;
                                }
                                case NUMERIC: {
                                    newCell.setCellValue(cell.getNumericCellValue());
                                    continue block31;
                                }
                                case BOOLEAN: {
                                    newCell.setCellValue(cell.getBooleanCellValue());
                                    continue block31;
                                }
                                case FORMULA: {
                                    newCell.setCellFormula(cell.getCellFormula());
                                    continue block31;
                                }
                                case BLANK: {
                                    newCell.setBlank();
                                    continue block31;
                                }
                            }
                            throw new IllegalStateException("Unexpected value: " + cell.getCellType());
                        }
                    }
                    ++sheetIndex;
                }
                fis.close();
                workbook.close();
            }
            outputWorkbook.write((OutputStream)fileOut);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void mergePdf(List<File> inputFiles, File outputFile) {
        try {
            PDFMergerUtility merger = new PDFMergerUtility();
            merger.setDestinationFileName(outputFile.getAbsolutePath());
            for (File sourceFile : inputFiles) {
                merger.addSource(sourceFile);
            }
            merger.mergeDocuments(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

