/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.dio.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.enums.doc.AcceptFileType;
import com.jxdinfo.idp.common.enums.doc.DocTypeEnum;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.util.file.FileUtil;
import com.jxdinfo.idp.common.util.file.LibreOfficePDFConvert;
import com.jxdinfo.idp.dio.mapper.DocInfoIoMapper;
import com.jxdinfo.idp.dio.model.po.DocFilePo;
import com.jxdinfo.idp.dio.model.po.DocInfoPo;
import com.jxdinfo.idp.dio.service.DocFileIoService;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.dio.util.MergeDocumentUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.jodconverter.office.OfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class DocInfoIoServiceImpl
extends ServiceImpl<DocInfoIoMapper, DocInfoPo>
implements DocInfoIoService {
    private static final Logger log = LoggerFactory.getLogger(DocInfoIoServiceImpl.class);
    @Resource
    private DocFileIoService docFileIoService;
    @Value(value="${docbase.savePath}")
    private String savePath;
    @Value(value="${docbase.breakdir}")
    private String breakdir;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveDocInfo(DocInfoPo docInfoPo, DocFilePo docFilePo) {
        this.docFileIoService.save(docFilePo);
        return this.save((Object)docInfoPo);
    }

    @Override
    public JSONObject getFileStream(String docId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)10001);
        jsonObject.put("msg", (Object)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        DocInfoPo docInfoPo = (DocInfoPo)((Object)this.getById((Serializable)((Object)docId)));
        DocFilePo docFilePo = (DocFilePo)this.docFileIoService.getById((Serializable)((Object)docId));
        if (ObjectUtils.isEmpty((Object)((Object)docInfoPo)) || ObjectUtils.isEmpty((Object)docFilePo)) {
            return jsonObject;
        }
        File file = new File(docFilePo.getFilePath());
        if (!file.exists()) {
            return jsonObject;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] buffer = new byte[fileInputStream.available()];
            fileInputStream.read(buffer);
            jsonObject.put("code", (Object)10000);
            jsonObject.put("fileStream", (Object)buffer);
            jsonObject.put("docName", (Object)docInfoPo.getName());
            jsonObject.put("format", (Object)docInfoPo.getFormat());
            jsonObject.put("msg", (Object)"\u6587\u4ef6\u4fe1\u606f\u6d41\u83b7\u53d6\u6210\u529f");
        }
        catch (IOException e) {
            throw new BusinessException("\u83b7\u53d6" + docInfoPo.getName() + "\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
        }
        return jsonObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileBytesInfo getFileBytesInfo(Long docId) {
        DocInfoPo docInfoPo = (DocInfoPo)((Object)this.getById(docId));
        DocFilePo docFilePo = (DocFilePo)this.docFileIoService.getById(docId);
        File file = new File(docFilePo.getFilePath());
        if (!file.exists()) {
            throw new BusinessException("\u6587\u4ef6\u3010" + docInfoPo.getName() + "\u3011\u4e0d\u5b58\u5728");
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] bytes = new byte[fileInputStream.available()];
            fileInputStream.read(bytes);
            FileBytesInfo fileBytesInfo = new FileBytesInfo(bytes, docInfoPo.getFormat(), docFilePo.getFileName());
            return fileBytesInfo;
        }
        catch (IOException e) {
            throw new BusinessException("\u83b7\u53d6" + docInfoPo.getName() + "\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public JSONObject mergeFileStream(Map<String, Object> requestMap) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)10001);
        jsonObject.put("msg", (Object)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        List docIds = (List)requestMap.get("docIds");
        String docType = (String)requestMap.get("format");
        ArrayList<File> fileList = new ArrayList<File>();
        List docInfoPos = this.listByIds(docIds);
        for (DocInfoPo docInfoPo : docInfoPos) {
            DocFilePo docFilePo = (DocFilePo)this.docFileIoService.getById(docInfoPo.getId());
            File fileConvert = this.fileConvert(docInfoPo.getFormat(), docFilePo);
            fileList.add(fileConvert);
        }
        String random = UUID.randomUUID().toString().replace("-", "");
        File newFile = null;
        if (DocTypeEnum.WORD.getValue().equals(docType)) {
            newFile = new File(this.savePath + File.separator + random + ".docx");
            FileUtil.createFilePath((File)newFile);
            MergeDocumentUtil.mergeWord(fileList, newFile);
        } else if (DocTypeEnum.EXCEL.getValue().equals(docType)) {
            newFile = new File(this.savePath + File.separator + random + ".xlsx");
            FileUtil.createFilePath((File)newFile);
            MergeDocumentUtil.mergeExcel(fileList, newFile);
        } else if (DocTypeEnum.PDF.getValue().equals(docType) || DocTypeEnum.WPS.getValue().equals(docType)) {
            newFile = new File(this.savePath + File.separator + random + ".pdf");
            FileUtil.createFilePath((File)newFile);
            MergeDocumentUtil.mergePdf(fileList, newFile);
        }
        try (FileInputStream fileInputStream = new FileInputStream(newFile);){
            byte[] buffer = new byte[fileInputStream.available()];
            fileInputStream.read(buffer);
            jsonObject.put("mergeFileStream", (Object)buffer);
        }
        catch (IOException e) {
            throw new BusinessException("\u83b7\u53d6" + newFile.getName() + "\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
        }
        jsonObject.put("code", (Object)10000);
        jsonObject.put("filePath", (Object)newFile.getPath());
        jsonObject.put("fileName", (Object)newFile.getName());
        jsonObject.put("format", (Object)FileUtil.getNoPointSuffix((String)newFile.getName()));
        jsonObject.put("msg", (Object)"\u6587\u4ef6\u5408\u5e76\u6210\u529f");
        log.info(newFile.getName() + "\u6587\u4ef6\u5408\u5e76\u6210\u529f");
        return jsonObject;
    }

    @Override
    public boolean removeByDocIds(List<Long> docIds) {
        return false;
    }

    private File fileConvert(String format, DocFilePo docFilePo) {
        File convertFile = new File(docFilePo.getFilePath());
        File outFile = null;
        String random = UUID.randomUUID().toString().replace("-", "");
        if (!AcceptFileType.DOC.getType().equals(format)) {
            if (AcceptFileType.XLS.getType().equals(format) || AcceptFileType.WPS.getType().equals(format)) {
                return new File(docFilePo.getPdfPath());
            }
            return convertFile;
        }
        outFile = new File(this.breakdir + File.separator + random + ".docx");
        FileUtil.createFilePath((File)outFile);
        try {
            convertFile = LibreOfficePDFConvert.convert((File)convertFile, (File)outFile);
        }
        catch (OfficeException e) {
            log.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        return convertFile;
    }
}

