/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.core.util;

import com.jxdinfo.idp.common.util.SpringUtils;
import com.jxdinfo.idp.datacenter.core.util.DatabaseInstance;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceColumn;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceDatabase;
import com.jxdinfo.idp.datacenter.datasource.service.DatasourceDatabaseService;
import com.jxdinfo.idp.datacenter.datasource.service.impl.DatasourceDatabaseImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@DependsOn(value={"SpringUtils1"})
@Component
public class DbUtils {
    private static final Logger log = LoggerFactory.getLogger(DbUtils.class);
    private static Map<String, DatabaseInstance> dbMap = new ConcurrentHashMap<String, DatabaseInstance>();
    private static DatasourceDatabaseService databaseService;

    public DbUtils() {
        DbUtils a;
    }

    public static List<String> getDatabases(String a) {
        return DbUtils.strictfp(a).getDatabases();
    }

    public static List<DatasourceColumn> getColumnList(String a, String a2) {
        return DbUtils.strictfp(a).getColumns(a2);
    }

    public static int getCount(String a, String a2) {
        return DbUtils.strictfp(a).getCount(a2);
    }

    public static void delete(String a) {
        DatabaseInstance databaseInstance = DbUtils.strictfp(a);
        if (databaseInstance != null) {
            databaseInstance.close();
        }
        dbMap.remove(a);
    }

    public static void save(DatasourceDatabase a) {
        DatabaseInstance databaseInstance = new DatabaseInstance(a);
        DatabaseInstance databaseInstance2 = dbMap.get(a.getId());
        if (databaseInstance2 != null) {
            databaseInstance2.close();
        }
        dbMap.put(a.getId(), databaseInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean check(DatasourceDatabase a) {
        try (DatabaseInstance databaseInstance = new DatabaseInstance(a);){
            databaseInstance.getConnection();
            boolean bl = true;
            return bl;
        }
    }

    @PostConstruct
    private /* synthetic */ void abstract() {
        databaseService = (DatasourceDatabaseService)SpringUtils.getBean(DatasourceDatabaseImpl.class);
    }

    private static /* synthetic */ DatabaseInstance strictfp(String string) {
        String a;
        DatabaseInstance databaseInstance = dbMap.get(a);
        if (databaseInstance == null) {
            Object object = databaseService.getDetail(a);
            object = new DatabaseInstance((DatasourceDatabase)object);
            dbMap.put(a, (DatabaseInstance)((Object)object));
            return object;
        }
        return databaseInstance;
    }

    public static List<String> getDatabases(DatasourceDatabase a) {
        DatabaseInstance databaseInstance = new DatabaseInstance(a);
        List<String> list = databaseInstance.getDatabases();
        databaseInstance.close();
        return list;
    }

    public static List<String> getTables(String a) {
        return DbUtils.strictfp(a).getTables();
    }

    public static List<String> getSchemas(String a) {
        return DbUtils.strictfp(a).getSchemas();
    }

    public static List<String> getSchemas(DatasourceDatabase a) {
        DatabaseInstance databaseInstance = new DatabaseInstance(a);
        List<String> list = databaseInstance.getSchemas();
        databaseInstance.close();
        return list;
    }

    public static List<Map<String, Object>> getResultMapList(String a, String a2) {
        return DbUtils.strictfp(a).getResultMapList(a2);
    }
}

