/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.datasource.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.exception.HttpDataParserException;
import com.jxdinfo.idp.common.exception.HttpException;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.datacenter.core.support.http.HttpSupport;
import com.jxdinfo.idp.datacenter.datasource.entity.Datasource;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceColumn;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceHttp;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceHttpHeader;
import com.jxdinfo.idp.datacenter.datasource.entity.dto.DatasourceHttpDto;
import com.jxdinfo.idp.datacenter.datasource.entity.query.DatasourceHttpQuery;
import com.jxdinfo.idp.datacenter.datasource.mapper.DatasourceHttpMapper;
import com.jxdinfo.idp.datacenter.datasource.service.DatasourceHttpHeaderService;
import com.jxdinfo.idp.datacenter.datasource.service.DatasourceHttpService;
import com.jxdinfo.idp.datacenter.datasource.service.IDatasourceService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasourceHttpServiceImpl
extends ServiceImpl<DatasourceHttpMapper, DatasourceHttp>
implements DatasourceHttpService {
    @Autowired
    private IDatasourceService datasourceService;
    @Autowired
    private DatasourceHttpMapper mapper;
    @Autowired
    private HttpSupport support;
    @Autowired
    private DatasourceHttpHeaderService headerService;

    @Override
    public Page<DatasourceHttp> getList(DatasourceHttpQuery query) {
        Page<DatasourceHttp> page = query.getPage(DatasourceHttp.class);
        return this.mapper.getPageList(page, query);
    }

    @Override
    public List<DatasourceHttp> getList(String collectionId, String apiType) {
        return this.mapper.getList(collectionId, apiType);
    }

    @Override
    public Page<? extends DatasourceHttp> selectList(DatasourceHttpQuery query) {
        Page<DatasourceHttp> page = query.getPage(DatasourceHttp.class);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(DatasourceHttp::getCollectionId, (Object)query.getCollectionId())).orderByDesc(DatasourceHttp::getApiType);
        return (Page)this.page((IPage)page, (Wrapper)wrapper);
    }

    @Override
    public DatasourceHttp getDetail(String id) {
        return this.mapper.getDetail(id);
    }

    @Override
    public List<? extends DatasourceHttp> selectAll(DatasourceHttpQuery query) {
        String apiType = query.getApiType();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)apiType)) {
            wrapper.eq(DatasourceHttp::getApiType, (Object)apiType);
        }
        return this.list((Wrapper)wrapper);
    }

    @Override
    public boolean addApi(DatasourceHttpDto datasourceHttpDto) {
        String id = IdUtils.simpleUUID();
        datasourceHttpDto.setId(id);
        this.headerService.updateHeaders(datasourceHttpDto.getHttpHeaders(), id);
        DatasourceHttpDto datasource = datasourceHttpDto;
        ((Datasource)datasource).setId(id);
        datasource.setType("1");
        DatasourceHttp newHttp = new DatasourceHttp();
        BeanUtil.copyProperties((Object)datasourceHttpDto, (Object)newHttp, (String[])new String[0]);
        this.datasourceService.save(datasource);
        return this.mapper.saveDetail(newHttp);
    }

    @Override
    public boolean updateApi(DatasourceHttpDto datasourceHttpDto) {
        this.headerService.updateHeaders(datasourceHttpDto.getHttpHeaders(), datasourceHttpDto.getId());
        DatasourceHttpDto datasource = datasourceHttpDto;
        ((Datasource)datasource).setId(datasourceHttpDto.getId());
        datasource.setType("1");
        DatasourceHttp newHttp = new DatasourceHttp();
        BeanUtil.copyProperties((Object)datasourceHttpDto, (Object)newHttp, (String[])new String[0]);
        this.datasourceService.updateById(datasource);
        return this.mapper.updateDetailById(newHttp);
    }

    @Override
    public boolean deleteBatchApi(List<DatasourceHttp> datasourceHttps) {
        List<String> ids = datasourceHttps.stream().map(DatasourceHttp::getId).collect(Collectors.toList());
        this.datasourceService.removeByIds(ids);
        return this.deleteBatchByIds(ids);
    }

    @Override
    public boolean deleteBatchByIds(List<String> ids) {
        this.headerService.removeByAuthor(ids);
        this.datasourceService.removeByIds(ids);
        return this.removeByIds(ids);
    }

    @Override
    public DatasourceHttpDto detail(DatasourceHttpQuery query) {
        DatasourceHttpDto result = new DatasourceHttpDto();
        List<DatasourceHttpHeader> headers = this.headerService.getHeadersByAuthorId(query.getId());
        DatasourceHttp authorHttp = this.mapper.getDetail(query.getId());
        if ("business_api".equals(authorHttp.getApiType())) {
            String collectionId = authorHttp.getCollectionId();
            query.setCollectionId(collectionId);
            DatasourceHttpDto author = this.getAuthor(query);
            result.setAuthority(author);
        }
        BeanUtil.copyProperties((Object)authorHttp, (Object)result, (String[])new String[0]);
        result.setHttpHeaders(headers);
        return result;
    }

    @Override
    public DatasourceHttpDto getApiInfo(DatasourceHttpQuery query) {
        DatasourceHttpDto httpDto = this.detail(query);
        String collectionId = httpDto.getCollectionId();
        DatasourceHttpQuery httpQuery = new DatasourceHttpQuery();
        httpQuery.setCollectionId(collectionId);
        DatasourceHttpDto newAuthor = this.getAuthor(httpQuery);
        httpDto.setAuthority(newAuthor);
        return httpDto;
    }

    @Override
    public DatasourceHttpDto getAuthor(DatasourceHttpQuery query) {
        String id = this.mapper.getAuthorId(query.getCollectionId());
        DatasourceHttp author = this.getDetail(id);
        if (author == null) {
            return null;
        }
        DatasourceHttpDto newAuthor = new DatasourceHttpDto();
        BeanUtil.copyProperties((Object)author, (Object)newAuthor, (String[])new String[0]);
        List<DatasourceHttpHeader> header = this.headerService.getHeadersByAuthorId(author.getId());
        newAuthor.setHttpHeaders(header);
        return newAuthor;
    }

    @Override
    public DatasourceHttpDto testConnection(DatasourceHttpDto dto) {
        DatasourceHttpDto httpDto = new DatasourceHttpDto();
        try {
            String collectionId = dto.getCollectionId() == null || dto.getCollectionId().isEmpty() ? this.getDetail(dto.getId()).getCollectionId() : dto.getCollectionId();
            DatasourceHttpQuery query = new DatasourceHttpQuery();
            query.setCollectionId(collectionId);
            DatasourceHttpDto author = this.getAuthor(query);
            dto.setAuthority(author);
            Object support = this.support.support(dto);
            httpDto.setTestResult(support);
        }
        catch (HttpDataParserException | HttpException | IOException | URISyntaxException e) {
            httpDto.setTestResult(e.getMessage());
            httpDto.setSuccessful(false);
        }
        return httpDto;
    }

    @Override
    public List<DatasourceColumn> getColumns(DatasourceHttpQuery query) throws IOException, URISyntaxException {
        DatasourceHttpDto httpDto = new DatasourceHttpDto();
        try {
            List<String> field = this.support.getField(this.getApiInfo(query));
            return field.stream().map(k -> {
                DatasourceColumn column = new DatasourceColumn();
                column.setName((String)k);
                return column;
            }).collect(Collectors.toList());
        }
        catch (HttpDataParserException | HttpException e) {
            httpDto.setTestResult(e.getMessage());
            throw e;
        }
    }

    @Override
    public List<? extends DatasourceHttp> getApisByCollectionId(String collectionId) {
        return this.getList(collectionId, "author_api");
    }
}

