/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.core.util;

import cn.hutool.core.collection.CollectionUtil;
import com.jxdinfo.idp.common.entity.TreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public abstract class TreeUtil {
    public static <T extends TreeNode<T>> T produceTree(List<T> nodes, T root) {
        HashMap<String, List> parentIdChildMap = new HashMap<String, List>();
        for (TreeNode node : nodes) {
            String parentId = String.valueOf(node.getParentId());
            List childList = parentIdChildMap.computeIfAbsent(parentId, k -> new ArrayList());
            childList.add(node);
        }
        Stack<Object> stack = new Stack<Object>();
        stack.push(root);
        while (!stack.isEmpty()) {
            TreeNode parent = (TreeNode)stack.pop();
            List childList = (List)parentIdChildMap.get(parent.getId());
            parent.setChildren(childList);
            if (!CollectionUtil.isNotEmpty((Collection)childList)) continue;
            for (TreeNode child : childList) {
                stack.push(child);
            }
        }
        return root;
    }

    public static <T extends TreeNode<T>> List<T> produceTree(List<T> nodes, List<T> roots) {
        HashMap<String, List> parentIdChildMap = new HashMap<String, List>();
        for (TreeNode node : nodes) {
            String parentId = String.valueOf(node.getParentId());
            List childList = parentIdChildMap.computeIfAbsent(parentId, k -> new ArrayList());
            childList.add(node);
        }
        Stack<TreeNode> stack = new Stack<TreeNode>();
        roots.forEach(stack::push);
        while (!stack.isEmpty()) {
            TreeNode parent = (TreeNode)stack.pop();
            List childList = (List)parentIdChildMap.get(parent.getId());
            parent.setChildren(childList);
            if (!CollectionUtil.isNotEmpty((Collection)childList)) continue;
            for (TreeNode child : childList) {
                stack.push(child);
            }
        }
        return roots;
    }
}

