/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum DbEnum {
    MYSQL("mysql", "mysql", "com.mysql.cj.jdbc.Driver", "jdbc:mysql://#IP#:#PORT#/#DATABASE#?serverTimezone=GMT%2B8&useUnicode=true&characterEncoding=utf8&useOldAliasMetadataBehavior=true&&useInformationSchema=true&&rewriteBatchedStatements=true", "information_schema", Character.valueOf('`'), true, "limit (#pageNum#-1)*#pageSize#,#pageSize#"),
    DM6("dm6", "DM6", "dm.jdbc.driver.DmDriver", "jdbc:dm://#IP#:#PORT#/#DATABASE#", "SYSTEM", Character.valueOf('\"'), false),
    DM7("dm7", "DM7", "dm7.jdbc.driver.Dm7Driver", "jdbc:dm7://#IP#:#PORT#/#DATABASE#", "SYSDBA", Character.valueOf('\"'), false),
    DM8("dm8", "DM8", "dm.jdbc.driver.DmDriver", "jdbc:dm://#IP#:#PORT#/#DATABASE#", "SYSDBA", Character.valueOf('\"'), true),
    KB("kingbase", "\u91d1\u4ed3", "com.kingbase8.Driver", "jdbc:kingbase8://#IP#:#PORT#/#DATABASE#", "TEST", Character.valueOf('\"'), false),
    INFORMIX("informix", "\u5357\u5927\u901a\u7528", "com.informix.jdbc.IfxDriver", "jdbc:informix-sqli://#IP#:#PORT#/#DATABASE#:INFORMIXSERVER=gbaseserver;CLIENT_LOCALE=zh_cn.utf8;DB_LOCALE=zh_cn.utf8;DELIMIDENT=y", "sysadmin", Character.valueOf('\"'), false),
    ORACLE("oracle", "oracle", "oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@#IP#:#PORT#:#DATABASE#", "gdoms", Character.valueOf('\"'), true),
    GAUSS("gauss", "gauss", "org.postgresql.Driver", "jdbc:postgresql://#IP#:#PORT#/#DATABASE#", "postgres", Character.valueOf('\"'), false),
    POSTGRESQL("postgresql", "postgresql", "org.postgresql.Driver", "jdbc:postgresql://#IP#:#PORT#/#DATABASE#?stringtype=unspecified", "postgres", Character.valueOf('\"'), true, "LIMIT #pageSize# OFFSET (#pageNum#-1)*#pageSize#"),
    HIVE("hive", "hive", "org.apache.hive.jdbc.HiveDriver", "jdbc:hive2://#IP#:#PORT#/#DATABASE#", "default", Character.valueOf('\"'), false),
    CASSANDRA("cassandra", "cassandra", "com.simba.cassandra.jdbc42.Driver", "jdbc:cassandra://#IP#:#PORT#/#DATABASE#", "system", Character.valueOf('\"'), false);

    private String id;
    private String name;
    private String driverClassName;
    private String url;
    private String defaultSchema;
    private Character separator;
    private Boolean visibility;
    private String pageInfo;

    private DbEnum(String id, String name, String driverClassName, String url, String defaultSchema, Character separator, Boolean visibility) {
        this.id = id;
        this.name = name;
        this.driverClassName = driverClassName;
        this.url = url;
        this.defaultSchema = defaultSchema;
        this.separator = separator;
        this.visibility = visibility;
    }

    public static DbEnum getDbEnum(String id) {
        for (DbEnum value : DbEnum.values()) {
            if (!value.getId().equals(id)) continue;
            return value;
        }
        return null;
    }

    public static List<Map<String, String>> getDatabaseTypes() {
        ArrayList<Map<String, String>> types = new ArrayList<Map<String, String>>();
        for (DbEnum value : DbEnum.values()) {
            if (!value.visibility.booleanValue()) continue;
            HashMap<String, String> typeMap = new HashMap<String, String>();
            typeMap.put("key", value.getName());
            typeMap.put("value", value.getId());
            types.add(typeMap);
        }
        return types;
    }

    public String getText(String text) {
        return this.separator + text + this.separator;
    }

    public String handlePage(String sql, int pageNum, int pageSize) {
        StringBuffer pageSql = new StringBuffer();
        switch (this.id) {
            case "mysql": {
                pageSql.append(sql);
                pageSql.append(" limit ").append((pageNum - 1) * pageSize).append(",").append(pageSize);
                break;
            }
            case "postgresql": {
                pageSql.append(sql);
                pageSql.append(" LIMIT ").append(pageSize).append(" OFFSET ").append((pageNum - 1) * pageSize);
            }
        }
        return pageSql.toString();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public Character getSeparator() {
        return this.separator;
    }

    public Boolean getVisibility() {
        return this.visibility;
    }

    public String getPageInfo() {
        return this.pageInfo;
    }

    private DbEnum(String id, String name, String driverClassName, String url, String defaultSchema, Character separator, Boolean visibility, String pageInfo) {
        this.id = id;
        this.name = name;
        this.driverClassName = driverClassName;
        this.url = url;
        this.defaultSchema = defaultSchema;
        this.separator = separator;
        this.visibility = visibility;
        this.pageInfo = pageInfo;
    }
}

