/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.core.util;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.util.JdbcUtils;
import com.jxdinfo.idp.datacenter.core.util.DbEnum;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceColumn;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceDatabase;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseInstance
extends DruidDataSource {
    private static final Logger log = LoggerFactory.getLogger(DatabaseInstance.class);
    private static final String POSTGRESQL_CATALOG_SQL = "SELECT * FROM pg_catalog.pg_database where datname != 'template0' and datname != 'template1'";
    private DatasourceDatabase database;

    DatabaseInstance(DatasourceDatabase database) {
        super(true);
        this.database = database;
        log.info("\u5f00\u59cb\u521d\u59cb\u5316 DruidUtils " + (Object)((Object)this));
        String dbsType = database.getDatabaseType();
        DbEnum dbEnum = DbEnum.getDbEnum(dbsType);
        assert (dbEnum != null);
        String jdbcUrl = dbEnum.getUrl().replaceAll("#IP#", database.getIp()).replaceAll("#PORT#", database.getPort()).replaceAll("#DATABASE#", StringUtils.isEmpty((CharSequence)database.getDefaultDatabase()) ? dbEnum.getDefaultSchema() : database.getDefaultDatabase());
        super.setUrl(jdbcUrl);
        super.setUsername(database.getUsername());
        super.setPassword(database.getPassword());
        super.setDriverClassName(dbEnum.getDriverClassName());
        super.setInitialSize(3);
        super.setMaxActive(500);
        super.setMinIdle(3);
        if ("mysql".equals(dbsType)) {
            super.setPoolPreparedStatements(false);
        } else if ("oracle".equals(dbsType) || "gauss".equals(dbsType) || "postgresql".equals(dbsType)) {
            super.setPoolPreparedStatements(true);
            super.setMaxOpenPreparedStatements(30);
        }
        if ("informix".equals(dbsType)) {
            super.setValidationQuery("select tabname from systables limit 1");
        } else if ("gauss".equals(dbsType) || "postgresql".equals(dbsType)) {
            super.setValidationQuery("SELECT 1");
        } else if ("oracle".equals(dbsType)) {
            Properties props = new Properties();
            props.put("remarksReporting", "true");
            props.put("oracle.jdbc.J2EE13Compliant", "true");
            super.setConnectProperties(props);
        } else if ("hive".equals(dbsType)) {
            super.setValidationQuery("SELECT 1");
        } else if ("cassandra".equals(dbsType)) {
            super.setValidationQuery("select count(1) from system.local;");
        } else {
            super.setValidationQuery("SELECT 1 from DUAL");
        }
        super.setTestOnBorrow(false);
        super.setTestOnReturn(false);
        super.setTestWhileIdle(false);
        super.setMaxWait(5000L);
        super.setTimeBetweenEvictionRunsMillis(30000L);
        super.setKeepAlive(true);
        super.setDefaultAutoCommit(true);
        super.setBreakAfterAcquireFailure(true);
        super.setConnectionErrorRetryAttempts(0);
    }

    private void close(Connection con, Statement stat, ResultSet rs) {
        JdbcUtils.close((ResultSet)rs);
        JdbcUtils.close((Statement)stat);
        JdbcUtils.close((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSchemas() {
        ArrayList<String> list = new ArrayList<String>();
        DruidPooledConnection con = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            DatabaseMetaData databaseMetaData = con.getMetaData();
            ResultSet resultSet = rs = DbEnum.MYSQL.getDriverClassName().equals(this.getDriverClassName()) || DbEnum.INFORMIX.getDriverClassName().equals(this.getDriverClassName()) ? databaseMetaData.getCatalogs() : databaseMetaData.getSchemas();
            while (rs.next()) {
                list.add(rs.getString(1).trim());
            }
            ArrayList<String> arrayList = list;
            this.close((Connection)con, null, rs);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                log.error("\u67e5\u8be2\u6570\u636e\u5e93\u6a21\u5f0f\u5f02\u5e38", (Throwable)e);
                ArrayList<String> arrayList = new ArrayList<String>();
                this.close((Connection)con, null, rs);
                return arrayList;
            }
            catch (Throwable throwable) {
                this.close((Connection)con, null, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDatabases() {
        ArrayList<String> list = new ArrayList<String>();
        DruidPooledConnection con = null;
        ResultSet rs = null;
        Statement stat = null;
        try {
            con = this.getConnection();
            DatabaseMetaData databaseMetaData = con.getMetaData();
            if (DbEnum.KB.getDriverClassName().equals(this.getDriverClassName())) {
                String sql;
                stat = con.createStatement();
                rs = stat.executeQuery(sql = "select a.datname,b.usename from sys_database a left join sys_user b on a.datdba = b.usesysid where b.usename ='" + this.getUsername() + "';");
                if (null != rs) {
                    while (rs.next()) {
                        list.add(rs.getString(1).trim());
                    }
                }
            } else if ("postgresql".equals(this.database.getDatabaseType())) {
                stat = con.createStatement();
                rs = stat.executeQuery(POSTGRESQL_CATALOG_SQL);
                if (rs != null) {
                    while (rs.next()) {
                        list.add(rs.getString("datname").trim());
                    }
                }
            } else {
                rs = databaseMetaData.getCatalogs();
                while (rs.next()) {
                    list.add(rs.getString(1).trim());
                }
            }
            ArrayList<String> arrayList = list;
            this.close((Connection)con, stat, rs);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                log.error("\u83b7\u53d6\u6570\u636e\u5e93\u540d\u5f02\u5e38", (Throwable)e);
                ArrayList<String> arrayList = new ArrayList<String>();
                this.close((Connection)con, stat, rs);
                return arrayList;
            }
            catch (Throwable throwable) {
                this.close((Connection)con, stat, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTables() {
        ArrayList<String> list = new ArrayList<String>();
        DruidPooledConnection con = null;
        ResultSet rs = null;
        String database = this.database.getDefaultDatabase();
        String schema = this.database.getDefaultSchema();
        try {
            con = this.getConnection();
            DatabaseMetaData databaseMetaData = con.getMetaData();
            if ("oracle".equals(this.database.getDatabaseType())) {
                database = null;
                schema = this.getUsername().toUpperCase();
            }
            rs = databaseMetaData.getTables(database, schema, null, new String[]{"TABLE"});
            while (rs.next()) {
                String tableName = rs.getString(3);
                list.add(tableName);
            }
            ArrayList<String> arrayList = list;
            this.close((Connection)con, null, rs);
            return arrayList;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8868\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        finally {
            this.close((Connection)con, null, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DatasourceColumn> getColumns(String table) {
        ArrayList<DatasourceColumn> list = new ArrayList<DatasourceColumn>();
        DruidPooledConnection con = null;
        ResultSet rs = null;
        String database = this.database.getDefaultDatabase();
        String schema = this.database.getDefaultSchema();
        try {
            con = this.getConnection();
            DatabaseMetaData databaseMetaData = con.getMetaData();
            if ("oracle".equals(this.database.getDatabaseType())) {
                database = null;
                schema = this.getUsername().toUpperCase();
            }
            rs = databaseMetaData.getColumns(database, schema, table, null);
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                String note = rs.getString("REMARKS");
                String type = this.convertToChinese(rs.getString("TYPE_NAME"));
                DatasourceColumn column = new DatasourceColumn(columnName, note, type);
                list.add(column);
            }
            ArrayList<DatasourceColumn> arrayList = list;
            this.close((Connection)con, null, rs);
            return arrayList;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8868\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            ArrayList<DatasourceColumn> arrayList = new ArrayList<DatasourceColumn>();
            return arrayList;
        }
        finally {
            this.close((Connection)con, null, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getResultMap(String sql) {
        log.info("sql=[" + sql + "]");
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return new HashMap<String, Object>(1);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        DruidPooledConnection con = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stat = con.createStatement();
            rs = stat.executeQuery(sql);
            if (null != rs) {
                ResultSetMetaData column = rs.getMetaData();
                while (rs.next()) {
                    for (int i = 1; i <= column.getColumnCount(); ++i) {
                        data.put(column.getColumnName(i), rs.getObject(column.getColumnName(i)));
                    }
                }
                HashMap<String, Object> hashMap = data;
                this.close((Connection)con, stat, rs);
                return hashMap;
            }
            this.close((Connection)con, stat, rs);
        }
        catch (SQLException e) {
            try {
                log.error("DruidUtils getResultMap sql==>(" + sql + ") execute error");
                this.close((Connection)con, stat, rs);
            }
            catch (Throwable throwable) {
                this.close((Connection)con, stat, rs);
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getResultMapList(String sql) {
        ArrayList data = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return new ArrayList<Map<String, Object>>();
        }
        DruidPooledConnection con = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            Object column;
            con = this.getConnection();
            stat = con.createStatement();
            rs = stat.executeQuery(sql);
            if (null != rs) {
                column = rs.getMetaData();
                while (rs.next()) {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    for (int i = 1; i <= column.getColumnCount(); ++i) {
                        map.put(column.getColumnName(i), rs.getObject(column.getColumnName(i)));
                    }
                    data.add(map);
                }
            }
            column = data;
            this.close((Connection)con, stat, rs);
            return column;
        }
        catch (Exception e) {
            try {
                log.error("DruidUtils getResultMapList sql==>(" + sql + ") execute error");
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                this.close((Connection)con, stat, rs);
                return arrayList;
            }
            catch (Throwable throwable) {
                this.close((Connection)con, stat, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(String sql) {
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return -1;
        }
        DruidPooledConnection con = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stat = con.createStatement();
            rs = stat.executeQuery(sql);
            if (null != rs && rs.next()) {
                int n = rs.getInt(1);
                this.close((Connection)con, stat, rs);
                return n;
            }
            this.close((Connection)con, stat, rs);
        }
        catch (SQLException e) {
            try {
                log.error("DruidUtils getCount sql==>(" + sql + ") execute error", (Throwable)e);
                this.close((Connection)con, stat, rs);
            }
            catch (Throwable throwable) {
                this.close((Connection)con, stat, rs);
                throw throwable;
            }
        }
        return -1;
    }

    private String convertToChinese(String dataType) {
        String chineseName;
        switch (dataType.toLowerCase()) {
            case "varchar": {
                chineseName = "text";
                break;
            }
            case "int": {
                chineseName = "number";
                break;
            }
            case "float": {
                chineseName = "number";
                break;
            }
            case "date": {
                chineseName = "date";
                break;
            }
            case "boolean": {
                chineseName = "text";
                break;
            }
            default: {
                chineseName = "text";
            }
        }
        return chineseName;
    }
}

