/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.datasource.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.datacenter.core.util.DbEnum;
import com.jxdinfo.idp.datacenter.core.util.DbUtils;
import com.jxdinfo.idp.datacenter.datasource.entity.Datasource;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceColumn;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceDatabase;
import com.jxdinfo.idp.datacenter.datasource.entity.query.DatabaseQuery;
import com.jxdinfo.idp.datacenter.datasource.mapper.DataSourceDatabaseMapper;
import com.jxdinfo.idp.datacenter.datasource.service.DatasourceDatabaseService;
import com.jxdinfo.idp.datacenter.datasource.service.IDatasourceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DatasourceDatabaseImpl
extends ServiceImpl<DataSourceDatabaseMapper, DatasourceDatabase>
implements DatasourceDatabaseService {
    @Autowired
    private IDatasourceService datasourceService;
    @Autowired
    private DataSourceDatabaseMapper mapper;

    @Override
    public Page<DatasourceDatabase> getList(DatabaseQuery query) {
        Page<DatasourceDatabase> page = query.getPage(DatasourceDatabase.class);
        return this.mapper.getPageList(page, query);
    }

    @Override
    public List<DatasourceDatabase> getList() {
        return this.mapper.getList();
    }

    @Override
    public DatasourceDatabase getDetail(String id) {
        return this.mapper.getDetail(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean add(DatasourceDatabase database) {
        if (this.checkNameUnique(database)) {
            throw new BusinessException("\u6570\u636e\u5e93\u540d\u79f0\u91cd\u590d");
        }
        database.setId(IdUtils.simpleUUID());
        if (!DbUtils.check(database)) {
            throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u3001\u5bc6\u7801\u7b49\u4fe1\u606f");
        }
        DbUtils.save(database);
        DatasourceDatabase newDatabase = new DatasourceDatabase();
        BeanUtils.copyProperties((Object)database, (Object)newDatabase);
        DatasourceDatabase datasource = database;
        datasource.setType("0");
        ((Datasource)datasource).setId(database.getId());
        this.datasourceService.save(database);
        return this.save(newDatabase);
    }

    @Override
    public boolean update(DatasourceDatabase database) {
        if (this.checkNameUnique(database)) {
            throw new BusinessException("\u6570\u636e\u5e93\u540d\u79f0\u91cd\u590d");
        }
        if (!DbUtils.check(database)) {
            throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u3001\u5bc6\u7801\u7b49\u4fe1\u606f");
        }
        DbUtils.save(database);
        DatasourceDatabase newDatabase = new DatasourceDatabase();
        BeanUtils.copyProperties((Object)database, (Object)newDatabase);
        DatasourceDatabase datasource = database;
        datasource.setType("0");
        ((Datasource)datasource).setId(database.getId());
        this.datasourceService.updateById(datasource);
        return this.updateById(newDatabase);
    }

    @Override
    public DatasourceDatabase detail(String id) {
        return (DatasourceDatabase)this.getById((Serializable)((Object)id));
    }

    @Override
    public boolean deleteBatch(List<String> ids) {
        for (String id : ids) {
            DbUtils.delete(id);
        }
        this.datasourceService.removeByIds(ids);
        return this.removeByIds(ids);
    }

    @Override
    public List<String> connect(DatasourceDatabase database) {
        if (!DbUtils.check(database)) {
            throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u4fe1\u606f!");
        }
        return DbUtils.getDatabases(database);
    }

    @Override
    public List<String> getSchemas(DatasourceDatabase database) {
        if (!DbUtils.check(database)) {
            throw new BusinessException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u4fe1\u606f!");
        }
        return DbUtils.getSchemas(database);
    }

    @Override
    public List<String> getTables(String id) {
        return DbUtils.getTables(id);
    }

    @Override
    public List<DatasourceColumn> getColumns(String id, String tableName) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            return new ArrayList<DatasourceColumn>();
        }
        return DbUtils.getColumnList(id, tableName);
    }

    @Override
    public List<Map<String, String>> getDatabaseTypes() {
        return DbEnum.getDatabaseTypes();
    }

    private boolean checkNameUnique(DatasourceDatabase dataSource) {
        return this.mapper.checkNameUnique(dataSource);
    }
}

