/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.core.util;

import com.jxdinfo.idp.common.util.SpringUtils;
import com.jxdinfo.idp.datacenter.core.util.DatabaseInstance;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceColumn;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceDatabase;
import com.jxdinfo.idp.datacenter.datasource.service.DatasourceDatabaseService;
import com.jxdinfo.idp.datacenter.datasource.service.impl.DatasourceDatabaseImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"SpringUtils1"})
@Component
public class DbUtils {
    private static final Logger log = LoggerFactory.getLogger(DbUtils.class);
    private static Map<String, DatabaseInstance> dbMap = new ConcurrentHashMap<String, DatabaseInstance>();
    private static DatasourceDatabaseService databaseService;

    @PostConstruct
    private void register() {
        databaseService = (DatasourceDatabaseService)SpringUtils.getBean(DatasourceDatabaseImpl.class);
    }

    private static DatabaseInstance get(String key) {
        DatabaseInstance instance = dbMap.get(key);
        if (instance == null) {
            DatasourceDatabase database = databaseService.getDetail(key);
            DatabaseInstance newInstance = new DatabaseInstance(database);
            dbMap.put(key, newInstance);
            return newInstance;
        }
        return instance;
    }

    public static void save(DatasourceDatabase database) {
        DatabaseInstance instance = new DatabaseInstance(database);
        DatabaseInstance oldInstance = dbMap.get(database.getId());
        if (oldInstance != null) {
            oldInstance.close();
        }
        dbMap.put(database.getId(), instance);
    }

    public static void delete(String key) {
        DatabaseInstance instance = DbUtils.get(key);
        if (instance != null) {
            instance.close();
        }
        dbMap.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean check(DatasourceDatabase database) {
        try (DatabaseInstance instance = new DatabaseInstance(database);){
            instance.getConnection();
            boolean bl = true;
            return bl;
        }
    }

    public static List<String> getSchemas(String key) {
        DatabaseInstance instance = DbUtils.get(key);
        return instance.getSchemas();
    }

    public static List<String> getSchemas(DatasourceDatabase database) {
        DatabaseInstance instance = new DatabaseInstance(database);
        List<String> databases = instance.getSchemas();
        instance.close();
        return databases;
    }

    public static List<String> getDatabases(String key) {
        DatabaseInstance instance = DbUtils.get(key);
        return instance.getDatabases();
    }

    public static List<String> getDatabases(DatasourceDatabase database) {
        DatabaseInstance instance = new DatabaseInstance(database);
        List<String> databases = instance.getDatabases();
        instance.close();
        return databases;
    }

    public static List<String> getTables(String key) {
        DatabaseInstance instance = DbUtils.get(key);
        return instance.getTables();
    }

    public static List<DatasourceColumn> getColumnList(String key, String tableName) {
        DatabaseInstance instance = DbUtils.get(key);
        return instance.getColumns(tableName);
    }

    public static List<Map<String, Object>> getResultMapList(String key, String sql) {
        DatabaseInstance instance = DbUtils.get(key);
        return instance.getResultMapList(sql);
    }

    public static int getCount(String key, String sql) {
        DatabaseInstance instance = DbUtils.get(key);
        return instance.getCount(sql);
    }
}

