/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.core.support.http;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.idp.common.exception.HttpDataParserException;
import com.jxdinfo.idp.common.exception.HttpException;
import com.jxdinfo.idp.datacenter.core.support.http.HttpSupport;
import com.jxdinfo.idp.datacenter.core.util.http.HttpRequestParam;
import com.jxdinfo.idp.datacenter.core.util.http.HttpRequestUtils;
import com.jxdinfo.idp.datacenter.datasource.entity.Datasource;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceHttpHeader;
import com.jxdinfo.idp.datacenter.datasource.entity.dto.DatasourceHttpDto;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="httpSupport")
public class HttpSupportImpl
implements HttpSupport {
    private static final Pattern PATTERN = Pattern.compile("(\\d+)");
    private static final Pattern FIELD_PATTERN = Pattern.compile("\\w*");

    @Override
    public Object support(Datasource connectionInfo) throws IOException, URISyntaxException {
        return this.callApi((DatasourceHttpDto)connectionInfo);
    }

    @Override
    public List<String> getField(Datasource connection) throws IOException, URISyntaxException {
        Set fieldSet;
        DatasourceHttpDto httpDto = (DatasourceHttpDto)connection;
        Map result = (Map)this.callApi(httpDto);
        if (result == null) {
            return Collections.emptyList();
        }
        Object realData = this.getRealData(httpDto, result);
        if (realData instanceof List) {
            fieldSet = ((Map)((List)realData).get(0)).keySet();
        } else if (realData instanceof Map) {
            fieldSet = ((Map)realData).keySet();
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b,\u6570\u636e\u7ed3\u679c\u96c6\u4e3a" + realData);
        }
        return new ArrayList<String>(fieldSet);
    }

    @Override
    public Object callApi(DatasourceHttpDto httpDto) throws IOException, URISyntaxException {
        if (httpDto == null) {
            throw new HttpException("\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a", (Object)"");
        }
        String token = "";
        DatasourceHttpDto authority = httpDto.getAuthority();
        if (authority != null && Objects.equals(httpDto.getApiType(), "business_api")) {
            Map<String, Object> result = this.call(authority);
            token = (String)this.getRealData(authority, result);
        }
        httpDto.setToken(token);
        return this.call(httpDto);
    }

    @Override
    public Object getRealData(DatasourceHttpDto authority, Map<String, Object> result) {
        Map mayException = result;
        String analysisDataKey = authority.getAnalysisDataKey();
        if (StringUtils.isBlank((CharSequence)analysisDataKey)) {
            return result;
        }
        String[] fields = analysisDataKey.split("\\.");
        int len = fields.length - 1;
        for (int i = 0; i < len; ++i) {
            Object tmpData;
            String field = fields[i];
            int index = this.arrayIndex(field);
            if (index == -1) {
                tmpData = result.get(field);
                if (tmpData == null) {
                    throw new HttpDataParserException("\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff0c\u5f02\u5e38\u6570\u636e\u4e3a{}", (Object)mayException);
                }
                result = (Map)tmpData;
                continue;
            }
            Matcher matcher = FIELD_PATTERN.matcher(field);
            matcher.find();
            field = matcher.group();
            tmpData = result.get(field);
            if (tmpData == null) {
                throw new HttpDataParserException("\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff0c\u5f02\u5e38\u6570\u636e\u4e3a{}", (Object)mayException);
            }
            List tmpList = (List)tmpData;
            if (CollectionUtil.isEmpty((Collection)tmpList) || tmpList.size() <= index) {
                throw new HttpDataParserException("\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff0c\u5f02\u5e38\u6570\u636e\u4e3a{}", (Object)mayException);
            }
            result = (Map)tmpList.get(index);
        }
        return result.get(fields[fields.length - 1]);
    }

    private int arrayIndex(String field) {
        Matcher matcher = PATTERN.matcher(field);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(0));
        }
        return -1;
    }

    private Map<String, Object> call(DatasourceHttpDto httpDto) throws IOException, URISyntaxException {
        List<DatasourceHttpHeader> httpHeaders;
        HttpRequestParam requestParam = HttpRequestParam.builder().url(httpDto.getUrl()).requestType(httpDto.getRequestType()).headers((Map<String, Object>)JSONObject.parseObject((String)httpDto.getHeaders())).queryParam((Map<String, Object>)JSONObject.parseObject((String)httpDto.getQueryParam())).body(httpDto.getBody()).bodyType(httpDto.getBodyType()).build();
        HttpRequestUtils httpRequestUtils = new HttpRequestUtils(requestParam);
        String token = httpDto.getToken();
        DatasourceHttpDto authority = httpDto.getAuthority();
        if (StringUtils.isNotEmpty((CharSequence)token) && authority != null && CollectionUtil.isNotEmpty(httpHeaders = authority.getHttpHeaders())) {
            for (DatasourceHttpHeader httpHeader : httpHeaders) {
                Map<String, Object> header = requestParam.getHeaders();
                header.put(httpHeader.getBusinessKey(), token);
            }
        }
        return JSONObject.parseObject((String)httpRequestUtils.requestForPostGet());
    }
}

