/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.datasource.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceHttp;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceHttpCollection;
import com.jxdinfo.idp.datacenter.datasource.entity.dto.DatasourceHttpDto;
import com.jxdinfo.idp.datacenter.datasource.entity.query.DatasourceHttpQuery;
import com.jxdinfo.idp.datacenter.datasource.service.DatasourceHttpCollectionService;
import com.jxdinfo.idp.datacenter.datasource.service.DatasourceHttpService;
import com.jxdinfo.idp.datacenter.datasource.service.HttpManagementService;
import com.jxdinfo.idp.datacenter.datasource.service.impl.CommonAuthor;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpManagementServiceImpl
implements HttpManagementService {
    @Autowired
    private DatasourceHttpService httpService;
    @Autowired
    private DatasourceHttpCollectionService collectionService;
    @Autowired
    private CommonAuthor commonAuthor;

    @Override
    public DatasourceHttpDto getSystemAuthor(DatasourceHttpQuery query) {
        return this.commonAuthor.getAuthor(query.getSystemAuthorType());
    }

    @Override
    public DatasourceHttpDto isExistAuthor(DatasourceHttpQuery query) {
        boolean isExistAuthor;
        List<? extends DatasourceHttp> authorList = this.httpService.getApisByCollectionId(query.getCollectionId());
        DatasourceHttpDto httpDto = new DatasourceHttpDto();
        boolean bl = isExistAuthor = CollectionUtil.isEmpty(authorList) || Objects.equals(authorList.get(0).getId(), query.getId()) || Objects.equals(query.getApiType(), "business_api");
        if (isExistAuthor) {
            httpDto.setExistAuthor(false);
        }
        return httpDto;
    }

    @Override
    public Page<? extends DatasourceHttp> selectList(DatasourceHttpQuery query) {
        return this.httpService.getList(query);
    }

    @Override
    public void addApi(DatasourceHttpDto datasourceHttpDto) {
        this.httpService.addApi(datasourceHttpDto);
    }

    @Override
    public void updateApi(DatasourceHttpDto datasourceHttpDto) {
        this.httpService.updateApi(datasourceHttpDto);
    }

    @Override
    public void deleteBatchApi(List<DatasourceHttp> datasourceHttps) {
        this.httpService.deleteBatchApi(datasourceHttps);
    }

    @Override
    public List<DatasourceHttpCollection> selectCollectionTree() {
        return this.collectionService.selectCollectionTree();
    }

    @Override
    public void addCollection(DatasourceHttpCollection collection) {
        this.collectionService.addCollection(collection);
    }

    @Override
    public void updateCollection(DatasourceHttpCollection collection) {
        this.collectionService.updateCollection(collection);
    }

    @Override
    public void deleteBatchCollection(List<DatasourceHttpCollection> collections) {
        this.collectionService.deleteBatchCollection(collections);
    }

    @Override
    public DatasourceHttpDto detail(DatasourceHttpQuery query) {
        return this.httpService.detail(query);
    }

    @Override
    public DatasourceHttpDto testConnection(DatasourceHttpDto query) {
        return this.httpService.testConnection(query);
    }
}

