/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.datasource.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.datacenter.core.util.TreeUtil;
import com.jxdinfo.idp.datacenter.datasource.entity.Datasource;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceHttp;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceTree;
import com.jxdinfo.idp.datacenter.datasource.mapper.IDatasourceMapper;
import com.jxdinfo.idp.datacenter.datasource.service.DatasourceDatabaseService;
import com.jxdinfo.idp.datacenter.datasource.service.DatasourceHttpCollectionService;
import com.jxdinfo.idp.datacenter.datasource.service.DatasourceHttpService;
import com.jxdinfo.idp.datacenter.datasource.service.IDatasourceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="datasourceServiceImpl2")
public class DatasourceServiceImpl
extends ServiceImpl<IDatasourceMapper, Datasource>
implements IDatasourceService {
    @Autowired
    private DatasourceDatabaseService databaseService;
    @Autowired
    private DatasourceHttpCollectionService httpCollectionService;
    @Autowired
    private DatasourceHttpService httpService;
    private static final List<DatasourceTree> Roots = new ArrayList<DatasourceTree>();

    @Override
    public List<DatasourceTree> tree() {
        List httpCollections;
        ArrayList treeNodes = new ArrayList();
        List databaseList = this.databaseService.list();
        if (CollectionUtil.isNotEmpty((Collection)databaseList)) {
            List trees = databaseList.stream().map(database -> new DatasourceTree(database.getId(), "0", database.getName(), 1, 0)).collect(Collectors.toList());
            treeNodes.addAll(trees);
        }
        if (CollectionUtil.isNotEmpty((Collection)(httpCollections = this.httpCollectionService.list()))) {
            List trees = httpCollections.stream().map(httpCollection -> new DatasourceTree(String.valueOf(httpCollection.getId()), String.valueOf(httpCollection.getParentId()), httpCollection.getName(), 0)).collect(Collectors.toList());
            treeNodes.addAll(trees);
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DatasourceHttp::getApiType, (Object)"business_api");
        List httpList = this.httpService.list((Wrapper)wrapper);
        if (CollectionUtil.isNotEmpty((Collection)httpList)) {
            List trees = httpList.stream().map(http -> new DatasourceTree(http.getId(), http.getCollectionId(), http.getName(), 1, 1)).collect(Collectors.toList());
            treeNodes.addAll(trees);
        }
        return TreeUtil.produceTree(treeNodes, Roots);
    }

    static {
        DatasourceTree root1 = new DatasourceTree("0", "\u6570\u636e\u5e93", (Integer)0);
        Roots.add(root1);
        DatasourceTree root2 = new DatasourceTree("-1", "\u63a5\u53e3", (Integer)0);
        Roots.add(root2);
    }
}

