/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.datasource.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceHttpHeader;
import com.jxdinfo.idp.datacenter.datasource.mapper.DatasourceHttpHeaderMapper;
import com.jxdinfo.idp.datacenter.datasource.service.DatasourceHttpHeaderService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasourceHttpHeaderServiceImpl
extends ServiceImpl<DatasourceHttpHeaderMapper, DatasourceHttpHeader>
implements DatasourceHttpHeaderService {
    @Autowired
    private DatasourceHttpHeaderMapper mapper;

    @Override
    public void updateHeaders(List<DatasourceHttpHeader> httpHeaders, String authorId) {
        if (CollectionUtil.isEmpty(httpHeaders)) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DatasourceHttpHeader::getAuthorId, (Object)authorId);
        this.remove((Wrapper)queryWrapper);
        httpHeaders.forEach(k -> k.setAuthorId(authorId));
        this.saveBatch(httpHeaders);
    }

    @Override
    public List<DatasourceHttpHeader> getHeadersByAuthorId(String authorId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DatasourceHttpHeader::getAuthorId, (Object)authorId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void removeByAuthor(List<String> authorId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(DatasourceHttpHeader::getAuthorId, authorId);
        this.remove((Wrapper)wrapper);
    }
}

