/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.datasource.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceDatabase;
import com.jxdinfo.idp.datacenter.datasource.entity.query.DatabaseQuery;
import com.jxdinfo.idp.datacenter.datasource.service.DatasourceDatabaseService;
import java.beans.PropertyVetoException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config/dataAccess/datasource/database"})
public class DataBaseController {
    @Autowired
    private DatasourceDatabaseService service;

    @PostMapping(value={"/list"})
    public ApiResponse<Page<? extends DatasourceDatabase>> list(@RequestBody DatabaseQuery databaseQuery) {
        return ApiResponse.data(this.service.getList(databaseQuery));
    }

    @PostMapping(value={"/add"})
    public ApiResponse<Void> add(@RequestBody DatasourceDatabase database) {
        this.service.add(database);
        return ApiResponse.success();
    }

    @PostMapping(value={"/update"})
    public ApiResponse<Void> update(@RequestBody DatasourceDatabase database) {
        this.service.update(database);
        return ApiResponse.success();
    }

    @PostMapping(value={"/detail"})
    public ApiResponse<DatasourceDatabase> detail(@RequestBody String id) {
        return ApiResponse.data((Object)this.service.detail(id));
    }

    @PostMapping(value={"/delete"})
    public ApiResponse<Void> delete(@RequestBody List<String> ids) {
        try {
            this.service.deleteBatch(ids);
        }
        catch (BusinessException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/connect"})
    public ApiResponse<List<String>> connect(@RequestBody DatasourceDatabase database) {
        try {
            List<String> databases = this.service.connect(database);
            return ApiResponse.data(databases);
        }
        catch (BusinessException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/getSchemas"})
    public ApiResponse<List<String>> getSchemas(@RequestBody DatasourceDatabase database) throws PropertyVetoException, SQLException {
        return ApiResponse.data(this.service.getSchemas(database));
    }

    @GetMapping(value={"/getDatabaseTypes"})
    public ApiResponse<List<Map<String, String>>> getDatabaseTypes() {
        return ApiResponse.data(this.service.getDatabaseTypes());
    }
}

