/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.core.util.http;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.exception.HttpException;
import com.jxdinfo.idp.datacenter.core.util.http.HttpRequestParam;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class HttpRequestUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestUtils.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestUtils.class);
    private static final HttpClientBuilder HTTP_CLIENT_BUILDER = HttpClientBuilder.create();
    private final HttpRequestParam param;
    private final HttpClient httpClient;

    public HttpRequestUtils(HttpRequestParam param) {
        this.param = param;
        this.httpClient = HTTP_CLIENT_BUILDER.build();
    }

    public String requestForPostGet() throws IOException, URISyntaxException {
        HttpResponse response;
        HttpRequestBase httpRequest = this.createHttpRequest(this.param);
        try {
            response = this.httpClient.execute((HttpUriRequest)httpRequest);
        }
        catch (Exception e) {
            throw new HttpException(e.getCause().getMessage());
        }
        int status = response.getStatusLine().getStatusCode();
        if (status != 200) {
            throw new HttpException("\u8bf7\u6c42\u5931\u8d25", (Object)response.getEntity());
        }
        HttpEntity entity = response.getEntity();
        return EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
    }

    private HttpRequestBase createHttpRequest(HttpRequestParam param) throws URISyntaxException, UnsupportedEncodingException {
        HttpDelete httpRequest;
        switch (param.getRequestType()) {
            case "POST": {
                HttpPost httpPost = new HttpPost();
                HttpEntity postEntity = this.createHttpEntity(param);
                httpPost.setEntity(postEntity);
                httpRequest = httpPost;
                break;
            }
            case "PUT": {
                HttpPut httpPut = new HttpPut();
                HttpEntity putEntity = this.createHttpEntity(param);
                httpPut.setEntity(putEntity);
                httpRequest = httpPut;
                break;
            }
            case "DELETE": {
                httpRequest = new HttpDelete();
                break;
            }
            default: {
                httpRequest = new HttpGet();
            }
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(3000).setSocketTimeout(3000).setConnectionRequestTimeout(3000).build();
        httpRequest.setConfig(config);
        httpRequest.setURI(this.createUri(param));
        this.withHeaders(param, (HttpRequestBase)httpRequest);
        return httpRequest;
    }

    private HttpEntity createHttpEntity(HttpRequestParam param) throws UnsupportedEncodingException {
        if (StringUtils.isNotEmpty((CharSequence)param.getBody())) {
            if (Objects.equals("formData", param.getBodyType())) {
                List<NameValuePair> pairs = HttpRequestUtils.buildPairs(param.getBody());
                return new UrlEncodedFormEntity(pairs, "UTF-8");
            }
            if (Objects.equals("json", param.getBodyType())) {
                return new StringEntity(param.getBody(), "UTF-8");
            }
            return null;
        }
        return null;
    }

    private static List<NameValuePair> buildPairs(String paramsBody) throws UnsupportedEncodingException {
        JSONObject params = JSONObject.parseObject((String)paramsBody);
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        if (params != null) {
            Set keys = params.keySet();
            for (String key : keys) {
                pairs.add((NameValuePair)new BasicNameValuePair(key, URLDecoder.decode((String)params.get(key), "UTF-8")));
            }
        }
        return pairs;
    }

    private URI createUri(HttpRequestParam param) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(param.getUrl());
        if (!CollectionUtils.isEmpty(param.getQueryParam())) {
            for (Map.Entry<String, Object> entry : param.getQueryParam().entrySet()) {
                uriBuilder.addParameter(entry.getKey(), (String)entry.getValue());
            }
        }
        return uriBuilder.build();
    }

    private void withHeaders(HttpRequestParam param, HttpRequestBase httpRequest) {
        if (!CollectionUtils.isEmpty(param.getHeaders())) {
            for (Map.Entry<String, Object> entry : param.getHeaders().entrySet()) {
                httpRequest.addHeader(entry.getKey(), (String)entry.getValue());
            }
        }
        if (Objects.equals("formData", param.getBodyType())) {
            httpRequest.addHeader("Content-type", "application/x-www-form-urlencoded;charset=utf-8");
        } else if (Objects.equals("json", param.getBodyType())) {
            httpRequest.addHeader("Content-type", "application/json;charset=utf-8");
        }
    }

    static {
        try {
            SSLConnectionSocketFactory scsf = new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            HTTP_CLIENT_BUILDER.setSSLSocketFactory((LayeredConnectionSocketFactory)scsf);
        }
        catch (Exception e) {
            LOGGER.warn("HttpClient config ssl failed, and used default config.");
        }
    }
}

