/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.datacenter.datasource.service.impl;

import com.jxdinfo.idp.datacenter.datasource.entity.DatasourceHttpHeader;
import com.jxdinfo.idp.datacenter.datasource.entity.dto.DatasourceHttpDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CommonAuthor
implements InitializingBean {
    private static final Map<String, DatasourceHttpDto> AUTHORITY_MAP = new HashMap<String, DatasourceHttpDto>();
    @Value(value="${business_author.pms.url}")
    private String pmsUrl;
    @Value(value="${business_author.pms.clientId}")
    private String pmsClientId;
    @Value(value="${business_author.pms.clientSecret}")
    private String pmsClientSecret;
    @Value(value="${business_author.huayun.url}")
    private String huayunUrl;
    @Value(value="${business_author.huayun.clientId}")
    private String huayunClientId;
    @Value(value="${business_author.huayun.clientSecret}")
    private String huayunClientSecret;
    @Value(value="${business_author.huayun.grantType}")
    private String huayunGrantType;

    public DatasourceHttpDto getAuthor(String type) {
        return AUTHORITY_MAP.get(type);
    }

    public void afterPropertiesSet() {
        DatasourceHttpDto pms = new DatasourceHttpDto();
        pms.setAnalysisDataKey("access_token");
        pms.setApiType("author_api");
        pms.setUrl(this.pmsUrl);
        pms.setName("pms3.0\u9274\u6743\u63a5\u53e3");
        pms.setQueryParam("{\"client_id\":\"" + this.pmsClientId + "\"," + "\"client_secret\":\"" + this.pmsClientSecret + "\"}");
        pms.setRequestType("GET");
        pms.setBody("{}");
        pms.setHeaders("{}");
        pms.setAuthorApiType("pms3");
        DatasourceHttpHeader header = new DatasourceHttpHeader();
        header.setAuthorKey("access_token");
        header.setBusinessKey("x-token");
        ArrayList<DatasourceHttpHeader> headers = new ArrayList<DatasourceHttpHeader>();
        headers.add(header);
        pms.setHttpHeaders(headers);
        AUTHORITY_MAP.put("pms", pms);
        DatasourceHttpDto huayun = new DatasourceHttpDto();
        huayun.setAnalysisDataKey("access_token");
        huayun.setApiType("author_api");
        huayun.setUrl(this.huayunUrl);
        huayun.setBody("{\"client_id\":\"" + this.huayunClientId + "\"," + "\"client_secret\":\"" + this.huayunClientSecret + "\", " + "\"grantType\":\"" + this.huayunGrantType + "\"}");
        huayun.setName("\u534e\u4e91\u9274\u6743\u63a5\u53e3");
        huayun.setRequestType("POST");
        huayun.setBodyType("formData");
        header = new DatasourceHttpHeader();
        header.setAuthorKey("access_token");
        header.setBusinessKey("x-token");
        headers = new ArrayList();
        huayun.setQueryParam("{}");
        huayun.setHeaders("{}");
        headers.add(header);
        huayun.setAuthorApiType("huayun");
        huayun.setHttpHeaders(headers);
        AUTHORITY_MAP.put("huayun", huayun);
    }
}

