/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.config.mybatis.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.jxdinfo.idp.common.user.cache.IDPUserInfoPool;
import com.jxdinfo.idp.common.util.ZNYSStringUtil;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class MybatisPlusMetaObjectHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusMetaObjectHandler.class);

    public void insertFill(MetaObject metaObject) {
        this.fillValIfNullByName("createTime", LocalDateTime.now(), metaObject, false);
        this.fillValIfNullByName("deleteFlag", 0, metaObject, false);
        try {
            this.fillValIfNullByName("creator", IDPUserInfoPool.getUserInfoStatic().getUserName(), metaObject, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateFill(MetaObject metaObject) {
        this.fillValIfNullByName("deleteTime", LocalDateTime.now(), metaObject, false);
        try {
            this.fillValIfNullByName("updateUser", IDPUserInfoPool.getUserInfoStatic().getUserName(), metaObject, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fillValIfNullByName(String fieldName, Object fieldVal, MetaObject metaObject, boolean isCover) {
        if (!metaObject.hasSetter(fieldName)) {
            return;
        }
        Object userSetValue = metaObject.getValue(fieldName);
        String setValueStr = ZNYSStringUtil.str((Object)userSetValue, (Charset)Charset.defaultCharset());
        if (ZNYSStringUtil.isNotBlank((CharSequence)setValueStr) && !isCover) {
            return;
        }
        Class getterType = metaObject.getGetterType(fieldName);
        if (ClassUtils.isAssignableValue((Class)getterType, (Object)fieldVal)) {
            metaObject.setValue(fieldName, fieldVal);
        }
    }
}

