/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.comparator.impl;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.entity.location.Location;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphInfo;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.TextDiffUtil;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.comparator.impl.AbstractComparator;
import com.jxdinfo.idp.compare.entity.comparator.DiffMapping;
import com.jxdinfo.idp.compare.entity.comparator.ParaTextMap;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class Word2WordComparator
extends AbstractComparator<WordInfo, WordInfo> {
    public Word2WordComparator() {
        super(DocumentComparatorEnum.WORD2WORD);
    }

    @Override
    public List<CompareResult> compare(WordInfo reference, WordInfo contrast) {
        List referenceParaInfos = reference.getParaInfos();
        StringBuilder referenceText = new StringBuilder();
        referenceParaInfos.forEach(e -> referenceText.append(e.getText()));
        List contrastParaInfos = contrast.getParaInfos();
        StringBuilder contrastText = new StringBuilder();
        contrastParaInfos.forEach(e -> contrastText.append(e.getText()));
        TextDiffUtil util = new TextDiffUtil();
        util.Diff_Timeout = 0.0f;
        LinkedList diffs = util.diffMain(referenceText.toString(), contrastText.toString());
        List<CompareResult> compareResults = this.getCompareResults(diffs, referenceParaInfos, contrastParaInfos);
        compareResults.removeIf(compareResult -> StringUtils.isBlank((CharSequence)compareResult.getReferenceContent()) && StringUtils.isBlank((CharSequence)compareResult.getCompareContent()));
        return compareResults;
    }

    private List<CompareResult> getCompareResults(List<TextDiffUtil.Diff> diffs, List<WordParagraphInfo> reference, List<WordParagraphInfo> compare) {
        LinkedList<CompareResult> compareResults = new LinkedList<CompareResult>();
        List<String> rTexts = reference.stream().map(WordParagraphInfo::getText).collect(Collectors.toList());
        List<String> cTexts = compare.stream().map(WordParagraphInfo::getText).collect(Collectors.toList());
        List<DiffMapping> mappings = this.cutTexts(diffs, rTexts, cTexts);
        CompareResult result = null;
        for (int i = 0; i < mappings.size(); ++i) {
            if (TextDiffUtil.Operation.EQUAL.equals((Object)diffs.get((int)i).operation)) {
                if (result == null) continue;
                if (result.getRLocation() == null) {
                    result.setRLocation(this.mutexLocation(mappings, diffs, i));
                }
                if (result.getCLocation() != null) continue;
                result.setCLocation(this.mutexLocation(mappings, diffs, i));
                continue;
            }
            if (TextDiffUtil.Operation.DELETE.equals((Object)diffs.get((int)i).operation)) {
                result = new CompareResult();
                compareResults.add(result);
                result.setReferenceContent(diffs.get((int)i).text);
                result.setRLocation(this.location(mappings, diffs, i));
                continue;
            }
            if (result == null) {
                result = new CompareResult();
                compareResults.add(result);
            }
            result.setCompareContent(diffs.get((int)i).text);
            result.setCLocation(this.location(mappings, diffs, i));
        }
        if (result != null) {
            if (result.getRLocation() == null) {
                result.setRLocation(this.mutexLocation(mappings, diffs, mappings.size() - 1));
            }
            if (result.getCLocation() == null) {
                result.setCLocation(this.mutexLocation(mappings, diffs, mappings.size() - 1));
            }
        }
        return compareResults;
    }

    public List<DiffMapping> cutTexts(List<TextDiffUtil.Diff> diffs, List<String> reference, List<String> compare) {
        ArrayList<DiffMapping> mappings = new ArrayList<DiffMapping>();
        int rIndex = 0;
        int cIndex = 0;
        int rTextIndex = 0;
        int cTextIndex = 0;
        for (TextDiffUtil.Diff diff : diffs) {
            DiffMapping mapping = new DiffMapping();
            mappings.add(mapping);
            StringBuilder rText = new StringBuilder();
            StringBuilder cText = new StringBuilder();
            switch (diff.operation) {
                case EQUAL: {
                    ParaTextMap paraTextMap;
                    for (int j = 0; j < diff.text.length(); ++j) {
                        while (rTextIndex++ >= reference.get(rIndex).length()) {
                            paraTextMap = new ParaTextMap(rIndex++, rText.toString());
                            if (rText.length() > 0) {
                                mapping.getRParaTextMaps().add(paraTextMap);
                            }
                            rText = new StringBuilder();
                            rTextIndex = 0;
                        }
                        while (cTextIndex++ >= compare.get(cIndex).length()) {
                            paraTextMap = new ParaTextMap(cIndex++, cText.toString());
                            if (cText.length() != 0) {
                                mapping.getCParaTextMaps().add(paraTextMap);
                            }
                            cText = new StringBuilder();
                            cTextIndex = 0;
                        }
                        rText.append(diff.text.charAt(j));
                        cText.append(diff.text.charAt(j));
                    }
                    if (rText.length() > 0) {
                        ParaTextMap rParaTextMap = new ParaTextMap(rIndex, rText.toString());
                        mapping.getRParaTextMaps().add(rParaTextMap);
                    }
                    if (cText.length() <= 0) break;
                    ParaTextMap cParaTextMap = new ParaTextMap(cIndex, cText.toString());
                    mapping.getCParaTextMaps().add(cParaTextMap);
                    break;
                }
                case DELETE: {
                    ParaTextMap paraTextMap;
                    rText = new StringBuilder();
                    for (int j = 0; j < diff.text.length(); ++j) {
                        while (rTextIndex++ >= reference.get(rIndex).length()) {
                            paraTextMap = new ParaTextMap(rIndex++, rText.toString());
                            if (rText.length() != 0) {
                                mapping.getRParaTextMaps().add(paraTextMap);
                            }
                            rText = new StringBuilder();
                            rTextIndex = 0;
                        }
                        rText.append(diff.text.charAt(j));
                    }
                    if (rText.length() <= 0) break;
                    ParaTextMap rParaTextMap = new ParaTextMap(rIndex, rText.toString());
                    mapping.getRParaTextMaps().add(rParaTextMap);
                    break;
                }
                case INSERT: {
                    ParaTextMap paraTextMap;
                    cText = new StringBuilder();
                    for (int j = 0; j < diff.text.length(); ++j) {
                        while (cTextIndex++ >= compare.get(cIndex).length()) {
                            paraTextMap = new ParaTextMap(cIndex++, cText.toString());
                            if (cText.length() != 0) {
                                mapping.getCParaTextMaps().add(paraTextMap);
                            }
                            cText = new StringBuilder();
                            cTextIndex = 0;
                        }
                        cText.append(diff.text.charAt(j));
                    }
                    if (cText.length() <= 0) break;
                    ParaTextMap cParaTextMap = new ParaTextMap(cIndex, cText.toString());
                    mapping.getCParaTextMaps().add(cParaTextMap);
                }
            }
        }
        return mappings;
    }

    private Location location(List<DiffMapping> mappings, List<TextDiffUtil.Diff> diffs, int index) {
        String suffixStr;
        String text;
        String prefixStr;
        ParaTextMap paraTextMap;
        Object suffix;
        Object paraTextMap22;
        StringBuilder prefix;
        Location location = new Location();
        TextDiffUtil.Diff current = diffs.get(index);
        DiffMapping mapping = mappings.get(index);
        ArrayList<String> rTexts = new ArrayList<String>();
        ArrayList<String> cTexts = new ArrayList<String>();
        ArrayList<String> rContexts = new ArrayList<String>();
        ArrayList<String> cContexts = new ArrayList<String>();
        ArrayList<Integer> rTextIndexes = new ArrayList<Integer>();
        ArrayList<Integer> cTextIndexes = new ArrayList<Integer>();
        int back = index - 1;
        int forward = index + 1;
        if (CollUtil.isNotEmpty((Collection)mapping.getRParaTextMaps())) {
            location.setTexts(rTexts);
            location.setContexts(rContexts);
            location.setTextIndexes(rTextIndexes);
            for (ParaTextMap rParaTextMap : mapping.getRParaTextMaps()) {
                rTexts.add(rParaTextMap.getText());
                prefix = new StringBuilder();
                while (back >= 0) {
                    if (diffs.get((int)back).operation == TextDiffUtil.Operation.EQUAL) {
                        for (Object paraTextMap22 : mappings.get(back).getRParaTextMaps()) {
                            if (paraTextMap22.getIndex() != rParaTextMap.getIndex()) continue;
                            prefix.append(paraTextMap22.getText());
                        }
                        break;
                    }
                    --back;
                }
                suffix = new StringBuilder();
                while (forward < diffs.size()) {
                    if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL) {
                        paraTextMap22 = mappings.get(forward).getRParaTextMaps().iterator();
                        while (paraTextMap22.hasNext()) {
                            paraTextMap = (ParaTextMap)paraTextMap22.next();
                            if (paraTextMap.getIndex() != rParaTextMap.getIndex()) continue;
                            ((StringBuilder)suffix).append(paraTextMap.getText());
                        }
                        break;
                    }
                    ++forward;
                }
                prefixStr = prefix.toString().replaceAll("\\s+", "");
                text = rParaTextMap.getText().replaceAll("\\s+", "");
                suffixStr = ((StringBuilder)suffix).toString().replaceAll("\\s+", "");
                rContexts.add(prefixStr + text + suffixStr);
                rTextIndexes.add(prefixStr.length());
            }
        } else if (CollUtil.isNotEmpty((Collection)mapping.getCParaTextMaps())) {
            location.setTexts(cTexts);
            location.setContexts(cContexts);
            location.setTextIndexes(cTextIndexes);
            for (ParaTextMap cParaTextMap : mapping.getCParaTextMaps()) {
                cTexts.add(cParaTextMap.getText());
                prefix = new StringBuilder();
                while (back >= 0) {
                    if (diffs.get((int)back).operation == TextDiffUtil.Operation.EQUAL) {
                        for (Object paraTextMap22 : mappings.get(back).getCParaTextMaps()) {
                            if (paraTextMap22.getIndex() != cParaTextMap.getIndex()) continue;
                            prefix.append(paraTextMap22.getText());
                        }
                        break;
                    }
                    --back;
                }
                suffix = new StringBuilder();
                while (forward < diffs.size()) {
                    if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL) {
                        paraTextMap22 = mappings.get(forward).getCParaTextMaps().iterator();
                        while (paraTextMap22.hasNext()) {
                            paraTextMap = (ParaTextMap)paraTextMap22.next();
                            if (paraTextMap.getIndex() != cParaTextMap.getIndex()) continue;
                            ((StringBuilder)suffix).append(paraTextMap.getText());
                        }
                        break;
                    }
                    ++forward;
                }
                prefixStr = prefix.toString().replaceAll("\\s+", "");
                text = cParaTextMap.getText().replaceAll("\\s+", "");
                suffixStr = ((StringBuilder)suffix).toString().replaceAll("\\s+", "");
                cContexts.add(prefixStr + text + suffixStr);
                cTextIndexes.add(prefixStr.length());
            }
        }
        String prefix2 = "";
        String suffix2 = "";
        while (back >= 0) {
            if (diffs.get((int)back).operation == TextDiffUtil.Operation.EQUAL) {
                prefix2 = diffs.get((int)back).text;
                break;
            }
            --back;
        }
        while (forward < diffs.size()) {
            if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL) {
                suffix2 = diffs.get((int)forward).text;
                break;
            }
            ++forward;
        }
        prefix2 = prefix2.replaceAll("\\s+", "");
        suffix2 = suffix2.replaceAll("\\s+", "");
        String text2 = current.text.replaceAll("\\s+", "");
        location.setText(text2);
        location.setContext(prefix2 + text2 + suffix2);
        location.setTextIndex(Integer.valueOf(prefix2.length()));
        return location;
    }

    private Location mutexLocation(List<DiffMapping> mappings, List<TextDiffUtil.Diff> diffs, int index) {
        Object suffix;
        String prefix;
        Location location = new Location();
        DiffMapping mapping = mappings.get(index);
        ArrayList<Object> rTexts = new ArrayList<Object>();
        ArrayList<Object> cTexts = new ArrayList<Object>();
        ArrayList<String> rContexts = new ArrayList<String>();
        ArrayList<String> cContexts = new ArrayList<String>();
        ArrayList<Integer> rTextIndexes = new ArrayList<Integer>();
        ArrayList<Integer> cTextIndexes = new ArrayList<Integer>();
        int back = index - 1;
        int forward = index;
        if (CollUtil.isNotEmpty((Collection)mapping.getRParaTextMaps())) {
            location.setTexts(rTexts);
            location.setContexts(rContexts);
            location.setTextIndexes(rTextIndexes);
            for (ParaTextMap rParaTextMap : mapping.getRParaTextMaps()) {
                rTexts.add(null);
                prefix = "";
                while (back >= 0) {
                    if (diffs.get((int)back).operation == TextDiffUtil.Operation.EQUAL) {
                        for (Object paraTextMap : mappings.get(back).getRParaTextMaps()) {
                            if (paraTextMap.getIndex() != rParaTextMap.getIndex()) continue;
                            prefix = paraTextMap.getText() + prefix;
                        }
                        break;
                    }
                    --back;
                }
                suffix = new StringBuilder();
                while (forward < diffs.size()) {
                    if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL) {
                        Object paraTextMap;
                        paraTextMap = mappings.get(forward).getRParaTextMaps().iterator();
                        while (paraTextMap.hasNext()) {
                            ParaTextMap paraTextMap2 = (ParaTextMap)paraTextMap.next();
                            if (paraTextMap2.getIndex() != rParaTextMap.getIndex()) continue;
                            ((StringBuilder)suffix).append(paraTextMap2.getText());
                        }
                        break;
                    }
                    ++forward;
                }
                prefix = prefix.replaceAll("\\s+", "");
                rContexts.add(prefix + ((StringBuilder)suffix).toString().replaceAll("\\s+", ""));
                if (StringUtils.isNotEmpty((String)prefix) && StringUtils.isNotEmpty((CharSequence)suffix)) {
                    rTextIndexes.add(-1);
                    continue;
                }
                rTextIndexes.add(prefix.length());
            }
        } else if (CollUtil.isNotEmpty((Collection)mapping.getCParaTextMaps())) {
            location.setTexts(cTexts);
            location.setContexts(cContexts);
            location.setTextIndexes(cTextIndexes);
            for (ParaTextMap cParaTextMap : mapping.getCParaTextMaps()) {
                cTexts.add(null);
                prefix = "";
                while (back >= 0) {
                    if (diffs.get((int)back).operation == TextDiffUtil.Operation.EQUAL) {
                        for (Object paraTextMap : mappings.get(back).getCParaTextMaps()) {
                            if (paraTextMap.getIndex() != cParaTextMap.getIndex()) continue;
                            prefix = prefix + paraTextMap.getText();
                        }
                        break;
                    }
                    --back;
                }
                suffix = new StringBuilder();
                while (forward < diffs.size()) {
                    if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL) {
                        for (ParaTextMap paraTextMap2 : mappings.get(forward).getCParaTextMaps()) {
                            if (paraTextMap2.getIndex() != cParaTextMap.getIndex()) continue;
                            ((StringBuilder)suffix).append(paraTextMap2.getText());
                        }
                        break;
                    }
                    ++forward;
                }
                prefix = prefix.replaceAll("\\s+", "");
                cContexts.add(prefix + ((StringBuilder)suffix).toString().replaceAll("\\s+", ""));
                if (StringUtils.isNotEmpty((String)prefix) && StringUtils.isNotEmpty((CharSequence)suffix)) {
                    cTextIndexes.add(-1);
                } else {
                    cTextIndexes.add(prefix.length());
                }
                cTextIndexes.add(prefix.length());
            }
        }
        String prefix2 = "";
        String suffix2 = "";
        while (back >= 0) {
            if (diffs.get((int)back).operation == TextDiffUtil.Operation.EQUAL) {
                prefix2 = diffs.get((int)back).text;
                break;
            }
            --back;
        }
        while (forward < diffs.size()) {
            if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL) {
                suffix2 = diffs.get((int)forward).text;
                break;
            }
            ++forward;
        }
        prefix2 = prefix2.replaceAll("\\s+", "");
        suffix2 = suffix2.replaceAll("\\s+", "");
        location.setContext(prefix2 + suffix2);
        location.setTextIndex(Integer.valueOf(prefix2.length()));
        return location;
    }

    private Location location(List<TextDiffUtil.Diff> diffs, TextDiffUtil.Diff current, int index) {
        Location location = new Location();
        location.setText(current.text);
        int forward = index + 1;
        String prefix = "";
        String suffix = "";
        for (int back = index - 1; back >= 0; --back) {
            if (diffs.get((int)back).operation != TextDiffUtil.Operation.EQUAL && diffs.get((int)back).operation != current.operation) continue;
            prefix = diffs.get((int)back).text;
            break;
        }
        while (forward < diffs.size()) {
            if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL || diffs.get((int)forward).operation == current.operation) {
                suffix = diffs.get((int)forward).text;
                break;
            }
            ++forward;
        }
        location.setContext(prefix + current.text + suffix);
        location.setTextIndex(Integer.valueOf(prefix.length()));
        return location;
    }

    private Location mutexLocation(List<TextDiffUtil.Diff> diffs, TextDiffUtil.Diff current, int index) {
        Location location = new Location();
        int forward = index + 1;
        String prefix = "";
        String suffix = "";
        for (int back = index - 1; back >= 0; --back) {
            if (diffs.get((int)back).operation != TextDiffUtil.Operation.EQUAL && diffs.get((int)back).operation == current.operation) continue;
            prefix = diffs.get((int)back).text;
            break;
        }
        while (forward < diffs.size()) {
            if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL || diffs.get((int)forward).operation != current.operation) {
                suffix = diffs.get((int)forward).text;
                break;
            }
            ++forward;
        }
        location.setContext(prefix + suffix);
        location.setTextIndex(Integer.valueOf(prefix.length()));
        location.setText("");
        return location;
    }
}

