/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.comparator.impl;

import com.jxdinfo.idp.common.pdfparser.core.PdfParser;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.comparator.impl.AbstractComparator;
import com.jxdinfo.idp.compare.entity.comparator.CompareDocInitInfo;
import com.jxdinfo.idp.compare.entity.comparator.CompareElementInfo;
import com.jxdinfo.idp.compare.entity.comparator.CompareOtherInfo;
import com.jxdinfo.idp.compare.entity.comparator.CompareTextInfo;
import com.jxdinfo.idp.compare.entity.comparator.TableCellInfo;
import com.jxdinfo.idp.compare.entity.comparator.TableInfo;
import com.jxdinfo.idp.compare.entity.comparator.TextInfo;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PDF2PDFComparator
extends AbstractComparator<ContentPojo, ContentPojo> {
    private static final Logger log = LoggerFactory.getLogger(PDF2PDFComparator.class);

    public PDF2PDFComparator() {
        super(DocumentComparatorEnum.PDF2PDF);
    }

    @Override
    public List<CompareResult> compare(ContentPojo reference, ContentPojo compare) {
        return this.compare(this.toDocInitInfo(reference), this.toDocInitInfo(compare));
    }

    private CompareDocInitInfo toDocInitInfo(ContentPojo reference) {
        CompareDocInitInfo initInfo = new CompareDocInitInfo();
        List elementInfos = initInfo.getElementInfos();
        List outList = reference.getOutList();
        int index = 0;
        for (ContentPojo.contentElement element : outList) {
            if ("text".equals(element.getElementType()) && !this.isCatalog(element.getText())) {
                if (element.getSpanParaPageIndex() == -1) {
                    elementInfos.add(this.toTextInfo(element, index));
                } else {
                    String text = element.getText();
                    String currentPageText = text.substring(0, element.getSpanParaPageIndex());
                    elementInfos.add(this.crossPageToTextInfo(currentPageText, element.getPageNumber(), index));
                    String nextPageText = text.substring(element.getSpanParaPageIndex());
                    elementInfos.add(this.crossPageToTextInfo(nextPageText, element.getPageNumber() + 1, ++index));
                }
            } else {
                elementInfos.add(this.toOtherInfo(element, index));
            }
            ++index;
        }
        return initInfo;
    }

    private CompareElementInfo toTextInfo(ContentPojo.contentElement element, int index) {
        CompareTextInfo textInfo = new CompareTextInfo();
        textInfo.setText(element.getText().replaceAll("[ \\n]+", ""));
        textInfo.setPageNum(element.getPageNumber());
        textInfo.setIndex(Integer.valueOf(index));
        return textInfo;
    }

    private CompareElementInfo crossPageToTextInfo(String text, int pageNum, int index) {
        CompareTextInfo textInfo = new CompareTextInfo();
        textInfo.setText(text.replaceAll("[ \\n]+", ""));
        textInfo.setPageNum(Integer.valueOf(pageNum));
        textInfo.setIndex(Integer.valueOf(index));
        return textInfo;
    }

    private CompareOtherInfo toOtherInfo(ContentPojo.contentElement element, int index) {
        CompareOtherInfo otherInfo = new CompareOtherInfo();
        otherInfo.setPageNum(element.getPageNumber());
        otherInfo.setIndex(Integer.valueOf(index));
        return otherInfo;
    }

    private List<TextInfo> convert2TextInfos(ContentPojo pdfInfo) {
        ArrayList<TextInfo> textInfos = new ArrayList<TextInfo>();
        List outList = pdfInfo.getOutList();
        ContentPojo.contentElement prevElement = null;
        int elementIndex = 0;
        int i = 0;
        while (i < outList.size()) {
            ContentPojo.contentElement element = (ContentPojo.contentElement)outList.get(i);
            if (Objects.nonNull(prevElement) && ("text".equals(prevElement.getElementType()) || "title".equals(prevElement.getElementType())) && !this.isCatalog(prevElement.getText())) {
                if ("table".equals(element.getElementType()) || "pic".equals(element.getElementType()) || this.isCatalog(element.getText())) {
                    textInfos.add(new TextInfo(Integer.valueOf(elementIndex), prevElement.getPageNumber(), prevElement.getText(), false));
                } else {
                    textInfos.add(new TextInfo(Integer.valueOf(elementIndex), prevElement.getPageNumber(), prevElement.getText()));
                }
            }
            if (("text".equals(element.getElementType()) || "title".equals(element.getElementType())) && !this.isCatalog(element.getText())) {
                String cleanedText = element.getText().replaceAll("[ \\n]+", "");
                element.setText(cleanedText);
            }
            elementIndex = i++;
            prevElement = element;
        }
        if (prevElement != null && ("text".equals(prevElement.getElementType()) || "title".equals(prevElement.getElementType()))) {
            textInfos.add(new TextInfo(Integer.valueOf(elementIndex), prevElement.getPageNumber(), prevElement.getText()));
        }
        return textInfos;
    }

    private List<TableInfo> convert2TableInfos(ContentPojo contentPojo) {
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
        for (int i = 0; i < contentPojo.getOutList().size(); ++i) {
            ContentPojo.contentElement element = (ContentPojo.contentElement)contentPojo.getOutList().get(i);
            if (!"table".equals(element.getElementType())) continue;
            TableInfo tableInfo = new TableInfo();
            tableInfo.setPageNum(element.getPageNumber());
            tableInfo.setIndex(Integer.valueOf(i));
            tableInfo.setCells2D(this.convert2Cells2D(element.getCells(), element));
            tableInfos.add(tableInfo);
        }
        return tableInfos;
    }

    private TableCellInfo[][] convert2Cells2D(List<ContentPojo.contentElement.InnerCell> cells, ContentPojo.contentElement table) {
        if (Objects.isNull(cells)) {
            return new TableCellInfo[0][0];
        }
        int y = 1;
        boolean x = true;
        ArrayList<TableCellInfo> cellInfos = new ArrayList<TableCellInfo>();
        ArrayList<TableCellInfo[]> cellInfos2DList = new ArrayList<TableCellInfo[]>();
        TableCellInfo lastCellInfo = null;
        for (ContentPojo.contentElement.InnerCell cell : cells) {
            TableCellInfo cellInfo = this.cell2CellInfo(table, cell);
            if (cell.getRow_index() == y) {
                cellInfos.add(cellInfo);
            } else {
                if (Objects.nonNull(lastCellInfo)) {
                    lastCellInfo.setValue(lastCellInfo.getValue() + "\n");
                }
                cellInfos2DList.add(cellInfos.toArray(new TableCellInfo[0]));
                y = cell.getRow_index();
                cellInfos = new ArrayList();
                cellInfos.add(cellInfo);
            }
            lastCellInfo = cellInfo;
        }
        if (Objects.nonNull(lastCellInfo)) {
            lastCellInfo.setValue(lastCellInfo.getValue() + "\n");
        }
        cellInfos2DList.add(cellInfos.toArray(new TableCellInfo[0]));
        return (TableCellInfo[][])cellInfos2DList.toArray((T[])new TableCellInfo[0][]);
    }

    private TableCellInfo cell2CellInfo(ContentPojo.contentElement table, ContentPojo.contentElement.InnerCell cell) {
        TableCellInfo cellInfo = new TableCellInfo();
        ArrayList<Float> bbox = new ArrayList<Float>();
        bbox.add(cell.getXStart());
        bbox.add(cell.getYStart());
        bbox.add(Float.valueOf(cell.getXStart().floatValue() + cell.getWidth().floatValue()));
        bbox.add(Float.valueOf(cell.getYStart().floatValue() + cell.getHeight().floatValue()));
        cellInfo.setBbox(bbox);
        cellInfo.setValue(cell.getText().replaceAll("[ \\n\\r]+", ""));
        cellInfo.setPageWidth(table.getPageWidth());
        cellInfo.setPageHeight(table.getPageHeight());
        cellInfo.setPageNum(table.getPageNumber());
        return cellInfo;
    }

    public static void main(String[] args) throws Exception {
        File file = new File("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24020003\u5168\u6d41\u7a0b\u667a\u80fd\u5de5\u5382300\u5428\u8f6c\u7089\u64cd\u4f5c\u53f0\u5408\u5e76\u9879\u76ee\\2.ZF3G24020003\u62db\u6807\u6280\u672f\u534f\u8bae.pdf");
        PDDocument referencePdf = PDDocument.load((File)file);
        ContentPojo referenceInfo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)referencePdf, (boolean)true);
        PDDocument comparePdf = PDDocument.load((File)new File("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24020003\u5168\u6d41\u7a0b\u667a\u80fd\u5de5\u5382300\u5428\u8f6c\u7089\u64cd\u4f5c\u53f0\u5408\u5e76\u9879\u76ee\\4.ZF3G24020003\u7b7e\u7ae0\u6280\u672f\u534f\u8bae.pdf"));
        ContentPojo compareInfo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)comparePdf, (boolean)true);
        PDF2PDFComparator comparator = new PDF2PDFComparator();
        List<CompareResult> results = comparator.compare(referenceInfo, compareInfo);
        results.removeIf(CompareResult2 -> StringUtils.isBlank((CharSequence)CompareResult2.getReferenceContent()) && StringUtils.isBlank((CharSequence)CompareResult2.getCompareContent()));
        System.out.println("end");
    }
}

