/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.comparator.util;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.pdfparser.core.PdfParser;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.pdfparser.tools.FileTool;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.compare.comparator.dto.HtmlElement;
import com.jxdinfo.idp.compare.comparator.dto.ImageSimilarity;
import com.jxdinfo.idp.compare.entity.po.CompareTaskHtml;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlCompareUtil {
    protected static final Logger logger = LoggerFactory.getLogger(HtmlCompareUtil.class);

    public static void main(String[] args) throws Exception {
        PDDocument reference = PDDocument.load((File)new File("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24020004\u5173\u4e8e\u5168\u6d41\u7a0b\u667a\u80fd\u5de5\u5382\u914d\u5957\u5750\u5e2d\u7cfb\u7edf\u9879\u76ee\\2.ZF3G24020004\u62db\u6807\u6280\u672f\u9644\u4ef6.pdf"));
        PDDocument compare = PDDocument.load((File)new File("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24020004\u5173\u4e8e\u5168\u6d41\u7a0b\u667a\u80fd\u5de5\u5382\u914d\u5957\u5750\u5e2d\u7cfb\u7edf\u9879\u76ee\\4.ZF3G24020004\u7b7e\u7ae0\u6280\u672f\u9644\u4ef6.pdf"));
        ContentPojo refPojo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)reference, (boolean)true);
        ContentPojo compPojo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)compare, (boolean)true);
        CompareTaskHtml compareResult = HtmlCompareUtil.compareHtml(FileTool.table2Html((ContentPojo)refPojo), FileTool.table2Html((ContentPojo)compPojo));
        System.out.println("end");
    }

    private static void saveHtmlToFile(Document doc, String filename) {
        try {
            Files.write(Paths.get(filename, new String[0]), doc.html().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static CompareTaskHtml compareHtml(File file1, File file2) throws IOException {
        Document doc1 = Jsoup.parse((File)file1);
        Document doc2 = Jsoup.parse((File)file2);
        return HtmlCompareUtil.compareHtml(doc1, doc2);
    }

    public static CompareTaskHtml compareHtml(Document reference, Document compare) throws IOException {
        Elements pTags1 = reference.select("p, h1, h2, h3, h4, h5, h6");
        Elements pTags2 = compare.select("p, h1, h2, h3, h4, h5, h6");
        Instant now1 = Instant.now();
        HtmlCompareUtil.setDiff(pTags1, pTags2, true);
        Instant now2 = Instant.now();
        logger.info("\u5c06\u6587\u6863\u4e2d\u7684\u5143\u7d20\u7ed3\u5408\u4e0a\u4e0b\u6587\u8fdb\u884c\u5bf9\u6bd4\uff0c\u5e76\u6807\u8bb0\u4ed6\u4eec\u7684\u4e0d\u540c\u4e4b\u5904\uff0csetDiff() \t {}\u6beb\u79d2", (Object)Duration.between(now1, now2).toMillis());
        Instant now3 = Instant.now();
        HtmlCompareUtil.setReversalDiff(pTags2, pTags1, true);
        Instant now4 = Instant.now();
        logger.info("\u9006\u5411\u5bf9\u6bd4\uff0c\u5c06\u672a\u88ab\u5bf9\u6bd4\u7684\u5143\u7d20\u6807\u8bb0\u4e3a\u5220\u9664\uff0csetReversalDiff() \t {}\u6beb\u79d2", (Object)Duration.between(now3, now4).toMillis());
        Instant now5 = Instant.now();
        HtmlCompareUtil.compareTable(reference.getAllElements(), compare.getAllElements());
        Instant now6 = Instant.now();
        logger.info("\u6bd4\u8f83\u539f\u6587\u6863\u4e0e\u76ee\u6807\u6587\u6863\u4e2d\u7684\u8868\u683c\uff0c\u6807\u8bb0\u51fa\u5dee\u5f02\uff0ccompareTable() \t {}\u6beb\u79d2", (Object)Duration.between(now5, now6).toMillis());
        Instant now7 = Instant.now();
        HtmlCompareUtil.compareTableRevers(compare.getAllElements(), reference.getAllElements());
        Instant now8 = Instant.now();
        logger.info("\u9006\u5411\u5bf9\u6bd4\u8868\u683c\uff0c\u5c06\u5bf9\u6bd4\u6587\u4ef6\u4e2d\u7684\u672a\u88ab\u6807\u8bb0\u7684\u8868\u683c\u6807\u8bb0\u4e3a\u5220\u9664\uff0ccompareTableRevers() \t {}\u6beb\u79d2", (Object)Duration.between(now7, now8).toMillis());
        System.out.println("\u5bf9\u6bd4\u6210\u529f");
        CompareTaskHtml htmlInfo = new CompareTaskHtml();
        htmlInfo.setRefHtml(reference);
        htmlInfo.setCompHtml(compare);
        return htmlInfo;
    }

    public static String concatenateValuesWithPlaceholder(List<HtmlElement> elements, int start, int end, String placeholder) {
        StringBuilder result = new StringBuilder();
        for (int i = start; i < end; ++i) {
            if (i < elements.size()) {
                String value = elements.get(i).getValue();
                String content = elements.get(i).getContent();
                if (value == null || value.isEmpty()) {
                    result.append(content);
                    continue;
                }
                result.append(content);
                continue;
            }
            result.append(placeholder);
        }
        return result.toString();
    }

    public static Element getPid(Elements sourcePs, String id) {
        for (Element sourceP : sourcePs) {
            if (!sourceP.hasAttr("id") || !sourceP.attr("id").equals(id)) continue;
            return sourceP;
        }
        return null;
    }

    public static String findNearestSiblingWithId(Element element) {
        Element parent = element.parent();
        if (parent == null) {
            return null;
        }
        List nodes = parent.childNodes();
        int index = element.siblingIndex();
        for (int i = index - 1; i >= 0; --i) {
            Node node = (Node)nodes.get(i);
            if (node.hasAttr("id")) {
                return node.attr("id");
            }
            Node nodeWithId = HtmlCompareUtil.findNodeWithId(node);
            if (!StringUtils.isNotNull((Object)nodeWithId)) continue;
            return nodeWithId.attr("id");
        }
        return null;
    }

    public static String findBrotherId(Element element, StringBuilder flag) {
        String beforeId = HtmlCompareUtil.findNearestSiblingWithId(element);
        if (beforeId != null) {
            flag.append("BEFORE");
            return beforeId;
        }
        Element parent = element.parent();
        if (parent == null) {
            return null;
        }
        List nodes = parent.childNodes();
        int index = element.siblingIndex();
        for (int i = index + 1; i < nodes.size(); ++i) {
            Node node = (Node)nodes.get(i);
            if (node.hasAttr("id")) {
                return node.attr("id");
            }
            Node nodeWithId = HtmlCompareUtil.findNodeWithId(node);
            if (!StringUtils.isNotNull((Object)nodeWithId)) continue;
            flag.append("AFTER");
            return nodeWithId.attr("id");
        }
        return null;
    }

    public static Node findNodeWithId(Node node) {
        Element element;
        if (node instanceof Element && (element = (Element)node).hasAttr("id")) {
            return element;
        }
        for (Node child : node.childNodes()) {
            Node result = HtmlCompareUtil.findNodeWithId(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void compareTable(Elements sourcePages, Elements targetPages) {
        Elements sourceTables = sourcePages.select("table");
        Elements targetTables = targetPages.select("table");
        Elements targetPs = targetPages.select("p, h1, h2, h3, h4, h5, h6, table, tr, td");
        for (Element sourceTable : sourceTables) {
            boolean isFind = false;
            if (!sourceTable.attr("sign").isEmpty()) continue;
            HashMap<String, Object> sourceMap = HtmlCompareUtil.extractTableRows(sourceTable);
            List sourceRows = (List)sourceMap.get("rows");
            for (Element targetTable : targetTables) {
                if (!targetTable.attr("sign").isEmpty()) continue;
                HashMap<String, Object> targetMap = HtmlCompareUtil.extractTableRows(targetTable);
                List targetRows = (List)targetMap.get("rows");
                Elements srcTrs = sourceTable.select("tr");
                if (!(HtmlCompareUtil.calculateTableSimilarity(sourceRows, targetRows) > 0.3)) continue;
                UUID tableId = UUID.randomUUID();
                sourceTable.attr("id", tableId.toString());
                targetTable.attr("id", tableId.toString());
                sourceTable.attr("sign", "1");
                targetTable.attr("sign", "1");
                Elements tarTrs = targetTable.select("tr");
                for (Element srcTr : srcTrs) {
                    boolean notFindTr = true;
                    if (!srcTr.attr("sign").isEmpty()) continue;
                    Elements srcTds = srcTr.select("td");
                    for (Element tarTr : tarTrs) {
                        if (!tarTr.attr("sign").isEmpty() || !(HtmlCompareUtil.similarity(srcTr.text().trim(), tarTr.text().trim()) > 0.4)) continue;
                        UUID trId = UUID.randomUUID();
                        srcTr.attr("id", trId.toString());
                        tarTr.attr("id", trId.toString());
                        notFindTr = false;
                        srcTr.attr("sign", "1");
                        tarTr.attr("sign", "1");
                        Elements tarTds = tarTr.select("td");
                        if (tarTds.size() == srcTds.size()) {
                            for (int i = 0; i < tarTds.size(); ++i) {
                                Element tarTd = (Element)tarTds.get(i);
                                Element srcTd = (Element)srcTds.get(i);
                                UUID tdId = UUID.randomUUID();
                                srcTd.attr("id", tdId.toString());
                                tarTd.attr("id", tdId.toString());
                                srcTd.attr("sign", "1");
                                tarTd.attr("sign", "1");
                                HtmlCompareUtil.setDiff(srcTd, tarTd);
                            }
                        } else {
                            for (Element srcTd : srcTds) {
                                boolean motFindTd = true;
                                if (!srcTd.attr("sign").isEmpty()) continue;
                                for (Element tarTd : tarTds) {
                                    if (!tarTd.attr("sign").isEmpty() || !(HtmlCompareUtil.similarity(srcTd.text().trim(), tarTd.text().trim()) > 0.3)) continue;
                                    UUID tdId = UUID.randomUUID();
                                    srcTd.attr("id", tdId.toString());
                                    tarTd.attr("id", tdId.toString());
                                    motFindTd = false;
                                    srcTd.attr("sign", "1");
                                    tarTd.attr("sign", "1");
                                    HtmlCompareUtil.setDiff(srcTd, tarTd);
                                    break;
                                }
                                if (!motFindTd) continue;
                                String uid = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
                                Element delSpan = new Element("div");
                                delSpan.attr("class", "del-class border-left3 border-top3 border-right3 border-bottom3");
                                delSpan.attr("data-type", "1");
                                delSpan.attr("data-id", "content" + uid);
                                delSpan.attr("style", "position: absolute; right: 0; height: 100%; top: 0;");
                                String bId = HtmlCompareUtil.findNearestSiblingWithId(srcTd);
                                Element element = HtmlCompareUtil.getPid(targetTable.select("tr, td"), bId);
                                if (element != null) {
                                    String style = element.attr("style");
                                    element.attr("style", style + "; position: relative;");
                                    element.appendChild((Node)delSpan);
                                }
                                srcTd.attr("class", "del-class border-left3 border-top3 border-right3 border-bottom3");
                                srcTd.attr("data-type", "0");
                                srcTd.attr("data-id", "content" + uid);
                                srcTd.attr("sign", "1");
                                srcTd.attr("style", " border-color: inherit; outline: 1px solid #f53f3f; outline-offset: -1px; padding: 0;");
                            }
                        }
                        for (Element tarTd : tarTds) {
                            if (!tarTd.attr("id").isEmpty()) continue;
                            String uid = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
                            Element delSpan = new Element("div");
                            delSpan.attr("class", "add-class border-left1 border-top1 border-right1 border-bottom1");
                            delSpan.attr("data-type", "0");
                            delSpan.attr("data-id", "content" + uid);
                            delSpan.attr("style", "position: absolute; right: 0; height: 100%; top: 0;");
                            String bId = HtmlCompareUtil.findNearestSiblingWithId(tarTd);
                            Element element = HtmlCompareUtil.getPid(srcTrs.select("tr td"), bId);
                            if (element != null) {
                                String style = element.attr("style");
                                element.attr("style", style + "; position: relative;");
                                element.appendChild((Node)delSpan);
                            }
                            tarTd.attr("class", "add-class border-left1 border-top1 border-right1 border-bottom1");
                            tarTd.attr("data-type", "1");
                            tarTd.attr("data-id", "content" + uid);
                            tarTd.attr("sign", "1");
                            tarTd.attr("style", " border-color: inherit; outline: 1px solid #00b42a; outline-offset: -1px; padding: 0;");
                        }
                    }
                    if (!notFindTr) continue;
                    String uid = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
                    Element delSpan = new Element("tr");
                    delSpan.attr("class", "del-class border-left3 border-top3 border-right3 border-bottom3");
                    delSpan.attr("data-type", "1");
                    delSpan.attr("data-id", "content" + uid);
                    delSpan.attr("style", " border-color: inherit; outline: 2px solid #f53f3f; outline-offset: -1px;");
                    String bId = HtmlCompareUtil.findNearestSiblingWithId(srcTr);
                    Element element = HtmlCompareUtil.getPid(targetTable.select("tbody, tr"), bId);
                    if (element != null) {
                        if ("tbody".equals(element.tagName())) {
                            element.appendChild((Node)delSpan);
                        } else {
                            element.after((Node)delSpan);
                        }
                    }
                    srcTr.attr("class", "del-class border-left3 border-top3 border-right3 border-bottom3");
                    srcTr.attr("data-type", "0");
                    srcTr.attr("data-id", "content" + uid);
                    srcTr.attr("sign", "1");
                    for (Element td : srcTr.children()) {
                        td.attr("style", " border-color: inherit; outline: 1px solid #f53f3f; outline-offset: -1px;");
                    }
                }
                for (Element tarTr : tarTrs) {
                    if (!tarTr.attr("id").isEmpty()) continue;
                    String bId = HtmlCompareUtil.findNearestSiblingWithId(tarTr);
                    String uid = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
                    Element delSpan = new Element("tr");
                    delSpan.attr("class", "add-class border-left1 border-top1 border-right1 border-bottom1");
                    delSpan.attr("data-type", "0");
                    delSpan.attr("data-id", "content" + uid);
                    delSpan.attr("style", " border-color: inherit; outline: 2px solid #00b42a; outline-offset: -1px;");
                    Element element = HtmlCompareUtil.getPid(sourceTable.select("tbody, tr"), bId);
                    if (element != null) {
                        if ("tbody".equals(element.tagName())) {
                            element.appendChild((Node)delSpan);
                        } else {
                            element.after((Node)delSpan);
                        }
                    }
                    tarTr.attr("class", "add-class border-left1 border-top1 border-right1 border-bottom1");
                    tarTr.attr("data-type", "1");
                    tarTr.attr("data-id", "content" + uid);
                    tarTr.attr("sign", "1");
                    for (Element td : tarTr.children()) {
                        td.attr("style", " border-color: inherit; outline: 1px solid #00b42a; outline-offset: -1px;");
                    }
                }
                isFind = true;
                break;
            }
            if (isFind) continue;
            String uid = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
            if (sourceTable.parent() != null) {
                Element delSpan = new Element("p");
                delSpan.attr("class", "del-class border-left3 border-top3 border-right3 border-bottom3");
                delSpan.attr("data-type", "1");
                delSpan.attr("data-id", "content" + uid);
                StringBuilder flag = new StringBuilder();
                String bId = HtmlCompareUtil.findBrotherId(sourceTable, flag);
                if (bId != null) {
                    Element element = HtmlCompareUtil.getPid(targetPs, bId);
                    if (element != null) {
                        if ("BEFORE".contentEquals(flag)) {
                            element.after((Node)delSpan);
                        } else {
                            element.before((Node)delSpan);
                        }
                    }
                } else if (CollUtil.isNotEmpty((Collection)targetPs)) {
                    ((Element)targetTables.get(0)).before((Node)delSpan);
                } else {
                    Element body = (Element)targetPages.select("body").get(0);
                    body.children().add(0, (Object)delSpan);
                }
            }
            sourceTable.attr("class", "del-class");
            sourceTable.attr("data-type", "0");
            sourceTable.attr("data-id", "content" + uid);
            sourceTable.attr("sign", "1");
            sourceTable.attr("style", " border-color: inherit; outline: 2px solid #f53f3f; outline-offset: -1px;");
        }
    }

    public static void compareTableRevers(Elements sourcePages, Elements targetPages) {
        Elements sourceTables = sourcePages.select("table");
        Elements targetTables = targetPages.select("table");
        Elements targetPs = targetPages.select("p, h1, h2, h3, h4, h5, h6, table, tr, td");
        for (Element sourceTable : sourceTables) {
            boolean isFind = false;
            if (!sourceTable.attr("sign").isEmpty()) continue;
            HashMap<String, Object> sourceMap = HtmlCompareUtil.extractTableRows(sourceTable);
            List sourceRows = (List)sourceMap.get("rows");
            for (Element targetTable : targetTables) {
                HashMap<String, Object> targetMap;
                List targetRows;
                if (!targetTable.attr("sign").isEmpty() || !(HtmlCompareUtil.calculateTableSimilarity(sourceRows, targetRows = (List)(targetMap = HtmlCompareUtil.extractTableRows(targetTable)).get("rows")) > 0.3)) continue;
                isFind = true;
                break;
            }
            if (isFind) continue;
            long uid = SnowFlakeUtil.getFlowIdInstance().nextId();
            if (sourceTable.parent() != null) {
                Element element;
                Element delP = new Element("p");
                delP.attr("class", "add-class border-left1 border-top1 border-right1 border-bottom1");
                delP.attr("data-type", "0");
                delP.attr("data-id", "content" + uid);
                StringBuilder flag = new StringBuilder();
                String bId = HtmlCompareUtil.findBrotherId(sourceTable, flag);
                if (bId != null && (element = HtmlCompareUtil.getPid(targetPs, bId)) != null) {
                    if ("BEFORE".contentEquals(flag)) {
                        element.after((Node)delP);
                    } else {
                        element.before((Node)delP);
                    }
                }
            }
            sourceTable.attr("class", "add-class");
            sourceTable.attr("data-type", "1");
            sourceTable.attr("data-id", "content" + uid);
            sourceTable.attr("style", " border-color: inherit; outline: 2px solid #00b42a; outline-offset: -1px;");
        }
    }

    private static void setDiff(Elements sourceElements, Elements targetElements, boolean isTable) throws UnsupportedEncodingException {
        for (int i = 0; i < sourceElements.size(); ++i) {
            Object pid;
            Element sourceElement = (Element)sourceElements.get(i);
            double similar = -1.0;
            int elementIndex = 0;
            if (isTable) {
                if (sourceElement.parent() != null && "td".equals(sourceElement.parent().tagName())) continue;
                if (HtmlCompareUtil.hasOnlyOneBrChild(sourceElement, "br")) {
                    Element element = new Element("span");
                    element.attr("sign", "1");
                    sourceElement.appendChild((Node)element);
                }
                if (sourceElement.attr("class").contains("border-bottom") || !sourceElement.select("span").attr("sign").isEmpty() || HtmlCompareUtil.hasOnlyOneBrChild(sourceElement, "br") || HtmlCompareUtil.containsSdfieldTag(sourceElement)) {
                    continue;
                }
            } else if (sourceElement.attr("class").contains("border-bottom") || !sourceElement.select("span").attr("sign").isEmpty() || HtmlCompareUtil.hasOnlyOneBrChild(sourceElement, "br")) continue;
            Elements sourceImgs = sourceElement.select("img");
            String text1 = sourceElement.text();
            boolean isDiff = true;
            for (int j = 0; j < targetElements.size(); ++j) {
                Element targetElement = (Element)targetElements.get(j);
                if (isTable ? targetElement.parent() != null && "td".equals(targetElement.parent().tagName()) || targetElement.attr("class").contains("border-bottom") || !targetElement.select("span").attr("sign").isEmpty() || HtmlCompareUtil.hasOnlyOneBrChild(targetElement, "br") || HtmlCompareUtil.containsSdfieldTag(targetElement) : targetElement.attr("class").contains("border-bottom") || !targetElement.select("span").attr("sign").isEmpty() || HtmlCompareUtil.hasOnlyOneBrChild(targetElement, "br")) continue;
                Elements targetImgs = targetElement.select("img");
                if (!sourceImgs.isEmpty() && !targetImgs.isEmpty() && HtmlCompareUtil.getSamePicCountPercentage(sourceImgs, targetImgs) > 0.5) {
                    pid = UUID.randomUUID();
                    targetElement.attr("id", ((UUID)pid).toString());
                    sourceElement.attr("id", ((UUID)pid).toString());
                    HtmlCompareUtil.setPicDiff(targetElements, sourceImgs, targetImgs);
                    HtmlCompareUtil.setReversalPicDiff(sourceElements, targetImgs, sourceImgs);
                    Element element = new Element("span");
                    element.attr("sign", "1");
                    targetElement.appendChild((Node)element);
                    sourceElement.attr("sign", "1");
                    isDiff = false;
                    break;
                }
                String text2 = targetElement.text();
                double similarity = HtmlCompareUtil.similarity(text1.trim(), text2.trim());
                if (!(similarity > 0.3)) continue;
                if (isTable) {
                    Double contextSimilarity = HtmlCompareUtil.getContextSimilarity(sourceElements, targetElements, i, j, 1, 1);
                    if (contextSimilarity < 0.6 || !(contextSimilarity + similarity > similar)) continue;
                    similar = contextSimilarity + similarity;
                    elementIndex = j;
                    continue;
                }
                HtmlCompareUtil.isDiff(targetElements, sourceElement, elementIndex);
                isDiff = false;
            }
            if (similar != -1.0) {
                HtmlCompareUtil.isDiff(targetElements, sourceElement, elementIndex);
                isDiff = false;
            }
            if (!isDiff) continue;
            int previousElementInBList = HtmlCompareUtil.findPreviousElementInBList(sourceElements, targetElements, i);
            Element delSpan = new Element("p");
            delSpan.attr("class", "del-class border-left3 border-top3 border-right3 border-bottom3");
            delSpan.attr("data-type", "1");
            String uid = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
            delSpan.attr("data-id", "content" + uid);
            if (previousElementInBList >= 0) {
                ((Element)targetElements.get(previousElementInBList)).appendChild((Node)delSpan);
            }
            sourceElement.attr("class", "del-class border-left3 border-top3 border-right3 border-bottom3");
            sourceElement.attr("data-type", "0");
            sourceElement.attr("data-id", "content" + uid);
            pid = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
            sourceElement.attr("id", (String)pid);
            delSpan.attr("id", (String)pid);
        }
    }

    private static void wrapTextNodesWithSpan(Node node) {
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            String text = textNode.text();
            if (!text.trim().isEmpty()) {
                Element span = new Element("span");
                span.text(text);
                textNode.replaceWith((Node)span);
            }
        } else {
            for (Node child : node.childNodes()) {
                HtmlCompareUtil.wrapTextNodesWithSpan(child);
            }
        }
    }

    public static String extractAllText(Element element) {
        StringBuilder textBuilder = new StringBuilder();
        HtmlCompareUtil.extractTextRecursively((Node)element, textBuilder);
        return StringUtils.isEmpty((String)textBuilder.toString()) ? " " : textBuilder.toString();
    }

    private static void extractTextRecursively(Node node, StringBuilder textBuilder) {
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            textBuilder.append(textNode.text().trim());
        } else if (node instanceof Element) {
            for (Node child : node.childNodes()) {
                HtmlCompareUtil.extractTextRecursively(child, textBuilder);
            }
        }
    }

    private static void isDiff(Elements targetElements, Element sourceElement, int elementIndex) {
        String pid = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
        sourceElement.attr("id", pid);
        Element element = (Element)targetElements.get(elementIndex);
        element.attr("id", pid);
        HtmlCompareUtil.setDiff(sourceElement, element);
    }

    private static void setDiff(Element sourceElement, Element targetElement) {
        StringDiffResult result = HtmlCompareUtil.diffStrings(HtmlCompareUtil.extractAllText(sourceElement), HtmlCompareUtil.extractAllText(targetElement));
        List<HtmlElement> sourElements1 = HtmlCompareUtil.parseHtmlToElements(result.getOriginal());
        List<HtmlElement> targetElements1 = HtmlCompareUtil.parseHtmlToElements(result.getModified());
        List<HtmlElement> sourElements11 = HtmlCompareUtil.getHtmlElements(sourElements1);
        List<HtmlElement> targetElements11 = HtmlCompareUtil.getHtmlElements(targetElements1);
        ArrayList<Element> sourceLeafNodes = new ArrayList<Element>();
        HtmlCompareUtil.wrapTextNodesWithSpan((Node)sourceElement);
        HtmlCompareUtil.findLeafNodesRecursive(sourceElement, sourceLeafNodes);
        ArrayList<Element> targetLeafNodes = new ArrayList<Element>();
        HtmlCompareUtil.wrapTextNodesWithSpan((Node)targetElement);
        HtmlCompareUtil.findLeafNodesRecursive(targetElement, targetLeafNodes);
        int sourceTempInt = 0;
        int targetTempInt = 0;
        for (int n = 0; n < sourceLeafNodes.size(); ++n) {
            Element source = (Element)sourceLeafNodes.get(n);
            if (StringUtils.isEmpty((String)source.ownText()) || source.childrenSize() > 0) continue;
            String sourceText = "";
            int length = source.ownText().length();
            sourceText = n == sourceLeafNodes.size() - 1 ? HtmlCompareUtil.concatenateValuesWithPlaceholder(sourElements11, sourceTempInt, sourElements11.size(), "") : HtmlCompareUtil.concatenateValuesWithPlaceholder(sourElements11, sourceTempInt, sourceTempInt + length, "");
            source.html(sourceText);
            sourceTempInt += length;
        }
        for (int k = 0; k < targetLeafNodes.size(); ++k) {
            Element target = (Element)targetLeafNodes.get(k);
            if (StringUtils.isEmpty((String)target.ownText()) || target.childrenSize() > 0) continue;
            int length = target.ownText().length();
            String targetText = "";
            targetText = k == targetLeafNodes.size() - 1 ? HtmlCompareUtil.concatenateValuesWithPlaceholder(targetElements11, targetTempInt, targetElements11.size(), "") : HtmlCompareUtil.concatenateValuesWithPlaceholder(targetElements11, targetTempInt, targetTempInt + length, "");
            target.html(targetText);
            targetTempInt += length;
        }
    }

    public static int findPreviousElementInBList(Elements aList, Elements bList, int n) {
        int i;
        if (n <= 0 || n >= aList.size()) {
            return 0;
        }
        int index = 0;
        double distance = 0.0;
        for (i = n - 1; i >= 0; --i) {
            boolean find = false;
            Element targetElement = (Element)aList.get(i);
            if (StringUtils.isEmpty((String)targetElement.text())) continue;
            for (int m = 0; m < bList.size(); ++m) {
                double similarity;
                Element element = (Element)bList.get(m);
                if (element.parent() != null && "td".equals(element.parent().tagName()) || StringUtils.isEmpty((String)element.text()) || !((similarity = HtmlCompareUtil.similarity(targetElement.text().trim(), element.text().trim())) > 0.3)) continue;
                Double contextSimilarity = HtmlCompareUtil.getContextSimilarity(aList, bList, i, m, 0, 2);
                double tempSimilar = contextSimilarity + similarity;
                if (tempSimilar > distance) {
                    distance = tempSimilar;
                    index = m;
                }
                find = true;
            }
            if (find) break;
        }
        for (i = n + 1; i < aList.size(); ++i) {
            Element targetElement = (Element)aList.get(i);
            if (StringUtils.isEmpty((String)targetElement.text())) continue;
            for (int k = 0; k < bList.size(); ++k) {
                double similarity;
                Element element = (Element)bList.get(k);
                if (element.parent() != null && "td".equals(element.parent().tagName()) || StringUtils.isEmpty((String)element.text()) || !((similarity = HtmlCompareUtil.similarity(targetElement.text().trim(), element.text().trim())) > 0.3)) continue;
                Double contextSimilarity = HtmlCompareUtil.getContextSimilarity(aList, bList, i, k, 2, 0);
                if (contextSimilarity > distance) {
                    return k - 1;
                }
                return index;
            }
        }
        return index;
    }

    private static Double getContextSimilarity(Elements sourceElements, Elements targetElements, int sourceIndex, int targetIndex, int aboveDepth, int belowDepth) {
        Element sourceElement;
        Element targetElement;
        int i;
        double similarity = 0.0;
        for (i = 1; i <= aboveDepth; ++i) {
            if (targetElements.size() > targetIndex + i && sourceElements.size() > sourceIndex + i) {
                targetElement = (Element)targetElements.get(targetIndex + i);
                sourceElement = (Element)sourceElements.get(sourceIndex + i);
                similarity += HtmlCompareUtil.similarity(targetElement.text(), sourceElement.text());
                continue;
            }
            similarity += 0.3;
        }
        for (i = 1; i <= belowDepth; ++i) {
            if (sourceIndex - i >= 0 && targetIndex - i >= 0 && targetElements.size() > targetIndex - i && sourceElements.size() > sourceIndex - i) {
                targetElement = (Element)targetElements.get(targetIndex - i);
                sourceElement = (Element)sourceElements.get(sourceIndex - i);
                similarity += HtmlCompareUtil.similarity(targetElement.text(), sourceElement.text());
                continue;
            }
            similarity += 0.3;
        }
        return similarity;
    }

    private static void findLeafNodesRecursive(Element element, List<Element> leafNodes) {
        if (StringUtils.isEmpty((Collection)element.children())) {
            leafNodes.add(element);
        } else {
            for (Element child : element.children()) {
                HtmlCompareUtil.findLeafNodesRecursive(child, leafNodes);
            }
        }
    }

    private static void setReversalDiff(Elements sourceElements, Elements targetElements, boolean isTable) throws UnsupportedEncodingException {
        for (int i = 0; i < sourceElements.size(); ++i) {
            Element sourceElement = (Element)sourceElements.get(i);
            if (isTable ? sourceElement.parent() != null && "td".equals(sourceElement.parent().tagName()) || !sourceElement.select("span").attr("sign1").isEmpty() || HtmlCompareUtil.hasOnlyOneBrChild(sourceElement, "br") || HtmlCompareUtil.containsSdfieldTag(sourceElement) : !sourceElement.select("span").attr("sign1").isEmpty() || HtmlCompareUtil.hasOnlyOneBrChild(sourceElement, "br")) continue;
            Elements sourceImgs = sourceElement.select("img");
            String text1 = sourceElement.text();
            boolean isDiff = true;
            for (int j = 0; j < targetElements.size(); ++j) {
                Double contextSimilarity;
                Element targetElement = (Element)targetElements.get(j);
                if (isTable ? targetElement.parent() != null && "td".equals(targetElement.parent().tagName()) || !targetElement.select("span").attr("sign1").isEmpty() || HtmlCompareUtil.hasOnlyOneBrChild(targetElement, "br") || HtmlCompareUtil.containsSdfieldTag(targetElement) : !targetElement.select("span").attr("sign1").isEmpty() || HtmlCompareUtil.hasOnlyOneBrChild(targetElement, "br")) continue;
                Elements targetImgs = targetElement.select("img");
                if (!sourceImgs.isEmpty() && !targetImgs.isEmpty() && HtmlCompareUtil.getSamePicCountPercentage(sourceImgs, targetImgs) > 0.5) {
                    HtmlCompareUtil.setPicDiff(targetElements, sourceImgs, targetImgs);
                    HtmlCompareUtil.setReversalPicDiff(sourceElements, targetImgs, sourceImgs);
                    Element element = new Element("span");
                    element.attr("sign1", "1");
                    targetElement.appendChild((Node)element);
                    sourceElement.attr("sign1", "1");
                    isDiff = false;
                    break;
                }
                String text2 = targetElement.text();
                if (!(HtmlCompareUtil.similarity(text1.trim(), text2.trim()) > 0.3) || isTable && (contextSimilarity = HtmlCompareUtil.getContextSimilarity(sourceElements, targetElements, i, j, 1, 1)) < 0.7) continue;
                Element element = new Element("span");
                element.attr("sign1", "1");
                targetElement.appendChild((Node)element);
                sourceElement.attr("sign1", "1");
                isDiff = false;
                break;
            }
            if (!isDiff) continue;
            int previousElementInBList = HtmlCompareUtil.findPreviousElementInBList(sourceElements, targetElements, i);
            Element delSpan = new Element("p");
            delSpan.attr("class", "border-right add-class border-left1 border-top1 border-right1 border-bottom1");
            delSpan.attr("data-type", "0");
            String uid = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
            delSpan.attr("data-id", "content" + uid);
            if (previousElementInBList >= 0) {
                ((Element)targetElements.get(previousElementInBList)).appendChild((Node)delSpan);
            }
            sourceElement.attr("class", "border-right add-class border-left1 border-top1 border-right1 border-bottom1");
            sourceElement.attr("data-type", "1");
            sourceElement.attr("data-id", "content" + uid);
            String pid = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
            sourceElement.attr("id", pid);
            delSpan.attr("id", pid);
        }
    }

    private static double getSamePicCountPercentage(Elements sourceImgs, Elements targetImgs) throws UnsupportedEncodingException {
        int samePicCount = 0;
        for (Element sourceImg : sourceImgs) {
            String sourceSrc = URLDecoder.decode(sourceImg.attr("src"), "UTF-8");
            for (Element targetImg : targetImgs) {
                String targetSrc = URLDecoder.decode(targetImg.attr("src"), "UTF-8");
                if (!(ImageSimilarity.getImageSimilarly(sourceSrc, targetSrc) > 0.9)) continue;
                ++samePicCount;
            }
        }
        return (double)samePicCount / (double)sourceImgs.size();
    }

    private static void setPicDiff(Elements targetElements, Elements sourceImgs, Elements targetImgs) throws UnsupportedEncodingException {
        for (Element sourceImg : sourceImgs) {
            boolean isFindPic = false;
            String sourceSrc = URLDecoder.decode(sourceImg.attr("src"), "UTF-8");
            for (Element targetImg : targetImgs) {
                String targetSrc = URLDecoder.decode(targetImg.attr("src"), "UTF-8");
                if (!(ImageSimilarity.getImageSimilarly(sourceSrc, targetSrc) > 0.9)) continue;
                sourceImg.before((Node)new Element("span"));
                targetImg.before((Node)new Element("span"));
                isFindPic = true;
                break;
            }
            if (isFindPic) continue;
            String uid = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
            if (sourceImg.parent() != null) {
                Element delSpan = new Element("span");
                delSpan.attr("class", "del-class border-left3 border-top3 border-right3 border-bottom3");
                delSpan.attr("data-type", "1");
                delSpan.attr("data-id", "content" + uid);
                String id = sourceImg.parent().attr("id");
                Element pid = HtmlCompareUtil.getPid(targetElements, id);
                if (pid != null) {
                    pid.appendChild((Node)delSpan);
                }
            }
            sourceImg.attr("class", "del-class border-left3 border-top3 border-right3 border-bottom3");
            sourceImg.attr("data-type", "0");
            sourceImg.attr("data-id", "content" + uid);
        }
    }

    private static void setReversalPicDiff(Elements targetElements, Elements sourceImgs, Elements targetImgs) throws UnsupportedEncodingException {
        for (Element sourceImg : sourceImgs) {
            boolean isFindPic = false;
            String sourceSrc = URLDecoder.decode(sourceImg.attr("src"), "UTF-8");
            for (Element targetImg : targetImgs) {
                String targetSrc = URLDecoder.decode(targetImg.attr("src"), "UTF-8");
                if (!(ImageSimilarity.getImageSimilarly(sourceSrc, targetSrc) > 0.9)) continue;
                isFindPic = true;
                break;
            }
            if (isFindPic) continue;
            String uid = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
            if (sourceImg.parent() != null) {
                Element delSpan = new Element("span");
                delSpan.attr("class", "add-class border-left1 border-top1 border-right1 border-bottom1");
                delSpan.attr("data-type", "0");
                delSpan.attr("data-id", "content" + uid);
                String id = sourceImg.parent().attr("id");
                Element pid = HtmlCompareUtil.getPid(targetElements, id);
                if (pid != null) {
                    pid.appendChild((Node)delSpan);
                }
            }
            sourceImg.attr("class", "add-class border-left1 border-top1 border-right1 border-bottom1");
            sourceImg.attr("data-type", "1");
            sourceImg.attr("data-id", "content" + uid);
        }
    }

    private static HashMap<String, Object> extractTableRows(Element table) {
        ArrayList<String> rows = new ArrayList<String>();
        Elements trs = table.select("tr");
        for (Element tr : trs) {
            Elements tds = tr.select("td");
            for (Element td : tds) {
                rows.add(td.text().trim());
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("rows", rows);
        result.put("trs", trs.size());
        return result;
    }

    public static double calculateTableSimilarity(List<String> list1, List<String> list2) {
        if (list1 == null || list2 == null) {
            throw new IllegalArgumentException("Lists cannot be null");
        }
        int minSize = Math.min(list1.size(), list2.size());
        int sameCount = 0;
        int nonEmptyCount = 0;
        for (int i = 0; i < minSize; ++i) {
            String str1 = list1.get(i);
            String str2 = list2.get(i);
            if (str1.isEmpty() && str2.isEmpty()) continue;
            ++nonEmptyCount;
            if (!str1.equals(str2)) continue;
            ++sameCount;
        }
        if (nonEmptyCount == 0) {
            return 1.0;
        }
        return (double)sameCount / (double)nonEmptyCount;
    }

    public static double similarity(String s, String t) {
        if (StringUtils.isEmpty((String)s) && StringUtils.isEmpty((String)t)) {
            return 1.0;
        }
        int distance = HtmlCompareUtil.levenshteinDistance(s, t);
        int maxLength = Math.max(s.length(), t.length());
        return (double)(maxLength - distance) / (double)maxLength;
    }

    public static int levenshteinDistance(String s, String t) {
        int i;
        int m = s.length();
        int n = t.length();
        int[][] d = new int[m + 1][n + 1];
        for (i = 0; i <= m; ++i) {
            d[i][0] = i;
        }
        for (int j = 0; j <= n; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                int cost = s.charAt(i - 1) == t.charAt(j - 1) ? 0 : 1;
                d[i][j] = Math.min(Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1), d[i - 1][j - 1] + cost);
            }
        }
        return d[m][n];
    }

    public static StringDiffResult diffStrings(String s1, String s2) {
        int m = s1.length();
        int n = s2.length();
        int[][] dp = new int[m + 1][n + 1];
        for (int i = 0; i <= m; ++i) {
            for (int j = 0; j <= n; ++j) {
                dp[i][j] = i == 0 || j == 0 ? 0 : (s1.charAt(i - 1) == s2.charAt(j - 1) ? dp[i - 1][j - 1] + 1 : Math.max(dp[i - 1][j], dp[i][j - 1]));
            }
        }
        StringBuilder lcs = new StringBuilder();
        int i = m;
        int j = n;
        while (i > 0 && j > 0) {
            if (s1.charAt(i - 1) == s2.charAt(j - 1)) {
                lcs.append(s1.charAt(i - 1));
                --i;
                --j;
                continue;
            }
            if (dp[i - 1][j] > dp[i][j - 1]) {
                --i;
                continue;
            }
            --j;
        }
        lcs.reverse();
        StringBuilder original = new StringBuilder();
        StringBuilder modified = new StringBuilder();
        i = 0;
        j = 0;
        int k = 0;
        while (i < m && j < n) {
            if (s1.charAt(i) == s2.charAt(j)) {
                original.append(s1.charAt(i));
                modified.append(s2.charAt(j));
                ++i;
                ++j;
                ++k;
                continue;
            }
            long id = SnowFlakeUtil.getFlowIdInstance().nextId();
            if (k < lcs.length() && s1.charAt(i) == lcs.charAt(k)) {
                modified.append("<span class=\"add-class border-top1 border-bottom1 border-left1\" data-type=\"1\" data-id=\"").append(id).append("\">").append(s2.charAt(j)).append("</span>");
                original.append("<span class=\"add-class border-top1 border-bottom1 border-left1\" data-type=\"0\" data-id=\"").append(id).append("\"></span>");
                ++j;
                continue;
            }
            if (k < lcs.length() && s2.charAt(j) == lcs.charAt(k)) {
                original.append("<span class=\"del-class border-top3 border-bottom3 border-left3\" data-type=\"0\" data-id=\"").append(id).append("\">").append(s1.charAt(i)).append("</span>");
                modified.append("<span class=\"del-class border-top3 border-bottom3 border-left3\" data-type=\"1\" data-id=\"").append(id).append("\"></span>");
                ++i;
                continue;
            }
            original.append("<span class=\"change-class border-top2 border-bottom2 border-left2\" data-type=\"0\" data-id=\"").append(id).append("\">").append(s1.charAt(i)).append("</span>");
            modified.append("<span class=\"change-class border-top2 border-bottom2 border-left2\" data-type=\"1\" data-id=\"").append(id).append("\">").append(s2.charAt(j)).append("</span>");
            ++i;
            ++j;
        }
        while (i < m) {
            String id = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
            original.append("<span class=\"del-class border-top3 border-bottom3 border-left3\" data-type=\"0\" data-id=\"").append(id).append("\">").append(s1.charAt(i)).append("</span>");
            modified.append("<span class=\"del-class border-top3 border-bottom3 border-left3\" data-type=\"1\" data-id=\"").append(id).append("\"></span>");
            ++i;
        }
        while (j < n) {
            String id = String.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId());
            original.append("<span class=\"add-class border-top1 border-bottom1 border-left1\" data-type=\"0\" data-id=\"").append(id).append("\"></span>");
            modified.append("<span class=\"add-class border-top1 border-bottom1 border-left1\" data-type=\"1\" data-id=\"").append(id).append("\">").append(s2.charAt(j)).append("</span>");
            ++j;
        }
        return new StringDiffResult(original.append("<span sign=\"1\"></span>").toString(), modified.append("<span sign=\"1\"></span>").toString());
    }

    public static List<HtmlElement> getHtmlElements(List<HtmlElement> elements) {
        ArrayList<HtmlElement> htmlElementTemp = new ArrayList<HtmlElement>();
        ArrayList<HtmlElement> htmlElementCopy = new ArrayList<HtmlElement>();
        boolean modFlag = false;
        String dataId = "";
        String className = "";
        for (HtmlElement element : elements) {
            if (element.isHasTag() && StringUtils.isNotEmpty((String)element.getClassName()) && StringUtils.isNotEmpty((String)element.getDataId())) {
                if (StringUtils.isNotEmpty((String)className) && StringUtils.isNotEmpty((String)element.getClassName()) && !element.getClassName().equals(className)) {
                    modFlag = true;
                }
                className = element.getClassName();
                dataId = "content" + element.getDataId();
                htmlElementTemp.add(element);
                continue;
            }
            if (StringUtils.isNotEmpty(htmlElementTemp) && StringUtils.isNotEmpty((String)className)) {
                HtmlCompareUtil.htmlHandler(className, modFlag, htmlElementTemp, dataId);
                htmlElementCopy.addAll(htmlElementTemp);
                modFlag = false;
                dataId = "";
                className = "";
                htmlElementTemp.clear();
            }
            htmlElementCopy.add(element);
        }
        if (StringUtils.isNotEmpty(htmlElementTemp)) {
            HtmlCompareUtil.htmlHandler(className, modFlag, htmlElementTemp, dataId);
            htmlElementCopy.addAll(htmlElementTemp);
        }
        return htmlElementCopy;
    }

    private static void htmlHandler(String className, boolean modFlag, List<HtmlElement> htmlElementTemp, String dataId) {
        block16: {
            block17: {
                block15: {
                    if (!modFlag && !"change-class border-top2 border-bottom2 border-left2".equals(className)) break block15;
                    for (int i = 0; i < htmlElementTemp.size(); ++i) {
                        Elements mod;
                        HtmlElement htmlElement = htmlElementTemp.get(i);
                        if (StringUtils.isEmpty((String)dataId)) {
                            dataId = htmlElement.getDataId();
                        }
                        if (htmlElementTemp.size() == 1) {
                            htmlElement.setClassName("change-class border-top2 border-bottom2 border-right2 border-left2");
                            mod = Jsoup.parse((String)htmlElement.getContent()).select("span").attr("class", "change-class border-top2 border-bottom2 border-right2 border-left2").attr("data-id", dataId);
                            htmlElement.setContent(mod.toString());
                            htmlElement.setDataId(dataId);
                            continue;
                        }
                        if (i == 0) {
                            htmlElement.setClassName("change-class border-top2 border-bottom2 border-left2");
                            mod = Jsoup.parse((String)htmlElement.getContent()).select("span").attr("class", "change-class border-top2 border-bottom2 border-left2").attr("data-id", dataId);
                            htmlElement.setContent(mod.toString());
                            htmlElement.setDataId(dataId);
                            continue;
                        }
                        if (i == htmlElementTemp.size() - 1) {
                            htmlElement.setClassName("change-class border-top2 border-bottom2 border-right2");
                            mod = Jsoup.parse((String)htmlElement.getContent()).select("span").attr("class", "change-class border-top2 border-bottom2 border-right2").attr("data-id", dataId);
                            htmlElement.setContent(mod.toString());
                            htmlElement.setDataId(dataId);
                            continue;
                        }
                        htmlElement.setClassName("change-class border-top2 border-bottom2");
                        mod = Jsoup.parse((String)htmlElement.getContent()).select("span").attr("class", "change-class border-top2 border-bottom2").attr("data-id", dataId);
                        htmlElement.setContent(mod.toString());
                        htmlElement.setDataId(dataId);
                    }
                    break block16;
                }
                if (!"del-class border-top3 border-bottom3 border-left3".equals(className)) break block17;
                for (int i = 0; i < htmlElementTemp.size(); ++i) {
                    Elements mod;
                    HtmlElement htmlElement = htmlElementTemp.get(i);
                    if (StringUtils.isEmpty((String)dataId)) {
                        dataId = htmlElement.getDataId();
                    }
                    if (htmlElementTemp.size() == 1) {
                        htmlElement.setClassName("del-class border-top3 border-bottom3 border-right3 border-left3");
                        mod = Jsoup.parse((String)htmlElement.getContent()).select("span").attr("class", "del-class border-top3 border-bottom3 border-right3 border-left3").attr("data-id", dataId);
                        htmlElement.setContent(mod.toString());
                        htmlElement.setDataId(dataId);
                        continue;
                    }
                    if (i == 0) {
                        htmlElement.setClassName("del-class border-top3 border-bottom3 border-left3");
                        mod = Jsoup.parse((String)htmlElement.getContent()).select("span").attr("class", "del-class border-top3 border-bottom3 border-left3").attr("data-id", dataId);
                        htmlElement.setContent(mod.toString());
                        htmlElement.setDataId(dataId);
                        continue;
                    }
                    if (i == htmlElementTemp.size() - 1) {
                        htmlElement.setClassName("del-class border-top3 border-bottom3 border-right3");
                        mod = Jsoup.parse((String)htmlElement.getContent()).select("span").attr("class", "del-class border-top3 border-bottom3 border-right3").attr("data-id", dataId);
                        htmlElement.setContent(mod.toString());
                        htmlElement.setDataId(dataId);
                        continue;
                    }
                    htmlElement.setClassName("del-class border-top3 border-bottom3");
                    mod = Jsoup.parse((String)htmlElement.getContent()).select("span").attr("class", "del-class border-top3 border-bottom3").attr("data-id", dataId);
                    htmlElement.setContent(mod.toString());
                    htmlElement.setDataId(dataId);
                }
                break block16;
            }
            if (!"add-class border-top1 border-bottom1 border-left1".equals(className)) break block16;
            for (int i = 0; i < htmlElementTemp.size(); ++i) {
                Elements mod;
                HtmlElement htmlElement = htmlElementTemp.get(i);
                if (StringUtils.isEmpty((String)dataId)) {
                    dataId = htmlElement.getDataId();
                }
                if (htmlElementTemp.size() == 1) {
                    htmlElement.setClassName("add-class border-top1 border-bottom1 border-right1 border-left1");
                    mod = Jsoup.parse((String)htmlElement.getContent()).select("span").attr("class", "add-class border-top1 border-bottom1 border-right1 border-left1").attr("data-id", dataId);
                    htmlElement.setContent(mod.toString());
                    htmlElement.setDataId(dataId);
                    continue;
                }
                if (i == 0) {
                    htmlElement.setClassName("add-class border-top1 border-bottom1 border-left1");
                    mod = Jsoup.parse((String)htmlElement.getContent()).select("span").attr("class", "add-class border-top1 border-bottom1 border-left1").attr("data-id", dataId);
                    htmlElement.setContent(mod.toString());
                    htmlElement.setDataId(dataId);
                    continue;
                }
                if (i == htmlElementTemp.size() - 1) {
                    htmlElement.setClassName("add-class border-top1 border-bottom1 border-right1");
                    mod = Jsoup.parse((String)htmlElement.getContent()).select("span").attr("class", "add-class border-top1 border-bottom1 border-right1").attr("data-id", dataId);
                    htmlElement.setContent(mod.toString());
                    htmlElement.setDataId(dataId);
                    continue;
                }
                htmlElement.setClassName("add-class border-top1 border-bottom1");
                mod = Jsoup.parse((String)htmlElement.getContent()).select("span").attr("class", "add-class border-top1 border-bottom1").attr("data-id", dataId);
                htmlElement.setContent(mod.toString());
                htmlElement.setDataId(dataId);
            }
        }
    }

    public static List<HtmlElement> parseHtmlToElements(String html) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        Pattern pattern = Pattern.compile("(<span[^>]*>([^<]*)</span>)|([^<])");
        Matcher matcher = pattern.matcher(html);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                String spanContent = matcher.group(1);
                String innerText = matcher.group(2);
                String className = "";
                String dataType = "";
                String dataId = "";
                Pattern attrPattern = Pattern.compile("class\\s*=\\s*\"([^\"]+)\"");
                Matcher attrMatcher = attrPattern.matcher(spanContent);
                if (attrMatcher.find()) {
                    className = attrMatcher.group(1);
                }
                if ((attrMatcher = (attrPattern = Pattern.compile("data-type\\s*=\\s*\"([^\"]+)\"")).matcher(spanContent)).find()) {
                    dataType = attrMatcher.group(1);
                }
                if ((attrMatcher = (attrPattern = Pattern.compile("data-id\\s*=\\s*\"([^\"]+)\"")).matcher(spanContent)).find()) {
                    dataId = attrMatcher.group(1);
                }
                elements.add(new HtmlElement(spanContent, true, className, dataType, dataId, innerText));
                continue;
            }
            if (matcher.group(3) == null) continue;
            String charContent = matcher.group(3);
            elements.add(new HtmlElement(charContent, false, "", "", "", charContent));
        }
        return elements;
    }

    public static boolean hasOnlyOneBrChild(Element element, String tagName) {
        Elements children = element.children();
        for (Element child : children) {
            if (tagName.equalsIgnoreCase(child.tagName())) continue;
            return false;
        }
        return !children.isEmpty();
    }

    public static boolean containsSdfieldTag(Element element) {
        if ("sdfield".equalsIgnoreCase(element.tagName())) {
            return true;
        }
        for (Element child : element.children()) {
            if (!HtmlCompareUtil.containsSdfieldTag(child)) continue;
            return true;
        }
        return false;
    }

    public static class StringDiffResult {
        private final String original;
        private final String modified;

        public StringDiffResult(String original, String modified) {
            this.original = original;
            this.modified = modified;
        }

        public String getOriginal() {
            return this.original;
        }

        public String getModified() {
            return this.modified;
        }
    }
}

