/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.comparator.impl;

import com.jxdinfo.idp.common.pdfparser.core.PdfParser;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.pdfparser.tools.FileTool;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.comparator.impl.AbstractComparator;
import com.jxdinfo.idp.compare.comparator.util.HtmlCompareUtil;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import com.jxdinfo.idp.compare.entity.po.CompareTaskHtml;
import com.jxdinfo.idp.compare.service.CompareTaskHtmlService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Html2HtmlComparator
extends AbstractComparator<Document, Document> {
    private static final Logger log = LoggerFactory.getLogger(Html2HtmlComparator.class);
    @Autowired
    private CompareTaskHtmlService htmlService;

    public Html2HtmlComparator() {
        super(DocumentComparatorEnum.HTML2HTML);
    }

    @Override
    public List<CompareResult> compare(Document reference, Document compare) {
        return null;
    }

    public List<CompareResult> compare(Long taskId, Document reference, Document compare) {
        ArrayList<CompareResult> compareResults = new ArrayList<CompareResult>();
        LinkedHashMap<Long, StringBuilder> rMap = new LinkedHashMap<Long, StringBuilder>();
        LinkedHashMap<Long, StringBuilder> cMap = new LinkedHashMap<Long, StringBuilder>();
        try {
            CompareResult compareResult;
            CompareTaskHtml htmlInfo = HtmlCompareUtil.compareHtml(reference, compare);
            htmlInfo.setTaskId(taskId);
            Document refHtml = htmlInfo.getRefHtml();
            htmlInfo.setRefHtmlStr(refHtml.html());
            Document compHtml = htmlInfo.getCompHtml();
            htmlInfo.setCompHtmlStr(compHtml.html());
            this.htmlService.save(htmlInfo);
            Elements refElements = refHtml.getAllElements();
            for (Element element : refElements) {
                Long id = this.getId(element);
                if (id == null) continue;
                StringBuilder text = rMap.computeIfAbsent(id, k -> new StringBuilder());
                text.append(element.text());
            }
            Elements compElements = compHtml.getAllElements();
            for (Element element : compElements) {
                Long id = this.getId(element);
                if (id == null) continue;
                StringBuilder text = cMap.computeIfAbsent(id, k -> new StringBuilder());
                text.append(element.text());
            }
            for (Map.Entry entry : rMap.entrySet()) {
                compareResult = new CompareResult();
                compareResult.setId((Long)entry.getKey());
                compareResult.setCategory("table");
                compareResult.setReferenceContent(((StringBuilder)entry.getValue()).toString());
                StringBuilder comText = (StringBuilder)cMap.remove(entry.getKey());
                if (comText != null) {
                    compareResult.setCompareContent(comText.toString());
                }
                compareResults.add(compareResult);
            }
            for (Map.Entry entry : cMap.entrySet()) {
                compareResult = new CompareResult();
                compareResult.setId((Long)entry.getKey());
                compareResult.setCategory("table");
                compareResult.setCompareContent(((StringBuilder)entry.getValue()).toString());
                compareResults.add(compareResult);
            }
        }
        catch (IOException e) {
            log.error("\u8868\u683c\u5bf9\u6bd4\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        return compareResults;
    }

    private Long getId(Element element) {
        String contentId = element.attr("data-id");
        if (contentId.isEmpty()) {
            return null;
        }
        String id = contentId.replace("content", "");
        return Long.valueOf(id);
    }

    public static void main(String[] args) throws IOException {
        Html2HtmlComparator comparator = new Html2HtmlComparator();
        PDDocument reference = PDDocument.load((File)new File("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24020004\u5173\u4e8e\u5168\u6d41\u7a0b\u667a\u80fd\u5de5\u5382\u914d\u5957\u5750\u5e2d\u7cfb\u7edf\u9879\u76ee\\2.ZF3G24020004\u62db\u6807\u6280\u672f\u9644\u4ef6.pdf"));
        PDDocument compare = PDDocument.load((File)new File("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24020004\u5173\u4e8e\u5168\u6d41\u7a0b\u667a\u80fd\u5de5\u5382\u914d\u5957\u5750\u5e2d\u7cfb\u7edf\u9879\u76ee\\4.ZF3G24020004\u7b7e\u7ae0\u6280\u672f\u9644\u4ef6.pdf"));
        ContentPojo refPojo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)reference, (boolean)true);
        ContentPojo compPojo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)compare, (boolean)true);
        List<CompareResult> compare1 = comparator.compare(FileTool.table2Html((ContentPojo)refPojo), FileTool.table2Html((ContentPojo)compPojo));
        System.out.println("end");
    }
}

