/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.comparator.dto;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;

public class ImageSimilarity {
    public static void main(String[] args) {
        String imagePath1 = "D:\\test\\\u5bf9\u6bd4\u5e26\u56fe12_html_a52cb483f51e3484.jpg";
        String imagePath2 = "D:\\test\\\u539f\u5e26\u56fe12_html_4ad2ed536cb7bd1d.jpg";
        double imageSimilary = ImageSimilarity.getImageSimilarly(imagePath1, imagePath2);
        System.out.println("Image similarity (Cosine Similarity): " + imageSimilary);
    }

    public static double getImageSimilarly(String sourceImagePath, String targetImagePath) {
        String path = "";
        try {
            BufferedImage image1 = ImageIO.read(new File(path + sourceImagePath));
            BufferedImage image2 = ImageIO.read(new File(path + targetImagePath));
            if (image1 == null || image2 == null) {
                System.out.println("Could not read one or both images.");
                return 0.0;
            }
            image1 = Thumbnails.of((BufferedImage[])new BufferedImage[]{image1}).size(64, 128).asBufferedImage();
            image2 = Thumbnails.of((BufferedImage[])new BufferedImage[]{image2}).size(64, 128).asBufferedImage();
            double[] histogram1 = ImageSimilarity.calculateColorHistogram(image1);
            double[] histogram2 = ImageSimilarity.calculateColorHistogram(image2);
            return ImageSimilarity.calculateCosineSimilarity(histogram1, histogram2);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static double[] calculateColorHistogram(BufferedImage image) {
        int bins = 256;
        int[] redHistogram = new int[bins];
        int[] greenHistogram = new int[bins];
        int[] blueHistogram = new int[bins];
        int width = image.getWidth();
        int height = image.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = image.getRGB(x, y);
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                int n = red;
                redHistogram[n] = redHistogram[n] + 1;
                int n2 = green;
                greenHistogram[n2] = greenHistogram[n2] + 1;
                int n3 = blue;
                blueHistogram[n3] = blueHistogram[n3] + 1;
            }
        }
        double[] normalizedHistogram = new double[bins * 3];
        int totalPixels = width * height;
        for (int i = 0; i < bins; ++i) {
            normalizedHistogram[i] = (double)redHistogram[i] / (double)totalPixels;
            normalizedHistogram[i + bins] = (double)greenHistogram[i] / (double)totalPixels;
            normalizedHistogram[i + 2 * bins] = (double)blueHistogram[i] / (double)totalPixels;
        }
        return normalizedHistogram;
    }

    public static double calculateEuclideanDistance(double[] histogram1, double[] histogram2) {
        double sum = 0.0;
        for (int i = 0; i < histogram1.length; ++i) {
            sum += Math.pow(histogram1[i] - histogram2[i], 2.0);
        }
        return Math.sqrt(sum);
    }

    public static double calculateCosineSimilarity(double[] histogram1, double[] histogram2) {
        double dotProduct = 0.0;
        double normA = 0.0;
        double normB = 0.0;
        for (int i = 0; i < histogram1.length; ++i) {
            dotProduct += histogram1[i] * histogram2[i];
            normA += Math.pow(histogram1[i], 2.0);
            normB += Math.pow(histogram2[i], 2.0);
        }
        return dotProduct / (Math.sqrt(normA) * Math.sqrt(normB));
    }
}

