/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.comparator.impl;

import com.jxdinfo.idp.common.pdfparser.core.PdfParser;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.comparator.impl.AbstractComparator;
import com.jxdinfo.idp.compare.entity.comparator.TextInfo;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PDF2PDFComparator
extends AbstractComparator<ContentPojo, ContentPojo> {
    private static final Logger log = LoggerFactory.getLogger(PDF2PDFComparator.class);

    public PDF2PDFComparator() {
        super(DocumentComparatorEnum.PDF2PDF);
    }

    @Override
    public List<CompareResult> compare(ContentPojo reference, ContentPojo compare) {
        StringBuilder referenceText = new StringBuilder();
        StringBuilder compareText = new StringBuilder();
        List<TextInfo> referenceTexts = this.getTextInfoAndAppendText(reference, referenceText);
        List<TextInfo> compareTexts = this.getTextInfoAndAppendText(compare, compareText);
        return this.parasCompare(referenceTexts, compareTexts);
    }

    private List<TextInfo> getTextInfoAndAppendText(ContentPojo pdfInfo, StringBuilder text) {
        ArrayList<TextInfo> textInfos = new ArrayList<TextInfo>();
        List outList = pdfInfo.getOutList();
        ContentPojo.contentElement prevElement = null;
        for (ContentPojo.contentElement element : outList) {
            if (Objects.nonNull(prevElement) && ("text".equals(prevElement.getElementType()) || "title".equals(prevElement.getElementType())) && !this.isCatalog(prevElement.getText())) {
                if ("table".equals(element.getElementType()) || "pic".equals(element.getElementType()) || this.isCatalog(element.getText())) {
                    textInfos.add(new TextInfo(prevElement.getPageNumber(), prevElement.getText(), false));
                } else {
                    textInfos.add(new TextInfo(prevElement.getPageNumber(), prevElement.getText()));
                }
            }
            if (("text".equals(element.getElementType()) || "title".equals(element.getElementType())) && !this.isCatalog(element.getText())) {
                String cleanedText = element.getText().replaceAll("[ \\n]+", "");
                text.append(cleanedText);
                element.setText(cleanedText);
            }
            prevElement = element;
        }
        if (prevElement != null && ("text".equals(prevElement.getElementType()) || "title".equals(prevElement.getElementType()))) {
            textInfos.add(new TextInfo(prevElement.getPageNumber(), prevElement.getText()));
        }
        return textInfos;
    }

    public static void main(String[] args) throws Exception {
        File file = new File("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u6587\u6863\u5bf9\u6bd4\\\u65e5\u94a2\u73b0\u573a\\3\\\u9644\u4ef61\uff1a\u516c\u7528\u8bbe\u65bd\u5904\u71c3\u6c14\u53d1\u7535\u5de5\u573a\u8131\u785d\u9879\u76ee\u6280\u672f\u534f\u8bae.pdf");
        PDDocument referencePdf = PDDocument.load((File)file);
        ContentPojo referenceInfo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)referencePdf, (boolean)true);
        PDDocument comparePdf = PDDocument.load((File)new File("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u6587\u6863\u5bf9\u6bd4\\\u65e5\u94a2\u73b0\u573a\\3\\\u516c\u7528\u8bbe\u65bd\u5904\u71c3\u6c14\u53d1\u7535\u5de5\u573a\u8131\u785d\u9879\u76ee\u6280\u672f\u534f\u8bae.pdf"));
        ContentPojo compareInfo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)comparePdf, (boolean)true);
        PDF2PDFComparator comparator = new PDF2PDFComparator();
        List<CompareResult> results = comparator.compare(referenceInfo, compareInfo);
        results.removeIf(CompareResult2 -> StringUtils.isBlank((CharSequence)CompareResult2.getReferenceContent()) && StringUtils.isBlank((CharSequence)CompareResult2.getCompareContent()));
        System.out.println("end");
    }
}

