/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.comparator.impl;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Cell;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.PdfInfo;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Table;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.TextBlock;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.docparse.ReadPdfUtil;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.comparator.impl.AbstractComparator;
import com.jxdinfo.idp.compare.entity.comparator.TableCellInfo;
import com.jxdinfo.idp.compare.entity.comparator.TableInfo;
import com.jxdinfo.idp.compare.entity.comparator.TextInfo;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PDF2PDFPythonComparator
extends AbstractComparator<PdfInfo, PdfInfo> {
    private static final Logger log = LoggerFactory.getLogger(PDF2PDFPythonComparator.class);

    public PDF2PDFPythonComparator() {
        super(DocumentComparatorEnum.PDF2PDF_PYTHON);
    }

    @Override
    public List<CompareResult> compare(PdfInfo reference, PdfInfo compare) {
        ArrayList<CompareResult> results = new ArrayList<CompareResult>();
        if (reference == null || compare == null) {
            return results;
        }
        if (CollUtil.isNotEmpty((Collection)reference.getTextBlocks()) && CollUtil.isNotEmpty((Collection)compare.getTextBlocks())) {
            List<TextInfo> refTextInfos = this.block2textInfo(reference.getTextBlocks());
            List<TextInfo> compTextInfos = this.block2textInfo(compare.getTextBlocks());
            results.addAll(this.parasCompare(refTextInfos, compTextInfos));
        }
        if (CollUtil.isNotEmpty((Collection)reference.getTables()) && CollUtil.isNotEmpty((Collection)compare.getTables())) {
            List<TableInfo> refTableInfos = this.table2tableInfo(reference.getTables());
            List<TableInfo> compTableInfos = this.table2tableInfo(compare.getTables());
            results.addAll(this.tablesCompare(refTableInfos, compTableInfos));
        }
        return results;
    }

    private List<TextInfo> block2textInfo(List<TextBlock> textBlocks) {
        ArrayList<TextInfo> textInfos = new ArrayList<TextInfo>();
        for (TextBlock block : textBlocks) {
            if (!StringUtils.isNotEmpty((String)block.getText()) || this.isCatalog(block.getText())) continue;
            String cleanText = block.getText().replaceAll("[ \\n]+", "");
            TextInfo textInfo = new TextInfo(block.getPagenum(), cleanText);
            textInfos.add(textInfo);
        }
        return textInfos;
    }

    private List<TableInfo> table2tableInfo(List<Table> tables) {
        tables.removeIf(table -> StringUtils.isEmpty((Collection)table.getCells()));
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
        for (Table table2 : tables) {
            TableInfo tableInfo = new TableInfo();
            tableInfo.setIndex(table2.getIndex());
            tableInfo.setPageNum(table2.getPagenum());
            tableInfo.setCells2D(this.cells2cells2D(table2));
            tableInfos.add(tableInfo);
        }
        return tableInfos;
    }

    private TableCellInfo[][] cells2cells2D(Table table) {
        int y = 0;
        boolean x = false;
        ArrayList<TableCellInfo> cellInfos = new ArrayList<TableCellInfo>();
        ArrayList<TableCellInfo[]> cellInfos2DList = new ArrayList<TableCellInfo[]>();
        for (Cell cell : table.getCells()) {
            if (cell.getRow() == y) {
                cellInfos.add(this.cell2CellInfo(table, cell));
                continue;
            }
            cellInfos2DList.add(cellInfos.toArray(new TableCellInfo[0]));
            y = cell.getRow();
            cellInfos = new ArrayList();
            cellInfos.add(this.cell2CellInfo(table, cell));
        }
        cellInfos2DList.add(cellInfos.toArray(new TableCellInfo[0]));
        return (TableCellInfo[][])cellInfos2DList.toArray((T[])new TableCellInfo[0][]);
    }

    private TableCellInfo cell2CellInfo(Table table, Cell cell) {
        String text = StringUtils.isEmpty((String)cell.getText()) ? "" : cell.getText();
        TableCellInfo cellInfo = new TableCellInfo(text.replaceAll("[ \\n]+", "") + "\n");
        cellInfo.setBbox(cell.getBbox());
        cellInfo.setPageNum(cell.getPagenum());
        cellInfo.setPageHeight(table.getPageHeight());
        cellInfo.setPageWidth(table.getPageWidth());
        return cellInfo;
    }

    public static void main(String[] args) {
        PdfInfo reference = ReadPdfUtil.getPDFInfoTest((String)"D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u6587\u6863\u5bf9\u6bd4\\\u65e5\u94a2\u73b0\u573a\\2\\\u70e7\u7ed3\u5236\u9020\u90e813#14#15#18#19#\u73af\u51b7\u673a\u589e\u52a0\u73af\u5f62\u76ae\u5e26\u9879\u76ee\u6280\u672f\u534f\u8bae(2).pdf");
        PdfInfo compare = ReadPdfUtil.getPDFInfoTest((String)"D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u6587\u6863\u5bf9\u6bd4\\\u65e5\u94a2\u73b0\u573a\\2\\\u70e7\u7ed3\u5236\u9020\u90e813#14#15#18#19#\u73af\u51b7\u673a\u589e\u52a0\u73af\u5f62\u76ae\u5e26\u9879\u76ee\u6280\u672f\u534f\u8bae20250210+(3).pdf");
        PDF2PDFPythonComparator comparator = new PDF2PDFPythonComparator();
        List<CompareResult> results = comparator.compare(reference, compare);
        System.out.println("end");
    }
}

