/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.comparator.impl;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.entity.location.Location;
import com.jxdinfo.idp.common.entity.location.TableLocation;
import com.jxdinfo.idp.common.util.TextDiffUtil;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.compare.comparator.ComparatorFactory;
import com.jxdinfo.idp.compare.comparator.IDocumentComparator;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.entity.comparator.CellTextMap;
import com.jxdinfo.idp.compare.entity.comparator.DiffMapping;
import com.jxdinfo.idp.compare.entity.comparator.ParaTextMap;
import com.jxdinfo.idp.compare.entity.comparator.TableCellInfo;
import com.jxdinfo.idp.compare.entity.comparator.TableInfo;
import com.jxdinfo.idp.compare.entity.comparator.TextInfo;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractComparator<S, T>
implements IDocumentComparator<S, T> {
    protected static TextDiffUtil util = new TextDiffUtil();

    public AbstractComparator(DocumentComparatorEnum comparatorEnum) {
        ComparatorFactory.register(comparatorEnum, this);
    }

    protected List<CompareResult> tablesCompare(List<TableInfo> reference, List<TableInfo> compare) {
        ArrayList<CompareResult> compareResults = new ArrayList<CompareResult>();
        ArrayList<TableInfo> rTables = new ArrayList<TableInfo>();
        ArrayList<TableInfo> cTables = new ArrayList<TableInfo>();
        if (CollUtil.isEmpty(rTables) || CollUtil.isEmpty(cTables)) {
            return compareResults;
        }
        this.groupTables(reference, compare, rTables, cTables);
        for (int i = 0; i < rTables.size(); ++i) {
            compareResults.addAll(this.tableCompare((TableInfo)rTables.get(i), (TableInfo)cTables.get(i)));
        }
        return compareResults;
    }

    private void groupTables(List<TableInfo> reference, List<TableInfo> compare, List<TableInfo> rTables, List<TableInfo> cTables) {
        int rSlowIndex = 0;
        int cSlowIndex = 0;
        int rFastIndex = 0;
        int cFastIndex = 0;
        TableInfo rTable = reference.get(rFastIndex);
        TableInfo cTable = compare.get(cFastIndex);
        while (true) {
            if (this.isSimilar(rTable, cTable)) {
                rTables.add(rTable);
                cTables.add(cTable);
                rFastIndex = ++rSlowIndex;
                cFastIndex = ++cSlowIndex;
                if (rFastIndex >= reference.size() || cFastIndex >= compare.size()) break;
                rTable = reference.get(rFastIndex);
                cTable = compare.get(cFastIndex);
                continue;
            }
            if (++cFastIndex < compare.size()) {
                cTable = compare.get(cFastIndex);
                continue;
            }
            cFastIndex = cSlowIndex;
            cTable = compare.get(cFastIndex);
            if ((rFastIndex = ++rSlowIndex) >= reference.size()) break;
            rTable = reference.get(rFastIndex);
        }
    }

    private boolean isSimilar(TableInfo source, TableInfo target) {
        TableCellInfo[] tRow;
        if (source == null || target == null) {
            return false;
        }
        TableCellInfo[] sRow = source.getCells2D()[0];
        if (sRow.length != (tRow = target.getCells2D()[0]).length) {
            return false;
        }
        for (int i = 0; i < sRow.length; ++i) {
            if (MatchTextUtil.isFuzzyMatched((String)sRow[i].getValue(), (String)tRow[i].getValue())) continue;
            return false;
        }
        return true;
    }

    private List<CompareResult> tableCompare(TableInfo reference, TableInfo compare) {
        TableCellInfo[] tableCellInfos;
        int n;
        TableCellInfo[][] rCells2D = reference.getCells2D();
        TableCellInfo[][] cCells2D = compare.getCells2D();
        StringBuilder rTableContent = new StringBuilder();
        StringBuilder cTableContent = new StringBuilder();
        TableCellInfo[][] tableCellInfoArray = rCells2D;
        int n2 = tableCellInfoArray.length;
        for (n = 0; n < n2; ++n) {
            for (TableCellInfo tableCellInfo : tableCellInfos = tableCellInfoArray[n]) {
                rTableContent.append(tableCellInfo.getValue());
            }
        }
        tableCellInfoArray = cCells2D;
        n2 = tableCellInfoArray.length;
        for (n = 0; n < n2; ++n) {
            for (TableCellInfo tableCellInfo : tableCellInfos = tableCellInfoArray[n]) {
                cTableContent.append(tableCellInfo.getValue());
            }
        }
        LinkedList diffs = util.diffMain(rTableContent.toString(), cTableContent.toString());
        List<DiffMapping> mappings = this.cutDiffsMapCells(diffs, reference.getCells2D(), compare.getCells2D());
        ArrayList<CompareResult> compareResults = new ArrayList<CompareResult>();
        DiffMapping rMapping = null;
        DiffMapping cMapping = null;
        for (DiffMapping mapping : mappings) {
            if (TextDiffUtil.Operation.EQUAL.equals((Object)mapping.getOperation())) {
                CompareResult result;
                List rCellTextMaps;
                if (rMapping != null && cMapping != null) {
                    rCellTextMaps = rMapping.getRCellTextMaps();
                    List cCellTextMaps = cMapping.getCCellTextMaps();
                    if (rCellTextMaps.size() != cCellTextMaps.size()) continue;
                    for (int i = 0; i < rCellTextMaps.size(); ++i) {
                        CellTextMap rCellTextMap = (CellTextMap)rCellTextMaps.get(i);
                        CellTextMap cCellTextMap = (CellTextMap)cCellTextMaps.get(i);
                        CompareResult result2 = new CompareResult();
                        result2.setType(Integer.valueOf(2));
                        result2.setCategory("table");
                        TableCellInfo rCellInfo = rCells2D[rCellTextMap.getY()][rCellTextMap.getX()];
                        TableCellInfo cCellInfo = cCells2D[cCellTextMap.getY()][cCellTextMap.getX()];
                        TableLocation rLocation = new TableLocation(rCellInfo.getBbox(), rCellTextMap.getTextIndex(), rCellTextMap.getText(), rCellInfo.getPageNum(), rCellInfo.getPageWidth(), rCellInfo.getPageHeight());
                        TableLocation cLocation = new TableLocation(cCellInfo.getBbox(), cCellTextMap.getTextIndex(), cCellTextMap.getText(), cCellInfo.getPageNum(), cCellInfo.getPageWidth(), cCellInfo.getPageHeight());
                        result2.setRLocation((Location)rLocation);
                        result2.setCLocation((Location)cLocation);
                        result2.setReferenceContent(rCellTextMap.getText());
                        result2.setCompareContent(cCellTextMap.getText());
                        compareResults.add(result2);
                    }
                    continue;
                }
                if (rMapping != null) {
                    rCellTextMaps = rMapping.getRCellTextMaps();
                    for (CellTextMap rCellTextMap : rCellTextMaps) {
                        result = new CompareResult();
                        result.setType(Integer.valueOf(3));
                        result.setCategory("table");
                        TableCellInfo rCellInfo = rCells2D[rCellTextMap.getY()][rCellTextMap.getX()];
                        TableLocation rLocation = new TableLocation(rCellInfo.getBbox(), rCellTextMap.getTextIndex(), rCellTextMap.getText(), rCellInfo.getPageNum(), rCellInfo.getPageWidth(), rCellInfo.getPageHeight());
                        result.setRLocation((Location)rLocation);
                        result.setReferenceContent(rCellTextMap.getText());
                        compareResults.add(result);
                    }
                    continue;
                }
                if (cMapping == null) continue;
                List cCellTextMaps = cMapping.getCCellTextMaps();
                for (CellTextMap cCellTextMap : cCellTextMaps) {
                    result = new CompareResult();
                    result.setCategory("table");
                    result.setType(Integer.valueOf(2));
                    TableCellInfo cCellInfo = cCells2D[cCellTextMap.getY()][cCellTextMap.getX()];
                    TableLocation cLocation = new TableLocation(cCellInfo.getBbox(), cCellTextMap.getTextIndex(), cCellTextMap.getText(), cCellInfo.getPageNum(), cCellInfo.getPageWidth(), cCellInfo.getPageHeight());
                    result.setCLocation((Location)cLocation);
                    result.setCompareContent(cCellTextMap.getText());
                    compareResults.add(result);
                }
                continue;
            }
            if (TextDiffUtil.Operation.DELETE.equals((Object)mapping.getOperation())) {
                rMapping = mapping;
                continue;
            }
            cMapping = mapping;
        }
        return compareResults;
    }

    private List<DiffMapping> cutDiffsMapCells(List<TextDiffUtil.Diff> diffs, TableCellInfo[][] reference, TableCellInfo[][] compare) {
        ArrayList<DiffMapping> mappings = new ArrayList<DiffMapping>();
        int diffPoint = 0;
        int rX = 0;
        int rY = 0;
        int cX = 0;
        int cY = 0;
        int rTextIndex = 0;
        int cTextIndex = 0;
        TableCellInfo[] rRow = reference[rY];
        TableCellInfo rCell = rRow[rX];
        TableCellInfo[] cRow = compare[cY];
        TableCellInfo cCell = cRow[cX];
        StringBuilder rText = new StringBuilder();
        StringBuilder cText = new StringBuilder();
        do {
            TextDiffUtil.Diff current = diffs.get(diffPoint);
            DiffMapping mapping = new DiffMapping(current.operation);
            mappings.add(mapping);
            String text = current.text;
            for (int i = 0; i < text.length(); ++i) {
                CellTextMap cellTextMap;
                int count = 0;
                if (current.operation == TextDiffUtil.Operation.EQUAL || current.operation == TextDiffUtil.Operation.DELETE) {
                    while (rTextIndex >= (rCell.getValue() == null ? 0 : rCell.getValue().length())) {
                        cellTextMap = new CellTextMap(Integer.valueOf(rX), Integer.valueOf(rY), rText.toString(), Integer.valueOf(rTextIndex - rText.length()));
                        if (rText.length() > 0) {
                            mapping.getRCellTextMaps().add(cellTextMap);
                            rText.setLength(0);
                        }
                        rTextIndex = 0;
                        if (++rX >= rRow.length) {
                            rX = 0;
                            if (++rY < reference.length) {
                                rRow = reference[rY];
                                rCell = rRow[rX];
                            }
                        } else {
                            rCell = rRow[rX];
                        }
                        if (++count <= 1024) continue;
                        count = 0;
                        break;
                    }
                    ++rTextIndex;
                    rText.append(text.charAt(i));
                }
                if (current.operation != TextDiffUtil.Operation.EQUAL && current.operation != TextDiffUtil.Operation.INSERT) continue;
                while (cTextIndex >= (cCell.getValue() == null ? 0 : cCell.getValue().length())) {
                    cellTextMap = new CellTextMap(Integer.valueOf(cX), Integer.valueOf(cY), cText.toString(), Integer.valueOf(cTextIndex - cText.length()));
                    if (cText.length() > 0) {
                        mapping.getCCellTextMaps().add(cellTextMap);
                        cText.setLength(0);
                    }
                    cTextIndex = 0;
                    if (++cX >= cRow.length) {
                        cX = 0;
                        if (++cY < compare.length) {
                            cRow = compare[cY];
                            cCell = cRow[cX];
                        }
                    } else {
                        cCell = cRow[cX];
                    }
                    if (++count <= 1024) continue;
                    break;
                }
                ++cTextIndex;
                cText.append(text.charAt(i));
            }
            if (rText.length() > 0) {
                CellTextMap cellTextMap = new CellTextMap(Integer.valueOf(rX), Integer.valueOf(rY), rText.toString(), Integer.valueOf(rTextIndex - rText.length()));
                mapping.getRCellTextMaps().add(cellTextMap);
                rText.setLength(0);
            }
            if (cText.length() <= 0) continue;
            CellTextMap cellTextMap = new CellTextMap(Integer.valueOf(cX), Integer.valueOf(cY), cText.toString(), Integer.valueOf(cTextIndex - cText.length()));
            mapping.getCCellTextMaps().add(cellTextMap);
            cText.setLength(0);
        } while (++diffPoint < diffs.size());
        return mappings;
    }

    protected List<CompareResult> parasCompare(List<TextInfo> reference, List<TextInfo> compare) {
        CompareResult compareResult;
        StringBuilder referenceText = new StringBuilder();
        StringBuilder compareText = new StringBuilder();
        for (TextInfo text : reference) {
            referenceText.append(text.getText());
        }
        for (TextInfo text : compare) {
            compareText.append(text.getText());
        }
        LinkedList diffs = util.diffMain(referenceText.toString(), compareText.toString());
        List<DiffMapping> mappings = this.cutDiffsMapTexts(diffs, reference, compare);
        ArrayList<CompareResult> compareResults = new ArrayList<CompareResult>();
        CompareResult result = null;
        for (int i = 0; i < mappings.size(); ++i) {
            if (TextDiffUtil.Operation.EQUAL.equals((Object)((TextDiffUtil.Diff)diffs.get((int)i)).operation)) {
                if (result == null) continue;
                if (result.getRLocation() == null) {
                    result.setRLocation(this.mutexLocation(mappings, reference, compare, diffs, i, true));
                }
                if (result.getCLocation() == null) {
                    result.setCLocation(this.mutexLocation(mappings, reference, compare, diffs, i, false));
                }
                result = null;
                continue;
            }
            if (TextDiffUtil.Operation.DELETE.equals((Object)((TextDiffUtil.Diff)diffs.get((int)i)).operation)) {
                result = new CompareResult();
                compareResults.add(result);
                result.setReferenceContent(((TextDiffUtil.Diff)diffs.get((int)i)).text);
                result.setRLocation(this.location(mappings.get(i), reference, compare));
                continue;
            }
            if (result == null) {
                result = new CompareResult();
                compareResults.add(result);
            }
            result.setCompareContent(((TextDiffUtil.Diff)diffs.get((int)i)).text);
            result.setCLocation(this.location(mappings.get(i), reference, compare));
        }
        if (result != null) {
            if (result.getRLocation() == null) {
                result.setRLocation(this.mutexLocation(mappings, reference, compare, diffs, mappings.size() - 1, true));
            }
            if (result.getCLocation() == null) {
                result.setCLocation(this.mutexLocation(mappings, reference, compare, diffs, mappings.size() - 1, false));
            }
        }
        if (CollUtil.isNotEmpty(compareResults) && compareResults.size() == 1 && ((compareResult = (CompareResult)compareResults.get(0)).getCompareContent() == null || compareResult.getReferenceContent() == null || compareResult.getReferenceContent().length() >= 1000 || compareResult.getCompareContent().length() >= 1000)) {
            compareResult.setReferenceContent("\u3010\u4e24\u4e2a\u6587\u6863\u5b8c\u5168\u4e0d\u540c\uff01\u3011");
            compareResult.setCompareContent("\u3010\u4e24\u4e2a\u6587\u6863\u5b8c\u5168\u4e0d\u540c\uff01\u3011");
            compareResult.setRLocation(new Location());
            compareResult.setCLocation(new Location());
        }
        return compareResults;
    }

    private List<DiffMapping> cutDiffsMapTexts(List<TextDiffUtil.Diff> diffs, List<TextInfo> reference, List<TextInfo> compare) {
        ArrayList<DiffMapping> mappings = new ArrayList<DiffMapping>();
        int rIndex = 0;
        int cIndex = 0;
        int rTextIndex = 0;
        int cTextIndex = 0;
        for (TextDiffUtil.Diff diff : diffs) {
            DiffMapping mapping = new DiffMapping();
            mappings.add(mapping);
            StringBuilder rText = new StringBuilder();
            StringBuilder cText = new StringBuilder();
            switch (diff.operation) {
                case EQUAL: {
                    ParaTextMap paraTextMap;
                    for (int j = 0; j < diff.text.length(); ++j) {
                        while (rTextIndex++ >= reference.get(rIndex).getText().length()) {
                            paraTextMap = new ParaTextMap(rIndex, reference.get(rIndex++).getPageNum(), rText.toString(), Integer.valueOf(rTextIndex - rText.length()));
                            if (rText.length() > 0) {
                                mapping.getRParaTextMaps().add(paraTextMap);
                            }
                            rText = new StringBuilder();
                            rTextIndex = 0;
                        }
                        while (cTextIndex++ >= compare.get(cIndex).getText().length()) {
                            paraTextMap = new ParaTextMap(cIndex, compare.get(cIndex++).getPageNum(), cText.toString(), Integer.valueOf(cTextIndex - cText.length()));
                            if (cText.length() != 0) {
                                mapping.getCParaTextMaps().add(paraTextMap);
                            }
                            cText = new StringBuilder();
                            cTextIndex = 0;
                        }
                        rText.append(diff.text.charAt(j));
                        cText.append(diff.text.charAt(j));
                    }
                    if (rText.length() > 0) {
                        ParaTextMap rParaTextMap = new ParaTextMap(rIndex, reference.get(rIndex).getPageNum(), rText.toString(), Integer.valueOf(rTextIndex - rText.length()));
                        mapping.getRParaTextMaps().add(rParaTextMap);
                    }
                    if (cText.length() <= 0) break;
                    ParaTextMap cParaTextMap = new ParaTextMap(cIndex, compare.get(cIndex).getPageNum(), cText.toString(), Integer.valueOf(cTextIndex - cText.length()));
                    mapping.getCParaTextMaps().add(cParaTextMap);
                    break;
                }
                case DELETE: {
                    ParaTextMap paraTextMap;
                    rText = new StringBuilder();
                    for (int j = 0; j < diff.text.length(); ++j) {
                        while (rTextIndex++ >= reference.get(rIndex).getText().length()) {
                            paraTextMap = new ParaTextMap(rIndex, reference.get(rIndex++).getPageNum(), rText.toString(), Integer.valueOf(rTextIndex - rText.length()));
                            if (rText.length() != 0) {
                                mapping.getRParaTextMaps().add(paraTextMap);
                            }
                            rText = new StringBuilder();
                            rTextIndex = 0;
                        }
                        rText.append(diff.text.charAt(j));
                    }
                    if (rText.length() <= 0) break;
                    ParaTextMap rParaTextMap = new ParaTextMap(rIndex, reference.get(rIndex).getPageNum(), rText.toString(), Integer.valueOf(rTextIndex - rText.length()));
                    mapping.getRParaTextMaps().add(rParaTextMap);
                    break;
                }
                case INSERT: {
                    ParaTextMap paraTextMap;
                    cText = new StringBuilder();
                    for (int j = 0; j < diff.text.length(); ++j) {
                        while (cTextIndex++ >= compare.get(cIndex).getText().length()) {
                            paraTextMap = new ParaTextMap(cIndex, compare.get(cIndex++).getPageNum(), cText.toString(), Integer.valueOf(cTextIndex - cText.length()));
                            if (cText.length() != 0) {
                                mapping.getCParaTextMaps().add(paraTextMap);
                            }
                            cText = new StringBuilder();
                            cTextIndex = 0;
                        }
                        cText.append(diff.text.charAt(j));
                    }
                    if (cText.length() <= 0) break;
                    ParaTextMap cParaTextMap = new ParaTextMap(cIndex, compare.get(cIndex).getPageNum(), cText.toString(), Integer.valueOf(cTextIndex - cText.length()));
                    mapping.getCParaTextMaps().add(cParaTextMap);
                }
            }
        }
        return mappings;
    }

    private Location location(DiffMapping mapping, List<TextInfo> reference, List<TextInfo> compare) {
        Location location = new Location();
        ArrayList<String> rTexts = new ArrayList<String>();
        ArrayList<String> cTexts = new ArrayList<String>();
        ArrayList<String> rContexts = new ArrayList<String>();
        ArrayList<String> cContexts = new ArrayList<String>();
        ArrayList<Integer> rTextIndexes = new ArrayList<Integer>();
        ArrayList<Integer> cTextIndexes = new ArrayList<Integer>();
        ArrayList<Integer> rPageNums = new ArrayList<Integer>();
        ArrayList<Integer> cPageNums = new ArrayList<Integer>();
        if (CollUtil.isNotEmpty((Collection)mapping.getRParaTextMaps())) {
            location.setTexts(rTexts);
            location.setContexts(rContexts);
            location.setTextIndexes(rTextIndexes);
            location.setPageNums(rPageNums);
            for (ParaTextMap map : mapping.getRParaTextMaps()) {
                rTexts.add(map.getText());
                rPageNums.add(map.getPageNum());
                rTextIndexes.add(map.getTextIndex());
                rContexts.add(reference.get(map.getIndex()).getText());
            }
        }
        if (CollUtil.isNotEmpty((Collection)mapping.getCParaTextMaps())) {
            location.setTexts(cTexts);
            location.setContexts(cContexts);
            location.setTextIndexes(cTextIndexes);
            location.setPageNums(cPageNums);
            for (ParaTextMap map : mapping.getCParaTextMaps()) {
                cTexts.add(map.getText());
                cPageNums.add(map.getPageNum());
                cTextIndexes.add(map.getTextIndex());
                cContexts.add(compare.get(map.getIndex()).getText());
            }
        }
        return location;
    }

    private Location mutexLocation(List<DiffMapping> mappings, List<TextInfo> refTextInfos, List<TextInfo> comTextInfos, List<TextDiffUtil.Diff> diffs, int index, boolean isR) {
        int suffixIndex;
        Location location = new Location();
        ArrayList<String> contexts = new ArrayList<String>();
        ArrayList<Integer> textIndexes = new ArrayList<Integer>();
        ArrayList<Integer> pageNums = new ArrayList<Integer>();
        location.setContexts(contexts);
        location.setTextIndexes(textIndexes);
        location.setPageNums(pageNums);
        ParaTextMap prefixTextMap = this.getPrefixTextMap(mappings, diffs, index, isR);
        ParaTextMap suffixTextMap = this.getSuffixTextMap(mappings, diffs, index, isR);
        int prefixIndex = prefixTextMap != null ? prefixTextMap.getIndex() : -1;
        int n = suffixIndex = suffixTextMap != null ? suffixTextMap.getIndex() : -1;
        if (prefixTextMap == null && suffixTextMap == null) {
            return location;
        }
        this.addContextInfo(contexts, textIndexes, pageNums, prefixTextMap, suffixTextMap, prefixIndex, suffixIndex, refTextInfos, comTextInfos, isR);
        return location;
    }

    private ParaTextMap getPrefixTextMap(List<DiffMapping> mappings, List<TextDiffUtil.Diff> diffs, int index, boolean isR) {
        for (int back = index - 1; back >= 0; --back) {
            if (diffs.get((int)back).operation != TextDiffUtil.Operation.EQUAL) continue;
            List paraTextMaps = isR ? mappings.get(back).getRParaTextMaps() : mappings.get(back).getCParaTextMaps();
            return paraTextMaps != null && !paraTextMaps.isEmpty() ? (ParaTextMap)paraTextMaps.get(paraTextMaps.size() - 1) : null;
        }
        return null;
    }

    private ParaTextMap getSuffixTextMap(List<DiffMapping> mappings, List<TextDiffUtil.Diff> diffs, int index, boolean isR) {
        for (int forward = index; forward < diffs.size(); ++forward) {
            if (diffs.get((int)forward).operation != TextDiffUtil.Operation.EQUAL) continue;
            List paraTextMaps = isR ? mappings.get(forward).getRParaTextMaps() : mappings.get(forward).getCParaTextMaps();
            return paraTextMaps != null && !paraTextMaps.isEmpty() ? (ParaTextMap)paraTextMaps.get(0) : null;
        }
        return null;
    }

    private void addContextInfo(List<String> contexts, List<Integer> textIndexes, List<Integer> pageNums, ParaTextMap prefixTextMap, ParaTextMap suffixTextMap, int prefixIndex, int suffixIndex, List<TextInfo> refTextInfos, List<TextInfo> comTextInfos, boolean isR) {
        if (prefixTextMap != null && suffixTextMap == null) {
            this.addTextInfo(contexts, textIndexes, pageNums, prefixTextMap, prefixIndex, isR ? refTextInfos : comTextInfos);
        } else if (prefixTextMap == null && suffixTextMap != null) {
            this.addTextInfo(contexts, textIndexes, pageNums, suffixTextMap, suffixIndex, isR ? refTextInfos : comTextInfos);
        } else if (suffixIndex == prefixIndex) {
            this.addTextInfo(contexts, textIndexes, pageNums, prefixTextMap, prefixIndex, isR ? refTextInfos : comTextInfos);
        } else {
            TextInfo pTextInfo = this.getTextInfo(isR ? refTextInfos : comTextInfos, prefixIndex);
            TextInfo sTextInfo = this.getTextInfo(isR ? refTextInfos : comTextInfos, suffixIndex);
            if (pTextInfo != null && pTextInfo.isContinue()) {
                contexts.add(pTextInfo.getText());
                pageNums.add(prefixTextMap.getPageNum());
                textIndexes.add(pTextInfo.getText().length() - 1);
            } else if (sTextInfo != null) {
                contexts.add(sTextInfo.getText());
                pageNums.add(suffixTextMap.getPageNum());
                textIndexes.add(0);
            }
        }
    }

    private void addTextInfo(List<String> contexts, List<Integer> textIndexes, List<Integer> pageNums, ParaTextMap textMap, int index, List<TextInfo> textInfos) {
        contexts.add(this.getText(textInfos, index));
        textIndexes.add(textMap.getTextIndex() + textMap.getText().length() - 1);
        pageNums.add(textMap.getPageNum());
    }

    private TextInfo getTextInfo(List<TextInfo> textInfos, int index) {
        return index >= 0 && index < textInfos.size() ? textInfos.get(index) : null;
    }

    private String getText(List<TextInfo> textInfos, int index) {
        TextInfo textInfo = this.getTextInfo(textInfos, index);
        return textInfo != null ? textInfo.getText() : null;
    }

    protected boolean isCatalog(String text) {
        if (text == null) {
            return false;
        }
        if (text.replaceAll(" ", "").equals("\u76ee\u5f55")) {
            return true;
        }
        for (int i = 0; i < text.length(); ++i) {
            char current = text.charAt(i);
            if (current != '.') continue;
            int pointNum = 0;
            for (int j = i; j < text.length() && text.charAt(j) == '.'; ++j) {
                if (pointNum >= 10) {
                    return true;
                }
                ++pointNum;
            }
        }
        return false;
    }
}

