/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.comparator.impl;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.entity.location.Location;
import com.jxdinfo.idp.common.pdfparser.core.PdfParser;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.TextDiffUtil;
import com.jxdinfo.idp.common.util.file.LibreOfficePDFConvert;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.comparator.impl.AbstractComparator;
import com.jxdinfo.idp.compare.entity.comparator.DiffMapping;
import com.jxdinfo.idp.compare.entity.comparator.ParaTextMap;
import com.jxdinfo.idp.compare.entity.comparator.TextInfo;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PDF2PDFComparator
extends AbstractComparator<ContentPojo, ContentPojo> {
    private static final Logger log = LoggerFactory.getLogger(PDF2PDFComparator.class);

    public PDF2PDFComparator() {
        super(DocumentComparatorEnum.PDF2PDF);
    }

    @Override
    public List<CompareResult> compare(ContentPojo reference, ContentPojo compare) {
        StringBuilder referenceText = new StringBuilder();
        StringBuilder compareText = new StringBuilder();
        List<TextInfo> referenceTexts = this.getTextInfoAndAppendText(reference, referenceText);
        List<TextInfo> compareTexts = this.getTextInfoAndAppendText(compare, compareText);
        log.info("\u3010\u53c2\u8003\u6587\u6863\u3011\u5f00\u59cb\u6253\u5370\uff0c\u6587\u672c\u5185\u5bb9\u5982\u4e0b\uff1a");
        for (TextInfo text : referenceTexts) {
            log.info(text.getText());
        }
        log.info("\u3010\u53c2\u8003\u6587\u6863\u3011\u6253\u5370\u7ed3\u675f\n---------------------------------\n\u3010\u5bf9\u6bd4\u6587\u6863\u3011\u5f00\u59cb\u6253\u5370\uff0c\u6587\u672c\u5185\u5bb9\u5982\u4e0b\uff1a");
        for (TextInfo text : compareTexts) {
            log.info(text.getText());
        }
        log.info("\u3010\u5bf9\u6bd4\u6587\u6863\u3011\u6253\u5370\u7ed3\u675f");
        TextDiffUtil util = new TextDiffUtil();
        LinkedList diffs = util.diffMain(referenceText.toString(), compareText.toString());
        return this.getResults(diffs, referenceTexts, compareTexts);
    }

    private List<TextInfo> getTextInfoAndAppendText(ContentPojo pdfInfo, StringBuilder text) {
        ArrayList<TextInfo> textInfos = new ArrayList<TextInfo>();
        List outList = pdfInfo.getOutList();
        ContentPojo.contentElement prevElement = null;
        for (ContentPojo.contentElement element : outList) {
            if (Objects.nonNull(prevElement) && ("text".equals(prevElement.getElementType()) || "title".equals(prevElement.getElementType())) && !this.isCatalog(prevElement.getText())) {
                if ("table".equals(element.getElementType()) || "pic".equals(element.getElementType()) || this.isCatalog(element.getText())) {
                    textInfos.add(new TextInfo(prevElement.getPageNumber(), prevElement.getText(), false));
                } else {
                    textInfos.add(new TextInfo(prevElement.getPageNumber(), prevElement.getText()));
                }
            }
            if (("text".equals(element.getElementType()) || "title".equals(element.getElementType())) && !this.isCatalog(element.getText())) {
                String cleanedText = element.getText().replaceAll("[ \\n]+", "");
                text.append(cleanedText);
                element.setText(cleanedText);
            }
            prevElement = element;
        }
        if (prevElement != null && ("text".equals(prevElement.getElementType()) || "title".equals(prevElement.getElementType()))) {
            textInfos.add(new TextInfo(prevElement.getPageNumber(), prevElement.getText()));
        }
        return textInfos;
    }

    private boolean isCatalog(String text) {
        if (text == null) {
            return false;
        }
        if (text.replaceAll(" ", "").equals("\u76ee\u5f55")) {
            return true;
        }
        for (int i = 0; i < text.length(); ++i) {
            char current = text.charAt(i);
            if (current != '.') continue;
            int pointNum = 0;
            for (int j = i; j < text.length() && text.charAt(j) == '.'; ++j) {
                if (pointNum >= 10) {
                    return true;
                }
                ++pointNum;
            }
        }
        return false;
    }

    private List<CompareResult> getResults(List<TextDiffUtil.Diff> diffs, List<TextInfo> reference, List<TextInfo> compare) {
        CompareResult compareResult;
        List<DiffMapping> mappings = this.cutTexts(diffs, reference, compare);
        ArrayList<CompareResult> compareResults = new ArrayList<CompareResult>();
        CompareResult result = null;
        for (int i = 0; i < mappings.size(); ++i) {
            if (TextDiffUtil.Operation.EQUAL.equals((Object)diffs.get((int)i).operation)) {
                if (result == null) continue;
                if (result.getRLocation() == null) {
                    result.setRLocation(this.mutexLocation(mappings, reference, compare, diffs, i, true));
                }
                if (result.getCLocation() == null) {
                    result.setCLocation(this.mutexLocation(mappings, reference, compare, diffs, i, false));
                }
                result = null;
                continue;
            }
            if (TextDiffUtil.Operation.DELETE.equals((Object)diffs.get((int)i).operation)) {
                result = new CompareResult();
                compareResults.add(result);
                result.setReferenceContent(diffs.get((int)i).text);
                result.setRLocation(this.location(mappings.get(i), reference, compare));
                continue;
            }
            if (result == null) {
                result = new CompareResult();
                compareResults.add(result);
            }
            result.setCompareContent(diffs.get((int)i).text);
            result.setCLocation(this.location(mappings.get(i), reference, compare));
        }
        if (result != null) {
            if (result.getRLocation() == null) {
                result.setRLocation(this.mutexLocation(mappings, reference, compare, diffs, mappings.size() - 1, true));
            }
            if (result.getCLocation() == null) {
                result.setCLocation(this.mutexLocation(mappings, reference, compare, diffs, mappings.size() - 1, false));
            }
        }
        if (CollUtil.isNotEmpty(compareResults) && compareResults.size() == 1 && ((compareResult = (CompareResult)compareResults.get(0)).getCompareContent() == null || compareResult.getReferenceContent() == null || compareResult.getReferenceContent().length() >= 1000 || compareResult.getCompareContent().length() >= 1000)) {
            compareResult.setReferenceContent("\u3010\u4e24\u4e2a\u6587\u6863\u5b8c\u5168\u4e0d\u540c\uff01\u3011");
            compareResult.setCompareContent("\u3010\u4e24\u4e2a\u6587\u6863\u5b8c\u5168\u4e0d\u540c\uff01\u3011");
            compareResult.setRLocation(new Location());
            compareResult.setCLocation(new Location());
        }
        return compareResults;
    }

    private List<DiffMapping> cutTexts(List<TextDiffUtil.Diff> diffs, List<TextInfo> reference, List<TextInfo> compare) {
        ArrayList<DiffMapping> mappings = new ArrayList<DiffMapping>();
        int rIndex = 0;
        int cIndex = 0;
        int rTextIndex = 0;
        int cTextIndex = 0;
        for (TextDiffUtil.Diff diff : diffs) {
            DiffMapping mapping = new DiffMapping();
            mappings.add(mapping);
            StringBuilder rText = new StringBuilder();
            StringBuilder cText = new StringBuilder();
            switch (diff.operation) {
                case EQUAL: {
                    ParaTextMap paraTextMap;
                    for (int j = 0; j < diff.text.length(); ++j) {
                        while (rTextIndex++ >= reference.get(rIndex).getText().length()) {
                            paraTextMap = new ParaTextMap(rIndex, reference.get(rIndex++).getPageNum(), rText.toString(), Integer.valueOf(rTextIndex - rText.length()));
                            if (rText.length() > 0) {
                                mapping.getRParaTextMaps().add(paraTextMap);
                            }
                            rText = new StringBuilder();
                            rTextIndex = 0;
                        }
                        while (cTextIndex++ >= compare.get(cIndex).getText().length()) {
                            paraTextMap = new ParaTextMap(cIndex, compare.get(cIndex++).getPageNum(), cText.toString(), Integer.valueOf(cTextIndex - cText.length()));
                            if (cText.length() != 0) {
                                mapping.getCParaTextMaps().add(paraTextMap);
                            }
                            cText = new StringBuilder();
                            cTextIndex = 0;
                        }
                        rText.append(diff.text.charAt(j));
                        cText.append(diff.text.charAt(j));
                    }
                    if (rText.length() > 0) {
                        ParaTextMap rParaTextMap = new ParaTextMap(rIndex, reference.get(rIndex).getPageNum(), rText.toString(), Integer.valueOf(rTextIndex - rText.length()));
                        mapping.getRParaTextMaps().add(rParaTextMap);
                    }
                    if (cText.length() <= 0) break;
                    ParaTextMap cParaTextMap = new ParaTextMap(cIndex, compare.get(cIndex).getPageNum(), cText.toString(), Integer.valueOf(cTextIndex - cText.length()));
                    mapping.getCParaTextMaps().add(cParaTextMap);
                    break;
                }
                case DELETE: {
                    ParaTextMap paraTextMap;
                    rText = new StringBuilder();
                    for (int j = 0; j < diff.text.length(); ++j) {
                        while (rTextIndex++ >= reference.get(rIndex).getText().length()) {
                            paraTextMap = new ParaTextMap(rIndex, reference.get(rIndex++).getPageNum(), rText.toString(), Integer.valueOf(rTextIndex - rText.length()));
                            if (rText.length() != 0) {
                                mapping.getRParaTextMaps().add(paraTextMap);
                            }
                            rText = new StringBuilder();
                            rTextIndex = 0;
                        }
                        rText.append(diff.text.charAt(j));
                    }
                    if (rText.length() <= 0) break;
                    ParaTextMap rParaTextMap = new ParaTextMap(rIndex, reference.get(rIndex).getPageNum(), rText.toString(), Integer.valueOf(rTextIndex - rText.length()));
                    mapping.getRParaTextMaps().add(rParaTextMap);
                    break;
                }
                case INSERT: {
                    ParaTextMap paraTextMap;
                    cText = new StringBuilder();
                    for (int j = 0; j < diff.text.length(); ++j) {
                        while (cTextIndex++ >= compare.get(cIndex).getText().length()) {
                            paraTextMap = new ParaTextMap(cIndex, compare.get(cIndex++).getPageNum(), cText.toString(), Integer.valueOf(cTextIndex - cText.length()));
                            if (cText.length() != 0) {
                                mapping.getCParaTextMaps().add(paraTextMap);
                            }
                            cText = new StringBuilder();
                            cTextIndex = 0;
                        }
                        cText.append(diff.text.charAt(j));
                    }
                    if (cText.length() <= 0) break;
                    ParaTextMap cParaTextMap = new ParaTextMap(cIndex, compare.get(cIndex).getPageNum(), cText.toString(), Integer.valueOf(cTextIndex - cText.length()));
                    mapping.getCParaTextMaps().add(cParaTextMap);
                }
            }
        }
        return mappings;
    }

    private Location location(DiffMapping mapping, List<TextInfo> reference, List<TextInfo> compare) {
        Location location = new Location();
        ArrayList<String> rTexts = new ArrayList<String>();
        ArrayList<String> cTexts = new ArrayList<String>();
        ArrayList<String> rContexts = new ArrayList<String>();
        ArrayList<String> cContexts = new ArrayList<String>();
        ArrayList<Integer> rTextIndexes = new ArrayList<Integer>();
        ArrayList<Integer> cTextIndexes = new ArrayList<Integer>();
        ArrayList<Integer> rPageNums = new ArrayList<Integer>();
        ArrayList<Integer> cPageNums = new ArrayList<Integer>();
        if (CollUtil.isNotEmpty((Collection)mapping.getRParaTextMaps())) {
            location.setTexts(rTexts);
            location.setContexts(rContexts);
            location.setTextIndexes(rTextIndexes);
            location.setPageNums(rPageNums);
            for (ParaTextMap map : mapping.getRParaTextMaps()) {
                rTexts.add(map.getText());
                rPageNums.add(map.getPageNum());
                rTextIndexes.add(map.getTextIndex());
                rContexts.add(reference.get(map.getIndex()).getText());
            }
        }
        if (CollUtil.isNotEmpty((Collection)mapping.getCParaTextMaps())) {
            location.setTexts(cTexts);
            location.setContexts(cContexts);
            location.setTextIndexes(cTextIndexes);
            location.setPageNums(cPageNums);
            for (ParaTextMap map : mapping.getCParaTextMaps()) {
                cTexts.add(map.getText());
                cPageNums.add(map.getPageNum());
                cTextIndexes.add(map.getTextIndex());
                cContexts.add(compare.get(map.getIndex()).getText());
            }
        }
        return location;
    }

    private Location mutexLocation(List<DiffMapping> mappings, List<TextInfo> refTextInfos, List<TextInfo> comTextInfos, List<TextDiffUtil.Diff> diffs, int index, boolean isR) {
        int suffixIndex;
        Location location = new Location();
        ArrayList<String> contexts = new ArrayList<String>();
        ArrayList<Integer> textIndexes = new ArrayList<Integer>();
        ArrayList<Integer> pageNums = new ArrayList<Integer>();
        location.setContexts(contexts);
        location.setTextIndexes(textIndexes);
        location.setPageNums(pageNums);
        ParaTextMap prefixTextMap = this.getPrefixTextMap(mappings, diffs, index, isR);
        ParaTextMap suffixTextMap = this.getSuffixTextMap(mappings, diffs, index, isR);
        int prefixIndex = prefixTextMap != null ? prefixTextMap.getIndex() : -1;
        int n = suffixIndex = suffixTextMap != null ? suffixTextMap.getIndex() : -1;
        if (prefixTextMap == null && suffixTextMap == null) {
            return location;
        }
        this.addContextInfo(contexts, textIndexes, pageNums, prefixTextMap, suffixTextMap, prefixIndex, suffixIndex, refTextInfos, comTextInfos, isR);
        return location;
    }

    private ParaTextMap getPrefixTextMap(List<DiffMapping> mappings, List<TextDiffUtil.Diff> diffs, int index, boolean isR) {
        for (int back = index - 1; back >= 0; --back) {
            if (diffs.get((int)back).operation != TextDiffUtil.Operation.EQUAL) continue;
            List paraTextMaps = isR ? mappings.get(back).getRParaTextMaps() : mappings.get(back).getCParaTextMaps();
            return paraTextMaps != null && !paraTextMaps.isEmpty() ? (ParaTextMap)paraTextMaps.get(paraTextMaps.size() - 1) : null;
        }
        return null;
    }

    private ParaTextMap getSuffixTextMap(List<DiffMapping> mappings, List<TextDiffUtil.Diff> diffs, int index, boolean isR) {
        for (int forward = index; forward < diffs.size(); ++forward) {
            if (diffs.get((int)forward).operation != TextDiffUtil.Operation.EQUAL) continue;
            List paraTextMaps = isR ? mappings.get(forward).getRParaTextMaps() : mappings.get(forward).getCParaTextMaps();
            return paraTextMaps != null && !paraTextMaps.isEmpty() ? (ParaTextMap)paraTextMaps.get(0) : null;
        }
        return null;
    }

    private void addContextInfo(List<String> contexts, List<Integer> textIndexes, List<Integer> pageNums, ParaTextMap prefixTextMap, ParaTextMap suffixTextMap, int prefixIndex, int suffixIndex, List<TextInfo> refTextInfos, List<TextInfo> comTextInfos, boolean isR) {
        if (prefixTextMap != null && suffixTextMap == null) {
            this.addTextInfo(contexts, textIndexes, pageNums, prefixTextMap, prefixIndex, isR ? refTextInfos : comTextInfos);
        } else if (prefixTextMap == null && suffixTextMap != null) {
            this.addTextInfo(contexts, textIndexes, pageNums, suffixTextMap, suffixIndex, isR ? refTextInfos : comTextInfos);
        } else if (suffixIndex == prefixIndex) {
            this.addTextInfo(contexts, textIndexes, pageNums, prefixTextMap, prefixIndex, isR ? refTextInfos : comTextInfos);
        } else {
            TextInfo pTextInfo = this.getTextInfoSafely(isR ? refTextInfos : comTextInfos, prefixIndex);
            TextInfo sTextInfo = this.getTextInfoSafely(isR ? refTextInfos : comTextInfos, suffixIndex);
            if (pTextInfo != null && pTextInfo.isContinue()) {
                contexts.add(pTextInfo.getText());
                pageNums.add(prefixTextMap.getPageNum());
                textIndexes.add(pTextInfo.getText().length() - 1);
            } else if (sTextInfo != null) {
                contexts.add(sTextInfo.getText());
                pageNums.add(suffixTextMap.getPageNum());
                textIndexes.add(0);
            }
        }
    }

    private void addTextInfo(List<String> contexts, List<Integer> textIndexes, List<Integer> pageNums, ParaTextMap textMap, int index, List<TextInfo> textInfos) {
        contexts.add(this.getTextSafely(textInfos, index));
        textIndexes.add(textMap.getTextIndex() + textMap.getText().length() - 1);
        pageNums.add(textMap.getPageNum());
    }

    private TextInfo getTextInfoSafely(List<TextInfo> textInfos, int index) {
        return index >= 0 && index < textInfos.size() ? textInfos.get(index) : null;
    }

    private String getTextSafely(List<TextInfo> textInfos, int index) {
        TextInfo textInfo = this.getTextInfoSafely(textInfos, index);
        return textInfo != null ? textInfo.getText() : null;
    }

    private TextInfo getTextInfo(List<TextInfo> textInfos, int index) {
        try {
            return textInfos.get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getText(List<TextInfo> textInfos, int index) {
        try {
            return textInfos.get(index).getText();
        }
        catch (Exception e) {
            return null;
        }
    }

    public File word2Pdf(File file) {
        long snowId = SnowFlakeUtil.getFlowIdInstance().nextId();
        File pdfFile = null;
        try {
            pdfFile = new File("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u6587\u6863\u5bf9\u6bd4\\" + snowId + ".pdf");
            LibreOfficePDFConvert.word2pdf((File)file, (File)pdfFile);
            return pdfFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        File file = new File("/Volumes/macdisk/tmp/GBT 18927-2002 \u5305\u88c5\u5bb9\u5668 \u91d1\u5c5e\u8f85\u4ef6.pdf");
        PDDocument referencePdf = PDDocument.load((File)file);
        ContentPojo referenceInfo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)referencePdf, (boolean)true);
        PDDocument comparePdf = PDDocument.load((File)new File("/Volumes/macdisk/tmp/\u5305\u88c5\u5bb9\u5668 \u91d1\u5c5e\u8f85\u4ef6\u2014\u2014\u9001\u5ba1\u7a3f2025\u5e741\u670811\u65e5.pdf"));
        ContentPojo compareInfo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)comparePdf, (boolean)true);
        PDF2PDFComparator comparator = new PDF2PDFComparator();
        List<CompareResult> results = comparator.compare(referenceInfo, compareInfo);
        results.removeIf(CompareResult2 -> StringUtils.isBlank((CharSequence)CompareResult2.getReferenceContent()) && StringUtils.isBlank((CharSequence)CompareResult2.getCompareContent()));
        System.out.println("end");
    }
}

