/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.dtobase.IDPApiResponseDto;
import com.jxdinfo.idp.compare.api.dto.CompareRecordDeteleRequestDto;
import com.jxdinfo.idp.compare.api.dto.CompareRecordQueryRequestDto;
import com.jxdinfo.idp.compare.api.dto.CompareRecordResponseDto;
import com.jxdinfo.idp.compare.api.dto.CompareResultResponseDto;
import com.jxdinfo.idp.compare.api.dto.DocumentCompareResultRequestDto;
import com.jxdinfo.idp.compare.api.dto.DocumentCompareTaskDto;
import com.jxdinfo.idp.compare.api.dto.DocumentCompareTaskRequestDto;
import com.jxdinfo.idp.compare.api.service.IDocumentCompareApi;
import com.jxdinfo.idp.compare.entity.po.CompareRecord;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import com.jxdinfo.idp.compare.entity.query.CompareRecordQuery;
import com.jxdinfo.idp.compare.entity.query.CompareResultQuery;
import com.jxdinfo.idp.compare.entity.vo.DocumentCompareVo;
import com.jxdinfo.idp.compare.service.IDocumentCompareService;
import com.jxdinfo.idp.docmanger.file.dto.DocumentDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentCompareApiImpl
implements IDocumentCompareApi {
    @Autowired
    private IDocumentCompareService documentCompareService;

    public Page<CompareRecordResponseDto> getList(CompareRecordQueryRequestDto query) {
        Page<CompareRecord> pageList = this.documentCompareService.getPageList(new CompareRecordQuery(query));
        Page page = new Page();
        page.setCurrent(pageList.getCurrent());
        page.setSize(pageList.getSize());
        page.setTotal(pageList.getTotal());
        page.setRecords(new ArrayList());
        pageList.getRecords().forEach(item -> {
            CompareRecordResponseDto dto = new CompareRecordResponseDto();
            dto.setId(item.getId());
            dto.setReferenceFileInfo(new DocumentDto(item.getReferenceFileId(), item.getReferenceFileName()));
            dto.setCompareFileInfo(new DocumentDto(item.getCompareFileId(), item.getCompareFileName()));
            page.getRecords().add(dto);
        });
        return page;
    }

    public DocumentCompareTaskDto execute(DocumentCompareTaskRequestDto vo) throws IOException {
        Long execute = this.documentCompareService.execute(new DocumentCompareVo(vo.getReferenceFileId(), vo.getCompareFileId()));
        return new DocumentCompareTaskDto(execute.toString());
    }

    public IDPApiResponseDto delete(CompareRecordDeteleRequestDto deteleRequestDto) {
        this.documentCompareService.delBatch(deteleRequestDto.getFileId());
        return new IDPApiResponseDto();
    }

    public List<CompareResultResponseDto> getResultList(DocumentCompareResultRequestDto documentCompareResultRequestDto) {
        List<CompareResult> resultList = this.documentCompareService.getResultList(new CompareResultQuery(documentCompareResultRequestDto));
        ArrayList<CompareResultResponseDto> dtoList = new ArrayList<CompareResultResponseDto>();
        resultList.forEach(item -> dtoList.add(new CompareResultResponseDto(item)));
        return dtoList;
    }
}

