/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.service.impl;

import cn.hutool.core.thread.ThreadUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.externalserve.OcrServe;
import com.jxdinfo.idp.common.pdfparser.core.PdfParser;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.docparse.ReadPdfUtil;
import com.jxdinfo.idp.common.util.file.LibreOfficePDFConvert;
import com.jxdinfo.idp.compare.comparator.ComparatorFactory;
import com.jxdinfo.idp.compare.comparator.IDocumentComparator;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.entity.dto.CompareTaskDto;
import com.jxdinfo.idp.compare.entity.dto.RecordFileInfo;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import com.jxdinfo.idp.compare.entity.po.CompareTask;
import com.jxdinfo.idp.compare.entity.query.CompareResultQuery;
import com.jxdinfo.idp.compare.entity.query.CompareTaskQuery;
import com.jxdinfo.idp.compare.entity.vo.DocumentCompareVo;
import com.jxdinfo.idp.compare.service.CompareTaskService;
import com.jxdinfo.idp.compare.service.ICompareResultService;
import com.jxdinfo.idp.compare.service.IDocumentCompareService;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.vo.DocInfoVo;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class DocumentCompareServiceImpl
implements IDocumentCompareService {
    private static final Logger log = LoggerFactory.getLogger(DocumentCompareServiceImpl.class);
    @Autowired
    private CompareTaskService compareRecordService;
    @Autowired
    private ICompareResultService compareResultService;
    @Autowired
    private DocInfoIoService docInfoIoService;
    @Autowired
    private DocService docService;
    @Autowired
    private OcrServe ocrServe;
    @Resource
    private Environment environment;
    private String[] watermarks;

    @PostConstruct
    private void init() {
        String watermark;
        ArrayList<String> watermarkList = new ArrayList<String>();
        int i = 0;
        while (!StringUtils.isEmpty((String)(watermark = (String)this.environment.getProperty("watermarks[" + i++ + "]", String.class)))) {
            watermarkList.add(watermark);
        }
        if (!watermarkList.isEmpty()) {
            this.watermarks = watermarkList.toArray(new String[0]);
        }
    }

    @Override
    public Page<CompareTask> getPageList(CompareTaskQuery query) {
        return this.compareRecordService.pageList(query);
    }

    @Override
    public Page<CompareTaskDto> getDtoPageList(CompareTaskQuery query) {
        return this.compareRecordService.dtoPageList(query);
    }

    @Override
    public CompareTask execute(DocumentCompareVo vo) {
        CompareTask task = new CompareTask();
        task.setId(Long.valueOf(vo.getId() == null ? SnowFlakeUtil.getFlowIdInstance().nextId() : vo.getId().longValue()));
        task.setCreateTime(LocalDateTime.now());
        task.setStatus(Integer.valueOf(1));
        this.compareRecordService.save(task);
        if (vo.getIsSync().booleanValue()) {
            this.execute(task, vo);
        } else {
            ThreadUtil.execute(() -> this.execute(task, vo));
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(CompareTask task, DocumentCompareVo vo) {
        log.info("\u5bf9\u6bd4\u4efb\u52a1\u5f00\u59cb\u6267\u884c\uff0cid:{}", (Object)task.getId());
        long startTime = System.currentTimeMillis();
        try {
            File file;
            FileBytesInfo reference = this.docInfoIoService.getFileBytesInfo(vo.getReferenceFileId());
            FileBytesInfo compare = this.docInfoIoService.getFileBytesInfo(vo.getCompareFileId());
            if (!"pdf".equals(reference.getFileFormat())) {
                file = this.docInfoIoService.getFile(vo.getReferenceFileId());
                this.word2Pdf(file, reference);
            }
            if (!"pdf".equals(compare.getFileFormat())) {
                file = this.docInfoIoService.getFile(vo.getCompareFileId());
                this.word2Pdf(file, compare);
            }
            PDDocument referencePdf = PDDocument.load((byte[])reference.getFileBytes());
            ContentPojo referenceInfo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)referencePdf, (boolean)true);
            PDDocument comparePdf = PDDocument.load((byte[])compare.getFileBytes());
            if (StringUtils.isNotEmpty((Object[])this.watermarks)) {
                ReadPdfUtil.removeWatermark((PDDocument)referencePdf, (String[])this.watermarks);
                ReadPdfUtil.removeWatermark((PDDocument)comparePdf, (String[])this.watermarks);
            }
            ContentPojo compareInfo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)comparePdf, (boolean)true);
            referenceInfo.getOutList().removeIf(item -> this.isCatalog(item.getText()));
            compareInfo.getOutList().removeIf(item -> this.isCatalog(item.getText()));
            IDocumentComparator<?, ?> comparator = ComparatorFactory.get(DocumentComparatorEnum.PDF2PDF);
            List<CompareResult> results = comparator.compare(referenceInfo, compareInfo);
            task.setReferenceFileName(reference.getFileName());
            task.setCompareFileName(compare.getFileName());
            task.setReferenceFileId(vo.getReferenceFileId());
            task.setCompareFileId(vo.getCompareFileId());
            results.forEach(result -> {
                result.setRecordId(task.getId());
                if (StringUtils.isNotEmpty((String)result.getReferenceContent()) && StringUtils.isNotEmpty((String)result.getCompareContent())) {
                    result.setType(Integer.valueOf(2));
                } else if (StringUtils.isNotEmpty((String)result.getReferenceContent())) {
                    result.setType(Integer.valueOf(3));
                } else {
                    result.setType(Integer.valueOf(1));
                }
            });
            results.removeIf(item -> StringUtils.isBlank((CharSequence)item.getReferenceContent()) && StringUtils.isBlank((CharSequence)item.getCompareContent()));
            this.compareResultService.saveBatch(results);
            task.setStatus(Integer.valueOf(2));
        }
        catch (Exception e) {
            task.setStatus(Integer.valueOf(3));
            log.error("\u5bf9\u6bd4\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0cid:{}", (Object)task.getId(), (Object)e);
        }
        finally {
            this.compareRecordService.updateById(task);
            long endTime = System.currentTimeMillis();
            log.info("\u5bf9\u6bd4\u4efb\u52a1\u6267\u884c\u7ed3\u675f\uff0cid:{},\u8017\u65f6\uff1a{}ms", (Object)task.getId(), (Object)(endTime - startTime));
        }
    }

    @Override
    public void delete(Long id) {
        this.compareRecordService.removeById(id);
        this.compareResultService.delByRecordId(id);
    }

    @Override
    public void delBatch(List<Long> ids) {
        this.compareRecordService.removeByIds(ids);
        this.compareResultService.delByRecordIds(ids);
    }

    @Override
    public List<CompareResult> getResultList(CompareResultQuery query) {
        List<CompareResult> list = this.compareResultService.getList(query);
        list.forEach(CompareResult::setLocation);
        return list;
    }

    @Override
    public RecordFileInfo getRecordFileInfo(Long id) {
        CompareTask record = (CompareTask)this.compareRecordService.getById(id);
        DocInfoVo rDocInfo = this.docService.getDocInfo(record.getReferenceFileId().toString());
        rDocInfo.setFileSize(Integer.parseInt(rDocInfo.getFileSize()) / 1024 + "KB");
        DocInfoVo cDocInfo = this.docService.getDocInfo(record.getCompareFileId().toString());
        cDocInfo.setFileSize(Integer.parseInt(cDocInfo.getFileSize()) / 1024 + "KB");
        return new RecordFileInfo(rDocInfo, cDocInfo);
    }

    private void word2Pdf(File file, FileBytesInfo bytesInfo) {
        long snowId = SnowFlakeUtil.getFlowIdInstance().nextId();
        try {
            File pdfFile = new File(this.environment.getProperty("docbase.breakdir") + snowId + ".pdf");
            LibreOfficePDFConvert.doDocToFdpLibre((File)file, (File)pdfFile);
            bytesInfo.setFileBytes(FileUtils.readFileToByteArray((File)pdfFile));
        }
        catch (Exception e) {
            log.error("word\u8f6cpdf\u5931\u8d25", (Throwable)e);
        }
    }

    private boolean isCatalog(String text) {
        if (text == null) {
            return false;
        }
        if (text.contains("\u76ee\u5f55")) {
            return true;
        }
        for (int i = 0; i < text.length(); ++i) {
            char current = text.charAt(i);
            if (current != '.') continue;
            int pointNum = 0;
            for (int j = i; j < text.length() && text.charAt(j) == '.'; ++j) {
                if (pointNum >= 10) {
                    return true;
                }
                ++pointNum;
            }
        }
        return false;
    }
}

