/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.comparator.impl;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.entity.location.Location;
import com.jxdinfo.idp.common.pdfparser.core.PdfParser;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.TextDiffUtil;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.comparator.impl.AbstractComparator;
import com.jxdinfo.idp.compare.entity.comparator.DiffMapping;
import com.jxdinfo.idp.compare.entity.comparator.ParaTextMap;
import com.jxdinfo.idp.compare.entity.comparator.TextInfo;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.springframework.stereotype.Service;

@Service
public class PDF2PDFComparator
extends AbstractComparator<ContentPojo, ContentPojo> {
    public PDF2PDFComparator() {
        super(DocumentComparatorEnum.PDF2PDF);
    }

    @Override
    public List<CompareResult> compare(ContentPojo reference, ContentPojo compare) {
        StringBuilder referenceText = new StringBuilder();
        StringBuilder compareText = new StringBuilder();
        ArrayList<TextInfo> referenceTexts = new ArrayList<TextInfo>();
        ArrayList<TextInfo> compareTexts = new ArrayList<TextInfo>();
        reference.getOutList().forEach(element -> {
            if ("text".equals(element.getElementType())) {
                referenceText.append(element.getText().replaceAll(" ", ""));
                referenceTexts.add(new TextInfo(element.getPageNumber(), element.getText()));
            }
        });
        compare.getOutList().forEach(element -> {
            if ("text".equals(element.getElementType())) {
                compareText.append(element.getText().replaceAll(" ", ""));
                compareTexts.add(new TextInfo(element.getPageNumber(), element.getText()));
            }
        });
        TextDiffUtil util = new TextDiffUtil();
        LinkedList diffs = util.diffMain(referenceText.toString(), compareText.toString());
        return this.getResults(diffs, referenceTexts, compareTexts);
    }

    private List<CompareResult> getResults(List<TextDiffUtil.Diff> diffs, List<TextInfo> reference, List<TextInfo> compare) {
        List<DiffMapping> mappings = this.cutTexts(diffs, reference, compare);
        ArrayList<CompareResult> compareResults = new ArrayList<CompareResult>();
        CompareResult result = null;
        for (int i = 0; i < mappings.size(); ++i) {
            if (TextDiffUtil.Operation.EQUAL.equals((Object)diffs.get((int)i).operation)) {
                if (result == null) continue;
                if (result.getRLocation() == null) {
                    result.setRLocation(this.mutexLocation(mappings, diffs, i));
                }
                if (result.getCLocation() == null) {
                    result.setCLocation(this.mutexLocation(mappings, diffs, i));
                }
                result = null;
                continue;
            }
            if (TextDiffUtil.Operation.DELETE.equals((Object)diffs.get((int)i).operation)) {
                result = new CompareResult();
                compareResults.add(result);
                result.setReferenceContent(diffs.get((int)i).text);
                result.setRLocation(this.location(mappings, diffs, i));
                continue;
            }
            if (result == null) {
                result = new CompareResult();
                compareResults.add(result);
            }
            result.setCompareContent(diffs.get((int)i).text);
            result.setCLocation(this.location(mappings, diffs, i));
        }
        if (result != null) {
            if (result.getRLocation() == null) {
                result.setRLocation(this.mutexLocation(mappings, diffs, mappings.size() - 1));
            }
            if (result.getCLocation() == null) {
                result.setCLocation(this.mutexLocation(mappings, diffs, mappings.size() - 1));
            }
        }
        return compareResults;
    }

    private List<DiffMapping> cutTexts(List<TextDiffUtil.Diff> diffs, List<TextInfo> reference, List<TextInfo> compare) {
        ArrayList<DiffMapping> mappings = new ArrayList<DiffMapping>();
        int rIndex = 0;
        int cIndex = 0;
        int rTextIndex = 0;
        int cTextIndex = 0;
        for (TextDiffUtil.Diff diff : diffs) {
            DiffMapping mapping = new DiffMapping();
            mappings.add(mapping);
            StringBuilder rText = new StringBuilder();
            StringBuilder cText = new StringBuilder();
            switch (diff.operation) {
                case EQUAL: {
                    ParaTextMap paraTextMap;
                    for (int j = 0; j < diff.text.length(); ++j) {
                        while (rTextIndex++ >= reference.get(rIndex).getText().length()) {
                            paraTextMap = new ParaTextMap(rIndex, reference.get(rIndex++).getPageNum(), rText.toString());
                            if (rText.length() > 0) {
                                mapping.getRParaTextMaps().add(paraTextMap);
                            }
                            rText = new StringBuilder();
                            rTextIndex = 0;
                        }
                        while (cTextIndex++ >= compare.get(cIndex).getText().length()) {
                            paraTextMap = new ParaTextMap(cIndex, compare.get(cIndex++).getPageNum(), cText.toString());
                            if (cText.length() != 0) {
                                mapping.getCParaTextMaps().add(paraTextMap);
                            }
                            cText = new StringBuilder();
                            cTextIndex = 0;
                        }
                        rText.append(diff.text.charAt(j));
                        cText.append(diff.text.charAt(j));
                    }
                    if (rText.length() > 0) {
                        ParaTextMap rParaTextMap = new ParaTextMap(rIndex, reference.get(rIndex).getPageNum(), rText.toString());
                        mapping.getRParaTextMaps().add(rParaTextMap);
                    }
                    if (cText.length() <= 0) break;
                    ParaTextMap cParaTextMap = new ParaTextMap(cIndex, compare.get(cIndex).getPageNum(), cText.toString());
                    mapping.getCParaTextMaps().add(cParaTextMap);
                    break;
                }
                case DELETE: {
                    ParaTextMap paraTextMap;
                    rText = new StringBuilder();
                    for (int j = 0; j < diff.text.length(); ++j) {
                        while (rTextIndex++ >= reference.get(rIndex).getText().length()) {
                            paraTextMap = new ParaTextMap(rIndex, reference.get(rIndex++).getPageNum(), rText.toString());
                            if (rText.length() != 0) {
                                mapping.getRParaTextMaps().add(paraTextMap);
                            }
                            rText = new StringBuilder();
                            rTextIndex = 0;
                        }
                        rText.append(diff.text.charAt(j));
                    }
                    if (rText.length() <= 0) break;
                    ParaTextMap rParaTextMap = new ParaTextMap(rIndex, reference.get(rIndex).getPageNum(), rText.toString());
                    mapping.getRParaTextMaps().add(rParaTextMap);
                    break;
                }
                case INSERT: {
                    ParaTextMap paraTextMap;
                    cText = new StringBuilder();
                    for (int j = 0; j < diff.text.length(); ++j) {
                        while (cTextIndex++ >= compare.get(cIndex).getText().length()) {
                            paraTextMap = new ParaTextMap(cIndex, compare.get(cIndex++).getPageNum(), cText.toString());
                            if (cText.length() != 0) {
                                mapping.getCParaTextMaps().add(paraTextMap);
                            }
                            cText = new StringBuilder();
                            cTextIndex = 0;
                        }
                        cText.append(diff.text.charAt(j));
                    }
                    if (cText.length() <= 0) break;
                    ParaTextMap cParaTextMap = new ParaTextMap(cIndex, compare.get(cIndex).getPageNum(), cText.toString());
                    mapping.getCParaTextMaps().add(cParaTextMap);
                }
            }
        }
        return mappings;
    }

    private Location location(List<DiffMapping> mappings, List<TextDiffUtil.Diff> diffs, int index) {
        String suffixStr;
        String text;
        String prefixStr;
        ParaTextMap paraTextMap;
        Object suffix;
        Object paraTextMap22;
        StringBuilder prefix;
        Location location = new Location();
        TextDiffUtil.Diff current = diffs.get(index);
        DiffMapping mapping = mappings.get(index);
        ArrayList<String> rTexts = new ArrayList<String>();
        ArrayList<String> cTexts = new ArrayList<String>();
        ArrayList<String> rContexts = new ArrayList<String>();
        ArrayList<String> cContexts = new ArrayList<String>();
        ArrayList<Integer> rTextIndexes = new ArrayList<Integer>();
        ArrayList<Integer> cTextIndexes = new ArrayList<Integer>();
        ArrayList<Integer> rPageNums = new ArrayList<Integer>();
        ArrayList<Integer> cPageNums = new ArrayList<Integer>();
        int back = index - 1;
        int forward = index + 1;
        if (CollUtil.isNotEmpty((Collection)mapping.getRParaTextMaps())) {
            location.setTexts(rTexts);
            location.setContexts(rContexts);
            location.setTextIndexes(rTextIndexes);
            location.setPageNums(rPageNums);
            for (ParaTextMap rParaTextMap : mapping.getRParaTextMaps()) {
                rTexts.add(rParaTextMap.getText());
                prefix = new StringBuilder();
                while (back >= 0) {
                    if (diffs.get((int)back).operation == TextDiffUtil.Operation.EQUAL) {
                        for (Object paraTextMap22 : mappings.get(back).getRParaTextMaps()) {
                            if (paraTextMap22.getIndex() != rParaTextMap.getIndex()) continue;
                            prefix.append(paraTextMap22.getText());
                        }
                        break;
                    }
                    --back;
                }
                suffix = new StringBuilder();
                while (forward < diffs.size()) {
                    if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL) {
                        paraTextMap22 = mappings.get(forward).getRParaTextMaps().iterator();
                        while (paraTextMap22.hasNext()) {
                            paraTextMap = (ParaTextMap)paraTextMap22.next();
                            if (paraTextMap.getIndex() != rParaTextMap.getIndex()) continue;
                            ((StringBuilder)suffix).append(paraTextMap.getText());
                        }
                        break;
                    }
                    ++forward;
                }
                prefixStr = prefix.toString();
                text = rParaTextMap.getText();
                suffixStr = ((StringBuilder)suffix).toString();
                rContexts.add(prefixStr + text + suffixStr);
                rPageNums.add(rParaTextMap.getPageNum());
                rTextIndexes.add(prefixStr.length());
            }
        } else if (CollUtil.isNotEmpty((Collection)mapping.getCParaTextMaps())) {
            location.setTexts(cTexts);
            location.setContexts(cContexts);
            location.setTextIndexes(cTextIndexes);
            location.setPageNums(cPageNums);
            for (ParaTextMap cParaTextMap : mapping.getCParaTextMaps()) {
                cTexts.add(cParaTextMap.getText());
                prefix = new StringBuilder();
                while (back >= 0) {
                    if (diffs.get((int)back).operation == TextDiffUtil.Operation.EQUAL) {
                        for (Object paraTextMap22 : mappings.get(back).getCParaTextMaps()) {
                            if (paraTextMap22.getIndex() != cParaTextMap.getIndex()) continue;
                            prefix.append(paraTextMap22.getText());
                        }
                        break;
                    }
                    --back;
                }
                suffix = new StringBuilder();
                while (forward < diffs.size()) {
                    if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL) {
                        paraTextMap22 = mappings.get(forward).getCParaTextMaps().iterator();
                        while (paraTextMap22.hasNext()) {
                            paraTextMap = (ParaTextMap)paraTextMap22.next();
                            if (paraTextMap.getIndex() != cParaTextMap.getIndex()) continue;
                            ((StringBuilder)suffix).append(paraTextMap.getText());
                        }
                        break;
                    }
                    ++forward;
                }
                prefixStr = prefix.toString();
                text = cParaTextMap.getText();
                suffixStr = ((StringBuilder)suffix).toString();
                cContexts.add(prefixStr + text + suffixStr);
                cPageNums.add(cParaTextMap.getPageNum());
                cTextIndexes.add(prefixStr.length());
            }
        }
        String prefix2 = "";
        String suffix2 = "";
        while (back >= 0) {
            if (diffs.get((int)back).operation == TextDiffUtil.Operation.EQUAL) {
                prefix2 = diffs.get((int)back).text;
                break;
            }
            --back;
        }
        while (forward < diffs.size()) {
            if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL) {
                suffix2 = diffs.get((int)forward).text;
                break;
            }
            ++forward;
        }
        String text2 = current.text;
        location.setText(text2);
        location.setContext(prefix2 + text2 + suffix2);
        location.setTextIndex(Integer.valueOf(prefix2.length()));
        return location;
    }

    private Location mutexRLocation(List<DiffMapping> mappings, List<TextDiffUtil.Diff> diffs, int index) {
        Location location = new Location();
        DiffMapping mapping = mappings.get(index);
        return location;
    }

    private Location mutexLocation(List<DiffMapping> mappings, List<TextDiffUtil.Diff> diffs, int index) {
        Object suffix;
        String prefix;
        Location location = new Location();
        DiffMapping mapping = mappings.get(index);
        ArrayList<Object> rTexts = new ArrayList<Object>();
        ArrayList<Object> cTexts = new ArrayList<Object>();
        ArrayList<String> rContexts = new ArrayList<String>();
        ArrayList<String> cContexts = new ArrayList<String>();
        ArrayList<Integer> rTextIndexes = new ArrayList<Integer>();
        ArrayList<Integer> cTextIndexes = new ArrayList<Integer>();
        ArrayList<Integer> rPageNums = new ArrayList<Integer>();
        ArrayList<Integer> cPageNums = new ArrayList<Integer>();
        int back = index - 1;
        int forward = index;
        if (CollUtil.isNotEmpty((Collection)mapping.getRParaTextMaps())) {
            location.setTexts(rTexts);
            location.setContexts(rContexts);
            location.setTextIndexes(rTextIndexes);
            location.setPageNums(rPageNums);
            for (ParaTextMap rParaTextMap : mapping.getRParaTextMaps()) {
                rTexts.add(null);
                prefix = "";
                while (back >= 0) {
                    if (diffs.get((int)back).operation == TextDiffUtil.Operation.EQUAL) {
                        for (Object paraTextMap : mappings.get(back).getRParaTextMaps()) {
                            if (paraTextMap.getIndex() != rParaTextMap.getIndex()) continue;
                            prefix = paraTextMap.getText() + prefix;
                        }
                        break;
                    }
                    --back;
                }
                suffix = new StringBuilder();
                while (forward < diffs.size()) {
                    if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL) {
                        Object paraTextMap;
                        paraTextMap = mappings.get(forward).getRParaTextMaps().iterator();
                        while (paraTextMap.hasNext()) {
                            ParaTextMap paraTextMap2 = (ParaTextMap)paraTextMap.next();
                            if (paraTextMap2.getIndex() != rParaTextMap.getIndex()) continue;
                            ((StringBuilder)suffix).append(paraTextMap2.getText());
                        }
                        break;
                    }
                    ++forward;
                }
                rContexts.add(prefix + suffix);
                rPageNums.add(rParaTextMap.getPageNum());
                if (StringUtils.isNotEmpty((String)prefix) && StringUtils.isNotEmpty((CharSequence)suffix)) {
                    rTextIndexes.add(-1);
                    continue;
                }
                rTextIndexes.add(prefix.length());
            }
        } else if (CollUtil.isNotEmpty((Collection)mapping.getCParaTextMaps())) {
            location.setTexts(cTexts);
            location.setContexts(cContexts);
            location.setTextIndexes(cTextIndexes);
            location.setPageNums(cPageNums);
            for (ParaTextMap cParaTextMap : mapping.getCParaTextMaps()) {
                cTexts.add(null);
                prefix = "";
                while (back >= 0) {
                    if (diffs.get((int)back).operation == TextDiffUtil.Operation.EQUAL) {
                        for (Object paraTextMap : mappings.get(back).getCParaTextMaps()) {
                            if (paraTextMap.getIndex() != cParaTextMap.getIndex()) continue;
                            prefix = prefix + paraTextMap.getText();
                        }
                        break;
                    }
                    --back;
                }
                suffix = new StringBuilder();
                while (forward < diffs.size()) {
                    if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL) {
                        for (ParaTextMap paraTextMap2 : mappings.get(forward).getCParaTextMaps()) {
                            if (paraTextMap2.getIndex() != cParaTextMap.getIndex()) continue;
                            ((StringBuilder)suffix).append(paraTextMap2.getText());
                        }
                        break;
                    }
                    ++forward;
                }
                cContexts.add(prefix + suffix);
                cPageNums.add(cParaTextMap.getPageNum());
                if (StringUtils.isNotEmpty((String)prefix) && StringUtils.isNotEmpty((CharSequence)suffix)) {
                    cTextIndexes.add(-1);
                    continue;
                }
                cTextIndexes.add(prefix.length());
            }
        }
        String prefix2 = "";
        String suffix2 = "";
        while (back >= 0) {
            if (diffs.get((int)back).operation == TextDiffUtil.Operation.EQUAL) {
                prefix2 = diffs.get((int)back).text;
                break;
            }
            --back;
        }
        while (forward < diffs.size()) {
            if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL) {
                suffix2 = diffs.get((int)forward).text;
                break;
            }
            ++forward;
        }
        location.setContext(prefix2 + suffix2);
        location.setTextIndex(Integer.valueOf(prefix2.length()));
        return location;
    }

    public static void main(String[] args) throws Exception {
        PDDocument referencePdf = PDDocument.load((File)new File("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24020003\u5168\u6d41\u7a0b\u667a\u80fd\u5de5\u5382300\u5428\u8f6c\u7089\u64cd\u4f5c\u53f0\u5408\u5e76\u9879\u76ee\\2.ZF3G24020003\u62db\u6807\u6280\u672f\u534f\u8bae.pdf"));
        ContentPojo referenceInfo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)referencePdf, (boolean)true);
        PDDocument comparePdf = PDDocument.load((File)new File("D:\\linkunpeng\\Desktop\\\u667a\u80fd\u9884\u5ba1\\2.0\\\u6d4b\u8bd5\u6587\u4ef6\\\u5408\u540c\u5ba1\u67e5-F3\\\u5de5\u7a0b\\ZF3G24020003\u5168\u6d41\u7a0b\u667a\u80fd\u5de5\u5382300\u5428\u8f6c\u7089\u64cd\u4f5c\u53f0\u5408\u5e76\u9879\u76ee\\4.ZF3G24020003\u7b7e\u7ae0\u6280\u672f\u534f\u8bae.pdf"));
        ContentPojo compareInfo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)comparePdf, (boolean)true);
        PDF2PDFComparator comparator = new PDF2PDFComparator();
        List<CompareResult> results = comparator.compare(referenceInfo, compareInfo);
        System.out.println("end");
    }
}

