/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.service.impl;

import cn.hutool.core.thread.ThreadUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.entity.externalserve.LayoutParserRequest;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.externalserve.OcrServe;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.docparse.ReadWordUtil;
import com.jxdinfo.idp.compare.comparator.ComparatorFactory;
import com.jxdinfo.idp.compare.comparator.IDocumentComparator;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.entity.dto.CompareTaskDto;
import com.jxdinfo.idp.compare.entity.dto.RecordFileInfo;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import com.jxdinfo.idp.compare.entity.po.CompareTask;
import com.jxdinfo.idp.compare.entity.query.CompareResultQuery;
import com.jxdinfo.idp.compare.entity.query.CompareTaskQuery;
import com.jxdinfo.idp.compare.entity.vo.DocumentCompareVo;
import com.jxdinfo.idp.compare.service.CompareTaskService;
import com.jxdinfo.idp.compare.service.ICompareResultService;
import com.jxdinfo.idp.compare.service.IDocumentCompareService;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.vo.DocInfoVo;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DocumentCompareServiceImpl
implements IDocumentCompareService {
    private static final Logger log = LoggerFactory.getLogger(DocumentCompareServiceImpl.class);
    @Autowired
    private CompareTaskService compareRecordService;
    @Autowired
    private ICompareResultService compareResultService;
    @Autowired
    private DocInfoIoService docInfoIoService;
    @Autowired
    private DocService docService;
    @Autowired
    private OcrServe ocrServe;

    @Override
    public Page<CompareTask> getPageList(CompareTaskQuery query) {
        return this.compareRecordService.pageList(query);
    }

    @Override
    public Page<CompareTaskDto> getDtoPageList(CompareTaskQuery query) {
        return this.compareRecordService.dtoPageList(query);
    }

    @Override
    public CompareTask execute(DocumentCompareVo vo) {
        CompareTask task = new CompareTask();
        task.setId(Long.valueOf(vo.getId() == null ? SnowFlakeUtil.getFlowIdInstance().nextId() : vo.getId().longValue()));
        task.setCreateTime(LocalDateTime.now());
        task.setStatus(Integer.valueOf(1));
        this.compareRecordService.save(task);
        if (vo.getIsSync().booleanValue()) {
            this.execute(task, vo);
        } else {
            ThreadUtil.execute(() -> this.execute(task, vo));
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(CompareTask task, DocumentCompareVo vo) {
        log.info("\u5bf9\u6bd4\u4efb\u52a1\u5f00\u59cb\u6267\u884c\uff0cid:{}", (Object)task.getId());
        long startTime = System.currentTimeMillis();
        try {
            ResponseEntity entity;
            FileBytesInfo reference = this.docInfoIoService.getFileBytesInfo(vo.getReferenceFileId());
            FileBytesInfo compare = this.docInfoIoService.getFileBytesInfo(vo.getCompareFileId());
            if ("pdf".equals(reference.getFileFormat())) {
                entity = this.ocrServe.layoutParser(new LayoutParserRequest(reference.getFileBytes()));
                reference.setFileBytes((byte[])entity.getBody());
                reference.setFileFormat("docx");
            }
            if ("pdf".equals(compare.getFileFormat())) {
                entity = this.ocrServe.layoutParser(new LayoutParserRequest(compare.getFileBytes()));
                compare.setFileBytes((byte[])entity.getBody());
                compare.setFileFormat("docx");
            }
            WordInfo rWordInfo = ReadWordUtil.getWordInfo((FileBytesInfo)reference);
            WordInfo cWordInfo = ReadWordUtil.getWordInfo((FileBytesInfo)compare);
            IDocumentComparator<?, ?> comparator = ComparatorFactory.get(DocumentComparatorEnum.WORD2WORD);
            List<CompareResult> results = comparator.compare(rWordInfo, cWordInfo);
            task.setReferenceFileName(reference.getFileName());
            task.setCompareFileName(compare.getFileName());
            task.setReferenceFileId(vo.getReferenceFileId());
            task.setCompareFileId(vo.getCompareFileId());
            results.forEach(result -> {
                result.setRecordId(task.getId());
                if (result.getReferenceContent() != null && result.getCompareContent() != null) {
                    result.setType(Integer.valueOf(2));
                } else if (result.getReferenceContent() != null) {
                    result.setType(Integer.valueOf(3));
                } else {
                    result.setType(Integer.valueOf(1));
                }
            });
            this.compareResultService.saveBatch(results);
            task.setStatus(Integer.valueOf(2));
        }
        catch (Exception e) {
            task.setStatus(Integer.valueOf(3));
            log.error("\u5bf9\u6bd4\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0cid:{}", (Object)task.getId(), (Object)e);
        }
        finally {
            this.compareRecordService.updateById(task);
            long endTime = System.currentTimeMillis();
            log.info("\u5bf9\u6bd4\u4efb\u52a1\u6267\u884c\u7ed3\u675f\uff0cid:{},\u8017\u65f6\uff1a{}ms", (Object)task.getId(), (Object)(endTime - startTime));
        }
    }

    @Override
    public void delete(Long id) {
        this.compareRecordService.removeById(id);
        this.compareResultService.delByRecordId(id);
    }

    @Override
    public void delBatch(List<Long> ids) {
        this.compareRecordService.removeByIds(ids);
        this.compareResultService.delByRecordIds(ids);
    }

    @Override
    public List<CompareResult> getResultList(CompareResultQuery query) {
        List<CompareResult> list = this.compareResultService.getList(query);
        list.forEach(CompareResult::setLocation);
        list.removeIf(item -> StringUtils.isBlank((CharSequence)item.getReferenceContent()) && StringUtils.isBlank((CharSequence)item.getCompareContent()));
        return list;
    }

    @Override
    public RecordFileInfo getRecordFileInfo(Long id) {
        CompareTask record = (CompareTask)this.compareRecordService.getById(id);
        DocInfoVo rDocInfo = this.docService.getDocInfo(record.getReferenceFileId().toString());
        rDocInfo.setFileSize(Integer.parseInt(rDocInfo.getFileSize()) / 1024 + "KB");
        DocInfoVo cDocInfo = this.docService.getDocInfo(record.getCompareFileId().toString());
        cDocInfo.setFileSize(Integer.parseInt(cDocInfo.getFileSize()) / 1024 + "KB");
        return new RecordFileInfo(rDocInfo, cDocInfo);
    }

    public static String getFileExtension(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            return filename.substring(i + 1);
        }
        return "";
    }

    private void outPutFile(byte[] bytes, String fileName) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            fos.write(bytes);
        }
    }
}

