/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.entity.externalserve.LayoutParserRequest;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.externalserve.OcrServe;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.docparse.ReadWordUtil;
import com.jxdinfo.idp.compare.comparator.ComparatorFactory;
import com.jxdinfo.idp.compare.comparator.IDocumentComparator;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.entity.dto.CompareTaskDto;
import com.jxdinfo.idp.compare.entity.dto.RecordFileInfo;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import com.jxdinfo.idp.compare.entity.po.CompareTask;
import com.jxdinfo.idp.compare.entity.query.CompareRecordQuery;
import com.jxdinfo.idp.compare.entity.query.CompareResultQuery;
import com.jxdinfo.idp.compare.entity.vo.DocumentCompareVo;
import com.jxdinfo.idp.compare.service.CompareTaskService;
import com.jxdinfo.idp.compare.service.ICompareResultService;
import com.jxdinfo.idp.compare.service.IDocumentCompareService;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.vo.DocInfoVo;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DocumentCompareServiceImpl
implements IDocumentCompareService {
    @Autowired
    private CompareTaskService compareRecordService;
    @Autowired
    private ICompareResultService compareResultService;
    @Autowired
    private DocInfoIoService docInfoIoService;
    @Autowired
    private DocService docService;
    @Autowired
    private OcrServe ocrServe;

    @Override
    public Page<CompareTask> getPageList(CompareRecordQuery query) {
        return this.compareRecordService.pageList(query);
    }

    @Override
    public Page<CompareTaskDto> getDtoPageList(CompareRecordQuery query) {
        return this.compareRecordService.dtoPageList(query);
    }

    @Override
    public Long execute(DocumentCompareVo vo) throws Exception {
        long id = SnowFlakeUtil.getFlowIdInstance().nextId();
        try {
            ResponseEntity entity;
            FileBytesInfo reference = this.docInfoIoService.getFileBytesInfo(vo.getReferenceFileId());
            FileBytesInfo compare = this.docInfoIoService.getFileBytesInfo(vo.getCompareFileId());
            if ("pdf".equals(reference.getFileFormat())) {
                entity = this.ocrServe.layoutParser(new LayoutParserRequest(reference.getFileBytes()));
                reference.setFileBytes((byte[])entity.getBody());
                reference.setFileFormat("docx");
            }
            if ("pdf".equals(compare.getFileFormat())) {
                entity = this.ocrServe.layoutParser(new LayoutParserRequest(compare.getFileBytes()));
                compare.setFileBytes((byte[])entity.getBody());
                compare.setFileFormat("docx");
            }
            WordInfo rWordInfo = ReadWordUtil.getWordInfo((FileBytesInfo)reference);
            WordInfo cWordInfo = ReadWordUtil.getWordInfo((FileBytesInfo)compare);
            IDocumentComparator<?, ?> comparator = ComparatorFactory.get(DocumentComparatorEnum.WORD2WORD);
            List<CompareResult> results = comparator.compare(rWordInfo, cWordInfo);
            CompareTask record = new CompareTask();
            record.setId(Long.valueOf(id));
            record.setCreateTime(LocalDateTime.now());
            record.setReferenceFileName(reference.getFileName());
            record.setCompareFileName(compare.getFileName());
            record.setReferenceFileId(vo.getReferenceFileId());
            record.setCompareFileId(vo.getCompareFileId());
            results.forEach(result -> {
                result.setRecordId(record.getId());
                if (result.getReferenceContent() != null && result.getCompareContent() != null) {
                    result.setType(Integer.valueOf(2));
                } else if (result.getReferenceContent() != null) {
                    result.setType(Integer.valueOf(3));
                } else {
                    result.setType(Integer.valueOf(1));
                }
            });
            this.compareRecordService.save(record);
            this.compareResultService.saveBatch(results);
            return record.getId();
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(id), e);
        }
    }

    @Override
    public void delete(Long id) {
        this.compareRecordService.removeById(id);
        this.compareResultService.delByRecordId(id);
    }

    @Override
    public void delBatch(List<Long> ids) {
        this.compareRecordService.removeByIds(ids);
        this.compareResultService.delByRecordIds(ids);
    }

    @Override
    public List<CompareResult> getResultList(CompareResultQuery query) {
        List<CompareResult> list = this.compareResultService.getList(query);
        list.forEach(CompareResult::setLocation);
        list.removeIf(item -> StringUtils.isBlank((CharSequence)item.getReferenceContent()) && StringUtils.isBlank((CharSequence)item.getCompareContent()));
        return list;
    }

    @Override
    public RecordFileInfo getRecordFileInfo(Long id) {
        CompareTask record = (CompareTask)this.compareRecordService.getById(id);
        DocInfoVo rDocInfo = this.docService.getDocInfo(record.getReferenceFileId().toString());
        rDocInfo.setFileSize(Integer.parseInt(rDocInfo.getFileSize()) / 1024 + "KB");
        DocInfoVo cDocInfo = this.docService.getDocInfo(record.getCompareFileId().toString());
        cDocInfo.setFileSize(Integer.parseInt(cDocInfo.getFileSize()) / 1024 + "KB");
        return new RecordFileInfo(rDocInfo, cDocInfo);
    }

    public static String getFileExtension(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            return filename.substring(i + 1);
        }
        return "";
    }

    private void outPutFile(byte[] bytes, String fileName) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            fos.write(bytes);
        }
    }
}

