/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.comparator.impl;

import com.jxdinfo.idp.common.entity.location.Location;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphInfo;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.TextDiffUtil;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.comparator.impl.AbstractComparator;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class Word2WordComparator
extends AbstractComparator<WordInfo, WordInfo> {
    public Word2WordComparator() {
        super(DocumentComparatorEnum.WORD2WORD);
    }

    @Override
    public List<CompareResult> compare(WordInfo reference, WordInfo contrast) {
        List referenceParaInfos = reference.getParaInfos();
        StringBuilder referenceText = new StringBuilder();
        referenceParaInfos.forEach(e -> referenceText.append(e.getText()));
        List contrastParaInfos = contrast.getParaInfos();
        StringBuilder contrastText = new StringBuilder();
        contrastParaInfos.forEach(e -> contrastText.append(e.getText()));
        TextDiffUtil util = new TextDiffUtil();
        util.Diff_Timeout = 0.0f;
        LinkedList diffs = util.diffMain(referenceText.toString(), contrastText.toString());
        return this.getCompareResults(diffs, referenceParaInfos, contrastParaInfos);
    }

    private List<CompareResult> getCompareResults(List<TextDiffUtil.Diff> diffs, List<WordParagraphInfo> reference, List<WordParagraphInfo> contrast) {
        LinkedList<CompareResult> compareResults = new LinkedList<CompareResult>();
        int referenceIndex = 0;
        int contrastIndex = 0;
        WordParagraphInfo referencePara = reference.get(referenceIndex);
        WordParagraphInfo contrastPara = contrast.get(contrastIndex);
        int rTextIndex = 0;
        int cTextIndex = 0;
        int diffIndex = -1;
        int lastDiffIndex = 0;
        TextDiffUtil.Diff lastDiff = null;
        CompareResult result = null;
        for (TextDiffUtil.Diff diff : diffs) {
            ++diffIndex;
            switch (diff.operation) {
                case EQUAL: {
                    int i;
                    for (i = 0; i < diff.text.length(); ++i) {
                        if (result != null) {
                            if (result.getReferenceContent() == null) {
                                result.setRLocation(this.mutexLocation(diffs, lastDiff, lastDiffIndex));
                            }
                            if (result.getCompareContent() == null) {
                                result.setCLocation(this.mutexLocation(diffs, lastDiff, lastDiffIndex));
                            }
                        }
                        result = null;
                        if (rTextIndex++ >= referencePara.getText().length()) {
                            referencePara = reference.get(++referenceIndex);
                            rTextIndex = 0;
                        }
                        if (cTextIndex++ < contrastPara.getText().length()) continue;
                        contrastPara = contrast.get(++contrastIndex);
                        cTextIndex = 0;
                    }
                    break;
                }
                case DELETE: {
                    int i;
                    result = new CompareResult();
                    compareResults.add(result);
                    result.setReferenceContent(diff.text);
                    result.setRLocation(this.location(diffs, diff, diffIndex));
                    for (i = 0; i < diff.text.length(); ++i) {
                        if (rTextIndex++ < referencePara.getText().length()) continue;
                        referencePara = reference.get(++referenceIndex);
                        rTextIndex = 0;
                    }
                    lastDiff = diff;
                    break;
                }
                case INSERT: {
                    int i;
                    if (result == null) {
                        result = new CompareResult();
                        compareResults.add(result);
                    }
                    result.setCompareContent(diff.text);
                    result.setCLocation(this.location(diffs, diff, diffIndex));
                    for (i = 0; i < diff.text.length(); ++i) {
                        if (cTextIndex++ < contrastPara.getText().length()) continue;
                        contrastPara = contrast.get(++contrastIndex);
                        cTextIndex = 0;
                    }
                    lastDiff = diff;
                }
            }
            lastDiffIndex = diffIndex;
        }
        if (result != null) {
            if (result.getReferenceContent() == null) {
                result.setRLocation(this.mutexLocation(diffs, lastDiff, lastDiffIndex));
            }
            if (result.getCompareContent() == null) {
                result.setCLocation(this.mutexLocation(diffs, lastDiff, lastDiffIndex));
            }
        }
        return compareResults;
    }

    private Location location(List<TextDiffUtil.Diff> diffs, TextDiffUtil.Diff current, int index) {
        Location location = new Location();
        location.setText(current.text);
        int forward = index + 1;
        String prefix = "";
        String suffix = "";
        for (int back = index - 1; back >= 0; --back) {
            if (diffs.get((int)back).operation != TextDiffUtil.Operation.EQUAL && diffs.get((int)back).operation != current.operation) continue;
            prefix = diffs.get((int)back).text;
            break;
        }
        while (forward < diffs.size()) {
            if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL || diffs.get((int)forward).operation == current.operation) {
                suffix = diffs.get((int)forward).text;
                break;
            }
            ++forward;
        }
        location.setContext(prefix + current.text + suffix);
        location.setTextIndex(Integer.valueOf(prefix.length()));
        return location;
    }

    private Location mutexLocation(List<TextDiffUtil.Diff> diffs, TextDiffUtil.Diff current, int index) {
        Location location = new Location();
        int forward = index + 1;
        String prefix = "";
        String suffix = "";
        for (int back = index - 1; back >= 0; --back) {
            if (diffs.get((int)back).operation != TextDiffUtil.Operation.EQUAL && diffs.get((int)back).operation == current.operation) continue;
            prefix = diffs.get((int)back).text;
            break;
        }
        while (forward < diffs.size()) {
            if (diffs.get((int)forward).operation == TextDiffUtil.Operation.EQUAL || diffs.get((int)forward).operation != current.operation) {
                suffix = diffs.get((int)forward).text;
                break;
            }
            ++forward;
        }
        location.setContext(prefix + suffix);
        location.setTextIndex(Integer.valueOf(prefix.length()));
        location.setText("");
        return location;
    }

    public static void main(String[] args) throws FileNotFoundException {
        String s = " ";
        System.out.println(StringUtils.isBlank((CharSequence)""));
    }
}

