/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.api;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.thread.ThreadUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.dtobase.IDPApiResponseDto;
import com.jxdinfo.idp.compare.api.dto.CompareRecordDeteleRequestDto;
import com.jxdinfo.idp.compare.api.dto.CompareRecordQueryRequestDto;
import com.jxdinfo.idp.compare.api.dto.CompareRecordResponseDto;
import com.jxdinfo.idp.compare.api.dto.CompareResultResponseDto;
import com.jxdinfo.idp.compare.api.dto.DocumentCompareBatchDto;
import com.jxdinfo.idp.compare.api.dto.DocumentCompareBatchRequestDto;
import com.jxdinfo.idp.compare.api.dto.DocumentCompareResultRequestDto;
import com.jxdinfo.idp.compare.api.dto.DocumentCompareTaskDto;
import com.jxdinfo.idp.compare.api.dto.DocumentCompareTaskRequestDto;
import com.jxdinfo.idp.compare.api.service.CompareOverInterface;
import com.jxdinfo.idp.compare.api.service.IDocumentCompareApi;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import com.jxdinfo.idp.compare.entity.po.CompareTask;
import com.jxdinfo.idp.compare.entity.query.CompareRecordQuery;
import com.jxdinfo.idp.compare.entity.query.CompareResultQuery;
import com.jxdinfo.idp.compare.entity.vo.DocumentCompareVo;
import com.jxdinfo.idp.compare.service.IDocumentCompareService;
import com.jxdinfo.idp.docmanger.file.dto.DocumentDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentCompareApiImpl
implements IDocumentCompareApi {
    @Autowired
    private IDocumentCompareService documentCompareService;
    @Autowired(required=false)
    private List<CompareOverInterface> overInterfaces;

    public Page<CompareRecordResponseDto> getList(CompareRecordQueryRequestDto query) {
        Page<CompareTask> pageList = this.documentCompareService.getPageList(new CompareRecordQuery(query));
        Page page = new Page();
        page.setCurrent(pageList.getCurrent());
        page.setSize(pageList.getSize());
        page.setTotal(pageList.getTotal());
        page.setRecords(new ArrayList());
        pageList.getRecords().forEach(item -> {
            CompareRecordResponseDto dto = new CompareRecordResponseDto();
            dto.setId(item.getId());
            dto.setReferenceFileInfo(new DocumentDto(item.getReferenceFileId(), item.getReferenceFileName()));
            dto.setCompareFileInfo(new DocumentDto(item.getCompareFileId(), item.getCompareFileName()));
            page.getRecords().add(dto);
        });
        return page;
    }

    public DocumentCompareTaskDto execute(DocumentCompareTaskRequestDto vo) {
        DocumentCompareTaskDto compareTaskDto = new DocumentCompareTaskDto();
        try {
            compareTaskDto.setId(this.documentCompareService.execute(new DocumentCompareVo(vo.getReferenceFileId(), vo.getCompareFileId())));
        }
        catch (Exception e) {
            compareTaskDto.setId(Long.valueOf(e.getMessage()));
        }
        return compareTaskDto;
    }

    public List<DocumentCompareTaskDto> executeBatch(DocumentCompareBatchRequestDto vo) throws IOException {
        ArrayList<DocumentCompareTaskDto> dtoList = new ArrayList<DocumentCompareTaskDto>();
        if (vo.getIsSync().booleanValue()) {
            vo.getRecordRequests().forEach(recordRequest -> dtoList.add(this.execute((DocumentCompareTaskRequestDto)recordRequest)));
        } else {
            ThreadUtil.execute(() -> vo.getRecordRequests().forEach(recordRequest -> {
                dtoList.add(this.execute((DocumentCompareTaskRequestDto)recordRequest));
                if (CollUtil.isNotEmpty(this.overInterfaces)) {
                    this.overInterfaces.forEach(item -> item.successBatchCall(dtoList));
                }
            }));
        }
        return dtoList;
    }

    private List<DocumentCompareTaskRequestDto> documentCompareBatchRequestDtoToDocumentCompareTaskRequestDtos(DocumentCompareBatchRequestDto vo) {
        ArrayList<DocumentCompareTaskRequestDto> taskDtos = new ArrayList<DocumentCompareTaskRequestDto>();
        for (int i = 0; i < vo.getTasks().size(); ++i) {
            for (int j = i + 1; j < vo.getTasks().size(); ++j) {
                if (((DocumentCompareBatchDto)vo.getTasks().get(i)).getFile().equals(((DocumentCompareBatchDto)vo.getTasks().get(j)).getFile())) continue;
                DocumentCompareTaskRequestDto taskRequestDto = new DocumentCompareTaskRequestDto();
                taskRequestDto.setReferenceFileId(((DocumentCompareBatchDto)vo.getTasks().get(i)).getFileId());
                taskRequestDto.setCompareFileId(((DocumentCompareBatchDto)vo.getTasks().get(j)).getFileId());
                taskRequestDto.setCompareFile(((DocumentCompareBatchDto)vo.getTasks().get(i)).getFile());
                taskRequestDto.setCompareFile(((DocumentCompareBatchDto)vo.getTasks().get(j)).getFile());
                taskRequestDto.setIsSync(vo.getIsSync());
                taskDtos.add(taskRequestDto);
            }
        }
        return taskDtos;
    }

    public IDPApiResponseDto delete(CompareRecordDeteleRequestDto deteleRequestDto) {
        this.documentCompareService.delBatch(deteleRequestDto.getFileId());
        return new IDPApiResponseDto();
    }

    public List<CompareResultResponseDto> getResultList(DocumentCompareResultRequestDto documentCompareResultRequestDto) {
        List<CompareResult> resultList = this.documentCompareService.getResultList(new CompareResultQuery(documentCompareResultRequestDto));
        ArrayList<CompareResultResponseDto> dtoList = new ArrayList<CompareResultResponseDto>();
        resultList.forEach(item -> dtoList.add(new CompareResultResponseDto(item)));
        return dtoList;
    }
}

