/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.compare.entity.dto.RecordFileInfo;
import com.jxdinfo.idp.compare.entity.po.CompareRecord;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import com.jxdinfo.idp.compare.entity.query.CompareRecordQuery;
import com.jxdinfo.idp.compare.entity.query.CompareResultQuery;
import com.jxdinfo.idp.compare.entity.vo.DocumentCompareVo;
import com.jxdinfo.idp.compare.service.IDocumentCompareService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/documentCompare"})
public class DocumentCompareController {
    @Autowired
    private IDocumentCompareService service;

    @PostMapping(value={"/list"})
    ApiResponse<Page<CompareRecord>> list(@RequestBody CompareRecordQuery query) {
        return ApiResponse.success(this.service.getPageList(query));
    }

    @PostMapping(value={"/execute"})
    ApiResponse<Long> execute(@RequestBody DocumentCompareVo vo) {
        try {
            return ApiResponse.success((Object)this.service.execute(vo));
        }
        catch (IOException e) {
            return ApiResponse.fail((String)"\u6267\u884c\u5931\u8d25");
        }
    }

    @PostMapping(value={"/delete"})
    ApiResponse<Long> delete(@RequestBody List<Long> id) {
        this.service.delBatch(id);
        return ApiResponse.success();
    }

    @PostMapping(value={"/resultList"})
    ApiResponse<List<CompareResult>> resultList(@RequestBody CompareResultQuery query) {
        return ApiResponse.success(this.service.getResultList(query));
    }

    @GetMapping(value={"/getRecordFileInfo"})
    ApiResponse<RecordFileInfo> getRecordFileInfo(@RequestParam(value="recordId") Long recordId) {
        return ApiResponse.data((Object)this.service.getRecordFileInfo(recordId));
    }
}

