/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.docparse.ReadWordUtil;
import com.jxdinfo.idp.compare.comparator.ComparatorFactory;
import com.jxdinfo.idp.compare.comparator.IDocumentComparator;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.entity.dto.CompareRecordDto;
import com.jxdinfo.idp.compare.entity.po.CompareRecord;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import com.jxdinfo.idp.compare.entity.query.CompareRecordQuery;
import com.jxdinfo.idp.compare.entity.vo.DocumentCompareVo;
import com.jxdinfo.idp.compare.service.ICompareRecordService;
import com.jxdinfo.idp.compare.service.ICompareResultService;
import com.jxdinfo.idp.compare.service.IDocumentCompareService;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentCompareServiceImpl
implements IDocumentCompareService {
    @Autowired
    private ICompareRecordService compareRecordService;
    @Autowired
    private ICompareResultService compareResultService;

    @Override
    public Page<CompareRecord> getPageList(CompareRecordQuery query) {
        return this.compareRecordService.pageList(query);
    }

    @Override
    public Page<CompareRecordDto> getDtoPageList(CompareRecordQuery query) {
        return this.compareRecordService.dtoPageList(query);
    }

    @Override
    public Long execute(DocumentCompareVo vo) throws IOException {
        FileBytesInfo reference = new FileBytesInfo();
        FileBytesInfo compare = new FileBytesInfo();
        reference.setFileBytes(vo.getReferenceFile().getBytes());
        reference.setFileFormat(DocumentCompareServiceImpl.getFileExtension(vo.getReferenceFile().getOriginalFilename()));
        reference.setFileName(vo.getReferenceFile().getOriginalFilename());
        compare.setFileBytes(vo.getCompareFile().getBytes());
        compare.setFileFormat(DocumentCompareServiceImpl.getFileExtension(vo.getCompareFile().getOriginalFilename()));
        compare.setFileName(vo.getCompareFile().getOriginalFilename());
        WordInfo rWordInfo = ReadWordUtil.getWordInfo((FileBytesInfo)reference);
        WordInfo cWordInfo = ReadWordUtil.getWordInfo((FileBytesInfo)compare);
        IDocumentComparator<?, ?> comparator = ComparatorFactory.get(DocumentComparatorEnum.WORD2WORD);
        List<CompareResult> results = comparator.compare(rWordInfo, cWordInfo);
        CompareRecord record = new CompareRecord();
        record.setId(Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
        record.setCreateTime(LocalDateTime.now());
        record.setReferenceFileName(reference.getFileName());
        record.setCompareFileName(compare.getFileName());
        results.forEach(result -> result.setRecordId(record.getId()));
        this.compareRecordService.save(record);
        this.compareResultService.saveBatch(results);
        return record.getId();
    }

    @Override
    public void delete(Long id) {
        this.compareRecordService.removeById(id);
        this.compareResultService.delByRecordId(id);
    }

    @Override
    public void delBatch(List<Long> ids) {
        this.compareRecordService.removeByIds(ids);
        this.compareResultService.delByRecordIds(ids);
    }

    @Override
    public List<CompareResult> getResultList(Long id) {
        return this.compareResultService.getListByRecordId(id);
    }

    public static String getFileExtension(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            return filename.substring(i + 1);
        }
        return "";
    }
}

