/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.compare.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordElementInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphInfo;
import com.jxdinfo.idp.common.util.docparse.ReadWordUtil;
import com.jxdinfo.idp.common.util.docparse.SignUtil;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.compare.comparator.ComparatorFactory;
import com.jxdinfo.idp.compare.comparator.IDocumentComparator;
import com.jxdinfo.idp.compare.comparator.enums.DocumentComparatorEnum;
import com.jxdinfo.idp.compare.entity.dto.ContrastFileInfoDto;
import com.jxdinfo.idp.compare.entity.dto.ContrastTaskDto;
import com.jxdinfo.idp.compare.entity.dto.DocContrastDto;
import com.jxdinfo.idp.compare.entity.po.CompareResult;
import com.jxdinfo.idp.compare.entity.po.ContrastResult;
import com.jxdinfo.idp.compare.entity.po.ContrastTask;
import com.jxdinfo.idp.compare.entity.po.DocSubtask;
import com.jxdinfo.idp.compare.entity.query.ContrastResultQuery;
import com.jxdinfo.idp.compare.entity.query.ContrastTaskQuery;
import com.jxdinfo.idp.compare.entity.query.DocContrastQuery;
import com.jxdinfo.idp.compare.entity.request.PDFContrastRequest;
import com.jxdinfo.idp.compare.service.IContrastResultService;
import com.jxdinfo.idp.compare.service.IContrastTaskService;
import com.jxdinfo.idp.compare.service.IDocContrastService;
import com.jxdinfo.idp.compare.service.IDocSubtaskService;
import com.jxdinfo.idp.compare.util.CompareUtil;
import com.jxdinfo.idp.compare.util.ReadPdfUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DocContrastServiceImpl
implements IDocContrastService {
    private static final Logger log = LoggerFactory.getLogger(DocContrastServiceImpl.class);
    public static Map<String, String> filePathCache = new HashMap<String, String>();
    @Autowired
    private IContrastTaskService taskService;
    @Autowired
    private IContrastResultService resultService;
    @Autowired
    private IDocSubtaskService subtaskService;
    private boolean compareFlag;

    @Override
    public Page<ContrastTaskDto> getTaskList(ContrastTaskQuery query) {
        return this.taskService.getPageList(query);
    }

    @Override
    public void deleteTask(DocContrastQuery query) throws JSchException, SftpException, IOException {
        this.taskService.delete(query);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String contrast(DocContrastDto dto) throws Exception {
        ContrastTask contrastTask = new ContrastTask();
        Long leftFileId = dto.getLeftFileId();
        contrastTask.setLeftFileId(leftFileId);
        if (filePathCache.containsKey(leftFileId)) {
            contrastTask.setLeftAnnexPath(filePathCache.get(leftFileId));
        }
        Long rightFileId = dto.getRightFileId();
        contrastTask.setRightFileId(rightFileId);
        if (filePathCache.containsKey(rightFileId)) {
            contrastTask.setRightAnnexPath(filePathCache.get(rightFileId));
        }
        contrastTask.setLeftFileSize(dto.getLeftSize());
        contrastTask.setRightFileSize(dto.getRightSize());
        String result = this.taskService.insert(contrastTask);
        this.contrast(contrastTask, dto);
        filePathCache.remove(leftFileId);
        filePathCache.remove(rightFileId);
        return result;
    }

    @Override
    public List<ContrastResult> getResultList(ContrastResultQuery query) {
        return this.resultService.getList(query);
    }

    @Override
    public void getStream(HttpServletResponse response, DocContrastQuery query) throws Exception {
    }

    @Override
    public ContrastTaskDto getTaskById(ContrastTaskQuery query) {
        ContrastTaskDto result = this.taskService.getById(query);
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        String[] Units = new String[]{"BYTE", "KB", "MB", "GB", "TB"};
        Double leftSize = result.getLeftFileSize();
        if (leftSize == null) {
            return result;
        }
        int leftPoint = 0;
        while (leftSize / 1024.0 > 1.0) {
            leftSize = leftSize / 1024.0;
            ++leftPoint;
        }
        result.setLeftUnit(Units[leftPoint]);
        result.setLeftFileSize(Double.valueOf(Double.parseDouble(decimalFormat.format(leftSize))));
        Double rightSize = result.getRightFileSize();
        int rightPoint = 0;
        while (rightSize / 1024.0 > 1.0) {
            rightSize = rightSize / 1024.0;
            ++rightPoint;
        }
        result.setRightUnit(Units[rightPoint]);
        result.setRightFileSize(Double.valueOf(Double.parseDouble(decimalFormat.format(rightSize))));
        return result;
    }

    private void contrast(ContrastTask contrastTask, DocContrastDto dto) throws Exception {
        dto.setCompareFlag(this.compareFlag);
        ArrayList<ContrastResult> contrastResultList = new ArrayList<ContrastResult>(this.allInfoContrast(contrastTask, dto));
        this.resultService.saveBatch(contrastResultList);
    }

    private String saveSubtask(Long fileId, Long docVersionId, String taskId) {
        DocSubtask subtask = new DocSubtask();
        subtask.setId(IdUtils.simpleUUID());
        subtask.setDocId(fileId);
        subtask.setDocVersionId(docVersionId);
        subtask.setTaskId(taskId);
        this.subtaskService.save(subtask);
        return subtask.getId();
    }

    public void turnPDFToDocx(FileBytesInfo FileInfo) throws Exception {
        PDDocument document = Loader.loadPDF((byte[])FileInfo.getFileBytes());
        ReadPdfUtil.removeTextWatermark(document);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        document.save((OutputStream)outputStream);
        FileInfo.setFileBytes(outputStream.toByteArray());
        PDFContrastRequest request = new PDFContrastRequest();
        request.setFile_type("PDF");
        request.setFilter_header_footer("1");
        request.setMerge_cross_paraph("1");
        Object entity = null;
        FileInfo.setFileBytes((byte[])entity.getBody());
        FileInfo.setFileFormat("docx");
    }

    private String getAllText(List<Element> elements) {
        StringBuilder buffer = new StringBuilder();
        for (Element element : elements) {
            buffer.append(SignUtil.text((String)element.toString()));
        }
        return buffer.toString();
    }

    private Element getTable(Element element) {
        Element parent = element.parent();
        if (parent != null) {
            if ("table".equals(parent.tagName())) {
                return parent;
            }
            return this.getTable(parent);
        }
        return null;
    }

    private List<ContrastResult> allInfoContrast(ContrastTask contrastTask, DocContrastDto query) throws Exception {
        FileBytesInfo rightFileInfo;
        FileBytesInfo leftFileInfo = null;
        if (leftFileInfo != null && "pdf".equals(leftFileInfo.getFileFormat())) {
            if (leftFileInfo.getFileBytes() == null) {
                this.turnPDFToDocx(leftFileInfo);
            }
            leftFileInfo.setFileFormat("docx");
        }
        if ((rightFileInfo = null) != null && "pdf".equals(rightFileInfo.getFileFormat())) {
            if (rightFileInfo.getFileBytes() == null) {
                this.turnPDFToDocx(rightFileInfo);
            }
            rightFileInfo.setFileFormat("docx");
        }
        ContrastFileInfoDto fileInfoDto = new ContrastFileInfoDto();
        fileInfoDto.setLeftFileInfo(leftFileInfo);
        fileInfoDto.setRightFileInfo(rightFileInfo);
        fileInfoDto.setId(contrastTask.getId());
        List<ContrastResult> paragraphContrast = this.ParagraphContrast(fileInfoDto, query);
        ArrayList<ContrastResult> results = new ArrayList<ContrastResult>(paragraphContrast);
        WordInfo wordInfo1 = ReadWordUtil.getWordInfo((FileBytesInfo)fileInfoDto.getLeftFileInfo());
        WordInfo wordInfo2 = ReadWordUtil.getWordInfo((FileBytesInfo)fileInfoDto.getRightFileInfo());
        IDocumentComparator<?, ?> comparator = ComparatorFactory.get(DocumentComparatorEnum.WORD2WORD);
        List<CompareResult> compareResults = comparator.compare(wordInfo1, wordInfo2);
        for (CompareResult compareResult : compareResults) {
            ContrastResult result = new ContrastResult();
            result.setTaskId(fileInfoDto.getId());
            result.setElementType("paragraph");
            result.setElementName("");
            result.setLeftResult(compareResult.getReferenceContent());
            result.setRightResult(compareResult.getCompareContent());
            results.add(result);
        }
        return results;
    }

    private List<ContrastResult> ParagraphContrast(ContrastFileInfoDto fileInfoDto, DocContrastDto query) throws Exception {
        WordInfo leftWordStructureInfo = ReadWordUtil.getWordInfo((FileBytesInfo)fileInfoDto.getLeftFileInfo());
        ArrayList<WordParagraphInfo> leftParagraphs = new ArrayList<WordParagraphInfo>();
        for (WordElementInfo leftPara : leftWordStructureInfo.getParaInfos()) {
            WordParagraphInfo paragraphInfo = (WordParagraphInfo)leftPara;
            leftParagraphs.add(paragraphInfo);
        }
        WordInfo rightWordStructureInfo = ReadWordUtil.getWordInfo((FileBytesInfo)fileInfoDto.getRightFileInfo());
        ArrayList<WordParagraphInfo> rightParagraphs = new ArrayList<WordParagraphInfo>();
        for (WordElementInfo rightPara : rightWordStructureInfo.getParaInfos()) {
            WordParagraphInfo paragraphInfo = (WordParagraphInfo)rightPara;
            rightParagraphs.add(paragraphInfo);
        }
        List<ContrastResult> contrastResultList = CompareUtil.compareParagraph(leftParagraphs, rightParagraphs, 1, query);
        if (!contrastResultList.isEmpty()) {
            for (ContrastResult result : contrastResultList) {
                result.setTaskId(fileInfoDto.getId());
            }
        }
        return contrastResultList;
    }
}

